/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.jira.config.AbstractIssueConstantsManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.priority.PriorityImpl;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultPriorityManager
extends AbstractIssueConstantsManager<Priority>
implements PriorityManager {
    private final TranslationManager translationManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ApplicationProperties applicationProperties;
    private static final Logger log = Logger.getLogger(DefaultPriorityManager.class);

    public DefaultPriorityManager(ConstantsManager constantsManager, TranslationManager translationManager, JiraAuthenticationContext jiraAuthenticationContext, OfBizDelegator ofBizDelegator, IssueIndexManager issueIndexManager, ApplicationProperties applicationProperties) {
        super(constantsManager, ofBizDelegator, issueIndexManager);
        this.translationManager = translationManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public synchronized Priority createPriority(String name, String description, String iconUrl, String color) {
        Assertions.notBlank("name", name);
        Assertions.notBlank("iconUrl", iconUrl);
        Assertions.notBlank("color", color);
        for (Priority priority : this.constantsManager.getPriorityObjects()) {
            if (!name.trim().equalsIgnoreCase(priority.getName())) continue;
            throw new IllegalStateException("A priority with the name '" + name + "' already exists.");
        }
        try {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("name", name);
            fields.put("description", description);
            fields.put("id", this.getNextStringId());
            fields.put("iconurl", iconUrl);
            fields.put("statusColor", color);
            fields.put("sequence", new Long(this.getMaxSequenceNo() + 1L));
            GenericValue resolutionGenericValue = this.createConstant(fields);
            PriorityImpl priorityImpl = new PriorityImpl(resolutionGenericValue, this.translationManager, this.jiraAuthenticationContext);
            return priorityImpl;
        }
        catch (GenericEntityException ex) {
            throw new DataAccessException("Failed to create a priority with name '" + name + "'", ex);
        }
        finally {
            this.constantsManager.refreshPriorities();
        }
    }

    @Override
    public void editPriority(Priority priority, String name, String description, String iconUrl, String color) {
        Assertions.notNull("priority", priority);
        Assertions.notBlank("name", name);
        Assertions.notBlank("iconUrl", iconUrl);
        Assertions.notBlank("color", color);
        for (Priority prio : this.getPriorities()) {
            if (!name.equalsIgnoreCase(prio.getName()) || priority.getId().equals(prio.getId())) continue;
            throw new IllegalStateException("Cannot rename priority. A priority with the name '" + name + "' exists already.");
        }
        try {
            priority.setName(name);
            priority.setDescription(description);
            priority.setIconUrl(iconUrl);
            priority.setStatusColor(color);
            priority.getGenericValue().store();
            this.clearCaches();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Failed to update priority '" + priority.getName() + "'", e);
        }
    }

    @Override
    public List<Priority> getPriorities() {
        return Lists.newArrayList(this.constantsManager.getPriorityObjects());
    }

    @Override
    public void removePriority(String id, String newPriorityId) {
        Assertions.notBlank("id", id);
        Assertions.notBlank("newPriorityId", newPriorityId);
        Priority priority = this.getPriority(id);
        if (priority == null) {
            throw new IllegalArgumentException("A priority with id '" + id + "' does not exist.");
        }
        Priority newPriority = this.getPriority(newPriorityId);
        if (newPriority == null) {
            throw new IllegalArgumentException("A priority with id '" + newPriorityId + "' does not exist.");
        }
        try {
            this.removeConstant(this.getIssueConstantField(), priority, newPriority.getId());
        }
        catch (Exception ex) {
            throw new DataAccessException("Failed to remove priority '" + id + "'", ex);
        }
    }

    @Override
    public Priority getPriority(String id) {
        Assertions.notBlank("id", id);
        return this.constantsManager.getPriorityObject(id);
    }

    @Override
    public void setDefaultPriority(String id) {
        if (id != null && this.getPriority(id) == null) {
            throw new IllegalArgumentException("A priority with id '" + id + "' does not exist.");
        }
        this.applicationProperties.setString("jira.constant.default.priority", id);
    }

    @Override
    public Priority getDefaultPriority() {
        String priorityId = this.applicationProperties.getString("jira.constant.default.priority");
        if (StringUtils.isNotEmpty((String)priorityId)) {
            Priority priority = this.getPriority(priorityId);
            if (priority == null) {
                log.warn((Object)("Default priority with id '" + priorityId + "' does not exist."));
            }
            return priority;
        }
        return null;
    }

    @Override
    public void movePriorityUp(String id) {
        Priority priority = this.getPriority(id);
        if (priority == null) {
            throw new IllegalArgumentException("A priority with id '" + id + "' does not exist.");
        }
        this.moveUp(priority);
    }

    @Override
    public void movePriorityDown(String id) {
        Priority priority = this.getPriority(id);
        if (priority == null) {
            throw new IllegalArgumentException("A priority with id '" + id + "' does not exist.");
        }
        this.moveDown(priority);
    }

    protected List<Priority> getValues() {
        return this.getPriorities();
    }

    @Override
    protected void postProcess(Priority priority) {
        if (priority.getId().equals(this.applicationProperties.getString("jira.constant.default.priority"))) {
            this.applicationProperties.setString("jira.constant.default.priority", null);
        }
    }

    @Override
    protected void clearCaches() {
        this.constantsManager.refreshPriorities();
    }

    @Override
    protected String getIssueConstantField() {
        return "Priority";
    }

    @Override
    protected List<Priority> getAllValues() {
        return this.getPriorities();
    }
}

