/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.util.JiraLocaleUtils;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DefaultLocaleManager
implements LocaleManager {
    private final JiraLocaleUtils jiraLocaleUtils;

    public DefaultLocaleManager(JiraLocaleUtils jiraLocaleUtils) {
        this.jiraLocaleUtils = jiraLocaleUtils;
    }

    @Override
    public Set<Locale> getInstalledLocales() {
        LinkedHashSet<Locale> ret = new LinkedHashSet<Locale>(this.jiraLocaleUtils.getInstalledLocales());
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Map<String, String> getInstalledLocalesWithDefault(Locale defaultLocale, I18nHelper i18nHelper) {
        Map<String, String> installedLocalesWithDefault = this.jiraLocaleUtils.getInstalledLocalesWithDefault(defaultLocale, i18nHelper);
        return Collections.unmodifiableMap(installedLocalesWithDefault);
    }

    @Override
    public Locale getLocale(String locale) {
        return this.jiraLocaleUtils.getLocale(locale);
    }
}

