/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ChartUtilsImpl
implements ChartUtils {
    private static final Logger log = Logger.getLogger(ChartUtilsImpl.class);
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectManager projectManager;
    private final SearchService searchService;
    private final SearchRequestService searchRequestService;

    public ChartUtilsImpl(SearchRequestService searchRequestService, JiraAuthenticationContext authenticationContext, ProjectManager projectManager, SearchService searchService) {
        this.searchRequestService = searchRequestService;
        this.authenticationContext = authenticationContext;
        this.projectManager = projectManager;
        this.searchService = searchService;
    }

    @Override
    public SearchRequest retrieveOrMakeSearchRequest(String projectOrFilterId, Map<String, Object> params) {
        SearchRequest sr = null;
        User user = this.authenticationContext.getLoggedInUser();
        if (projectOrFilterId.startsWith("filter-")) {
            Long filterId = new Long(projectOrFilterId.substring(7));
            sr = this.searchRequestService.getFilter(new JiraServiceContextImpl(user, new SimpleErrorCollection()), filterId);
            if (sr != null) {
                params.put("searchRequest", sr);
            }
        } else if (projectOrFilterId.startsWith("project-")) {
            Long projectId = new Long(projectOrFilterId.substring(8));
            Project project = this.projectManager.getProjectObj(projectId);
            if (project != null) {
                sr = this.makeProjectSearchRequest(project.getKey());
                params.put("project", project);
            }
        } else if (projectOrFilterId.startsWith("jql-")) {
            String jql = projectOrFilterId.substring(4);
            sr = new SearchRequest();
            if (StringUtils.isNotBlank((String)jql)) {
                SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jql);
                if (parseResult.isValid()) {
                    sr = new SearchRequest(parseResult.getQuery());
                } else {
                    throw new IllegalArgumentException("Invalid JQL query specified for chart '" + jql + "'.");
                }
            }
            params.put("searchRequest", sr);
        }
        return sr;
    }

    private SearchRequest makeProjectSearchRequest(String projectKey) {
        return new SearchRequest(JqlQueryBuilder.newBuilder().where().project(projectKey).buildQuery());
    }
}

