/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.report;

import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.jfreechart.TimePeriodUtils;
import com.atlassian.jira.charts.report.AbstractChartReport;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.web.action.ProjectActionSupport;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreatedVsResolvedReport
extends AbstractChartReport {
    private static final Logger log = Logger.getLogger(CreatedVsResolvedReport.class);
    private final ChartFactory chartFactory;
    private final TimeZoneManager timeZoneManager;

    public CreatedVsResolvedReport(JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, ProjectManager projectManager, SearchRequestService searchRequestService, ChartUtils chartUtils, ChartFactory chartFactory, TimeZoneManager timeZoneManager) {
        super(authenticationContext, applicationProperties, projectManager, searchRequestService, chartUtils);
        this.chartFactory = chartFactory;
        this.timeZoneManager = timeZoneManager;
    }

    @Override
    public String generateReportHtml(ProjectActionSupport action, Map reqParams) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("report", this);
        params.put("action", action);
        params.put("indexing", this.applicationProperties.getOption("jira.option.indexing") ? Boolean.TRUE : Boolean.FALSE);
        params.put("user", this.authenticationContext.getLoggedInUser());
        params.put("timePeriods", new TimePeriodUtils(this.timeZoneManager));
        String projectOrFilterId = (String)reqParams.get("projectOrFilterId");
        ChartFactory.PeriodName periodName = ChartFactory.PeriodName.valueOf((String)reqParams.get("periodName"));
        int days = 30;
        if (reqParams.containsKey("daysprevious")) {
            days = Integer.parseInt((String)reqParams.get("daysprevious"));
        }
        ChartFactory.VersionLabel versionLabel = ChartFactory.VersionLabel.none;
        if (reqParams.containsKey("versionLabels")) {
            versionLabel = ChartFactory.VersionLabel.valueOf((String)reqParams.get("versionLabels"));
        }
        boolean cumulative = false;
        if (reqParams.containsKey("cumulative")) {
            cumulative = ((String)reqParams.get("cumulative")).equalsIgnoreCase("true");
        }
        boolean showUnresolvedTrend = "true".equalsIgnoreCase((String)reqParams.get("showUnresolvedTrend"));
        try {
            SearchRequest request = this.chartUtils.retrieveOrMakeSearchRequest(projectOrFilterId, params);
            params.put("projectOrFilterId", projectOrFilterId);
            ChartFactory.ChartContext context = new ChartFactory.ChartContext(this.authenticationContext.getLoggedInUser(), request, 800, 500);
            Chart chart = this.chartFactory.generateCreatedVsResolvedChart(context, days, periodName, versionLabel, cumulative, showUnresolvedTrend);
            params.putAll(chart.getParameters());
        }
        catch (Exception e) {
            log.error((Object)("Could not create velocity parameters " + e.getMessage()), (Throwable)e);
        }
        return this.descriptor.getHtml("view", params);
    }
}

