/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.portlet;

import com.atlassian.configurable.ValuesGenerator;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.DateField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class DateFieldValuesGenerator
implements ValuesGenerator {
    @Override
    public Map getValues(Map userParams) {
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        FieldManager fieldManager = this.getFieldManager();
        try {
            ArrayList<NavigableField> navigableFields = new ArrayList<NavigableField>(fieldManager.getAllAvailableNavigableFields());
            Collections.sort(navigableFields);
            for (Field field : navigableFields) {
                if (!this.isDateTypeField(field, fieldManager)) continue;
                fields.put(field.getId(), field.getName());
            }
        }
        catch (FieldException e) {
            return fields;
        }
        return fields;
    }

    private boolean isDateTypeField(Field field, FieldManager fieldManager) {
        if (fieldManager.isCustomField(field)) {
            CustomFieldType customFieldType = ((CustomField)field).getCustomFieldType();
            return customFieldType instanceof DateField;
        }
        return field instanceof DateField;
    }

    FieldManager getFieldManager() {
        return ComponentManager.getComponentInstanceOfType(FieldManager.class);
    }
}

