/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.jfreechart;

import com.atlassian.jira.charts.jfreechart.ChartGenerator;
import com.atlassian.jira.charts.jfreechart.ChartHelper;
import com.atlassian.jira.charts.jfreechart.util.ChartDefaults;
import com.atlassian.jira.charts.jfreechart.util.ChartUtil;
import com.atlassian.jira.web.bean.I18nBean;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.NumberFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;

public class HistogramChartGenerator
implements ChartGenerator {
    private final TimeSeriesCollection dataset;
    private final String yLabel;
    private I18nBean i18nBean;

    public HistogramChartGenerator(TimeSeriesCollection dataset, String yLabel, I18nBean i18nBean) {
        this.dataset = dataset;
        this.yLabel = yLabel;
        this.i18nBean = i18nBean;
    }

    @Override
    public ChartHelper generateChart() {
        boolean legend = false;
        boolean tooltips = false;
        boolean urls = false;
        JFreeChart chart = ChartFactory.createHistogram(null, null, (String)this.yLabel, (IntervalXYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)tooltips, (boolean)urls);
        HistogramChartGenerator.setHistogramChartDefaults(chart, this.i18nBean);
        chart.setBorderVisible(false);
        return new ChartHelper(chart);
    }

    private static void setHistogramChartDefaults(JFreeChart chart, I18nBean i18nBean) {
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setDomainAxis((ValueAxis)new DateAxis());
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        ChartUtil.setDefaults(chart, i18nBean);
        plot.setAxisOffset(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
        renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        renderer.setShadowVisible(false);
        renderer.setBaseItemLabelFont(ChartDefaults.defaultFont);
        renderer.setBaseItemLabelsVisible(false);
        renderer.setMargin(0.2);
        renderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER));
        renderer.setBaseItemLabelGenerator((XYItemLabelGenerator)new StandardXYItemLabelGenerator());
        renderer.setBaseItemLabelPaint((Paint)ChartDefaults.axisLabelColor);
        StandardXYToolTipGenerator generator = new StandardXYToolTipGenerator("{1}, {2}", DateFormat.getInstance(), NumberFormat.getInstance());
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)generator);
        renderer.setDrawBarOutline(false);
        for (int j = 0; j < ChartDefaults.darkColors.length; ++j) {
            renderer.setSeriesPaint(j, (Paint)ChartDefaults.darkColors[j]);
        }
    }
}

