/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.jfreechart.ChartHelper;
import com.atlassian.jira.charts.jfreechart.HistogramChartGenerator;
import com.atlassian.jira.charts.jfreechart.util.ChartUtil;
import com.atlassian.jira.charts.util.DataUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.util.RedundantClausesQueryOptimizer;
import com.atlassian.jira.issue.statistics.DatePeriodStatisticsMapper;
import com.atlassian.jira.issue.statistics.util.DocumentHitCollector;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.util.LuceneUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.Query;
import com.atlassian.query.operator.Operator;
import com.atlassian.query.order.SortOrder;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.TimeSeriesURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;

class TimeSinceChart {
    private final FieldManager fieldManager;
    private final SearchProvider searchProvider;
    private final IssueIndexManager issueIndexManager;
    private final SearchService searchService;
    private final ApplicationProperties applicationProperties;
    private final TimeZone chartTimeZone;

    public TimeSinceChart(FieldManager fieldManager, SearchProvider searchProvider, IssueIndexManager issueIndexManager, SearchService searchService, ApplicationProperties applicationProperties, TimeZone chartTimeZone) {
        this.fieldManager = fieldManager;
        this.searchProvider = searchProvider;
        this.issueIndexManager = issueIndexManager;
        this.searchService = searchService;
        this.applicationProperties = applicationProperties;
        this.chartTimeZone = chartTimeZone;
    }

    public Chart generateChart(final User remoteUser, final SearchRequest searchRequest, int days, final ChartFactory.PeriodName periodName, int width, int height, boolean cumulative, final String dateFieldId) {
        Assertions.notNull("searchRequest", searchRequest);
        Assertions.notNull("dateFieldId", dateFieldId);
        try {
            final Field dateField = this.fieldManager.getField(dateFieldId);
            days = DataUtils.normalizeDaysValue(days, periodName);
            JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder(searchRequest.getQuery());
            JqlClauseBuilder whereClauseBuilder = queryBuilder.where().defaultAnd();
            whereClauseBuilder.addStringCondition(dateFieldId, Operator.GREATER_THAN_EQUALS, "-" + days + "d");
            final TreeMap<RegularTimePeriod, Number> matchingIssues = new TreeMap<RegularTimePeriod, Number>();
            Class timePeriodClass = ChartUtil.getTimePeriodClass(periodName);
            GenericDateFieldIssuesHitCollector hitCollector = new GenericDateFieldIssuesHitCollector(matchingIssues, this.issueIndexManager.getIssueSearcher(), timePeriodClass, dateFieldId, this.chartTimeZone);
            Query query = whereClauseBuilder.buildQuery();
            this.searchProvider.search(query, remoteUser, hitCollector);
            DataUtils.normaliseDateRangeCount(matchingIssues, days - 1, timePeriodClass, this.chartTimeZone);
            final I18nBean i18nBean = new I18nBean(remoteUser);
            TimeSeriesCollection originalDataset = DataUtils.getTimeSeriesCollection(Lists.newArrayList((Object[])new Map[]{matchingIssues}), new String[]{dateField.getName()}, timePeriodClass);
            int numIssues = DataUtils.getTotalNumber(matchingIssues);
            if (cumulative) {
                DataUtils.makeCumulative(matchingIssues);
            }
            TimeSeriesCollection dataset = DataUtils.getTimeSeriesCollection(Lists.newArrayList((Object[])new Map[]{matchingIssues}), new String[]{i18nBean.getText("datacollector.createdresolved")}, timePeriodClass);
            ChartHelper helper = new HistogramChartGenerator(dataset, i18nBean.getText("common.concepts.issues"), i18nBean).generateChart();
            JFreeChart chart = helper.getChart();
            XYPlot plot = (XYPlot)chart.getPlot();
            XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
            renderer.setToolTipGenerator(new XYToolTipGenerator(){

                public String generateToolTip(XYDataset xyDataset, int row, int col) {
                    TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)xyDataset;
                    TimeSeries timeSeries = timeSeriesCollection.getSeries(row);
                    TimeSeriesDataItem item = timeSeries.getDataItem(col);
                    RegularTimePeriod period = item.getPeriod();
                    int total = ((Number)matchingIssues.get(period)).intValue();
                    return period.toString() + ": " + total + " " + StringEscapeUtils.escapeHtml((String)dateField.getName()) + " " + i18nBean.getText("datacollector.tooltip.issues") + ".";
                }
            });
            final VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext();
            TimeSeriesURLGenerator urlGenerator = new TimeSeriesURLGenerator(){

                public String generateURL(XYDataset xyDataset, int row, int col) {
                    TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)xyDataset;
                    TimeSeries timeSeries = timeSeriesCollection.getSeries(row);
                    TimeSeriesDataItem item = timeSeries.getDataItem(col);
                    RegularTimePeriod period = item.getPeriod();
                    DatePeriodStatisticsMapper createdMapper = new DatePeriodStatisticsMapper(ChartUtil.getTimePeriodClass(periodName), dateFieldId, TimeSinceChart.this.chartTimeZone);
                    SearchRequest searchUrlSuffix = createdMapper.getSearchUrlSuffix(period, searchRequest);
                    JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder();
                    jqlQueryBuilder.where().addClause(searchUrlSuffix.getQuery().getWhereClause());
                    jqlQueryBuilder.orderBy().setSorts(searchUrlSuffix.getQuery().getOrderByClause());
                    jqlQueryBuilder.orderBy().addSortForFieldName(dateFieldId, SortOrder.DESC, true);
                    RedundantClausesQueryOptimizer optimizer = new RedundantClausesQueryOptimizer();
                    Query query = optimizer.optimizeQuery(jqlQueryBuilder.buildQuery());
                    return velocityRequestContext.getCanonicalBaseUrl() + "/secure/IssueNavigator.jspa?reset=true" + TimeSinceChart.this.searchService.getQueryString(remoteUser, query);
                }
            };
            renderer.setURLGenerator((XYURLGenerator)urlGenerator);
            plot.setRenderer((XYItemRenderer)renderer);
            helper.generate(width, height);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chart", helper.getLocation());
            params.put("chartDataset", dataset);
            params.put("completeDataset", originalDataset);
            params.put("completeDatasetUrlGenerator", urlGenerator);
            params.put("numIssues", numIssues);
            params.put("period", periodName.toString());
            params.put("imagemap", helper.getImageMap());
            params.put("imagemapName", helper.getImageMapName());
            params.put("field", dateField);
            params.put("daysPrevious", days);
            params.put("cumulative", cumulative);
            params.put("dateField", dateFieldId);
            params.put("chartFilterUrl", "/secure/IssueNavigator.jspa?reset=true" + this.searchService.getQueryString(remoteUser, query));
            return new Chart(helper.getLocation(), helper.getImageMap(), helper.getImageMapName(), params);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating chart", e);
        }
        catch (SearchException e) {
            throw new RuntimeException("Error generating chart", e);
        }
    }

    static class GenericDateFieldIssuesHitCollector
    extends DocumentHitCollector {
        private final Map<RegularTimePeriod, Number> resolvedMap;
        private final Class timePeriodClass;
        private final String dateFieldId;
        private final TimeZone timeZone;

        public GenericDateFieldIssuesHitCollector(Map<RegularTimePeriod, Number> resolvedMap, IndexSearcher searcher, Class timePeriodClass, String dateFieldId, TimeZone timeZone) {
            super(searcher);
            this.resolvedMap = resolvedMap;
            this.timePeriodClass = timePeriodClass;
            this.dateFieldId = dateFieldId;
            this.timeZone = timeZone;
        }

        @Override
        public void collect(Document d) {
            Date date = LuceneUtils.stringToDate(d.get(this.dateFieldId));
            RegularTimePeriod period = RegularTimePeriod.createInstance((Class)this.timePeriodClass, (Date)date, (TimeZone)this.timeZone);
            this.incrementMap(this.resolvedMap, period);
        }

        private void incrementMap(Map<RegularTimePeriod, Number> map, RegularTimePeriod period) {
            Number count = map.get(period);
            if (count == null) {
                count = 0;
            }
            map.put(period, count.intValue() + 1);
        }
    }
}

