/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts;

import com.atlassian.core.util.DateUtils;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.jfreechart.ChartHelper;
import com.atlassian.jira.charts.jfreechart.HistogramChartGenerator;
import com.atlassian.jira.charts.jfreechart.util.ChartUtil;
import com.atlassian.jira.charts.util.DataUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.util.RedundantClausesQueryOptimizer;
import com.atlassian.jira.issue.statistics.DatePeriodStatisticsMapper;
import com.atlassian.jira.issue.statistics.util.DocumentHitCollector;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.util.LuceneUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.TimeSeriesURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;

class DateRangeTimeChart {
    private final SearchProvider searchProvider;
    private final IssueIndexManager issueIndexManager;
    private final SearchService searchService;
    private final ApplicationProperties applicationProperties;
    private final TimeZoneManager timeZoneManager;

    public DateRangeTimeChart(SearchProvider searchProvider, IssueIndexManager issueIndexManager, SearchService searchService, ApplicationProperties applicationProperties, TimeZoneManager timeZoneManager) {
        this.searchProvider = searchProvider;
        this.issueIndexManager = issueIndexManager;
        this.searchService = searchService;
        this.applicationProperties = applicationProperties;
        this.timeZoneManager = timeZoneManager;
    }

    public Chart generateChart(final User remoteUser, final String dateFieldId, final SearchRequest searchRequest, int days, final ChartFactory.PeriodName periodName, int width, int height, long yAxisTimePeriod, String labelSuffixKey) {
        Assertions.notNull("searchRequest", searchRequest);
        Assertions.notNull("dateFieldId", dateFieldId);
        days = DataUtils.normalizeDaysValue(days, periodName);
        try {
            JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder(searchRequest.getQuery());
            JqlClauseBuilder whereClauseBuilder = queryBuilder.where().defaultAnd();
            whereClauseBuilder.addStringCondition(dateFieldId, Operator.GREATER_THAN_EQUALS, "-" + days + "d");
            TimeSeriesCollection dataset = this.getAverageOpenTimes(whereClauseBuilder.buildQuery(), remoteUser, periodName, days, dateFieldId, yAxisTimePeriod);
            I18nBean i18nBean = this.getI18nBean(remoteUser);
            TimeSeriesCollection chartDataset = DataUtils.reduceDataset(dataset, Lists.newArrayList((Object[])new String[]{i18nBean.getText("datacollector.averageresolution")}));
            ChartHelper helper = new HistogramChartGenerator(chartDataset, i18nBean.getText(this.getTimePeriodi18nName(yAxisTimePeriod)), i18nBean).generateChart();
            JFreeChart chart = helper.getChart();
            XYPlot plot = (XYPlot)chart.getPlot();
            XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
            renderer.setToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{1}: {2} " + i18nBean.getText(labelSuffixKey), (DateFormat)new SimpleDateFormat("dd-MMMMM-yyyy", i18nBean.getLocale()), NumberFormat.getInstance()));
            final VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext();
            TimeSeriesURLGenerator urlGenerator = new TimeSeriesURLGenerator(){

                public String generateURL(XYDataset xyDataset, int row, int col) {
                    TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)xyDataset;
                    TimeSeries timeSeries = timeSeriesCollection.getSeries(row);
                    if (row == 0) {
                        Query query;
                        TimeSeriesDataItem item = timeSeries.getDataItem(col);
                        RegularTimePeriod period = item.getPeriod();
                        DatePeriodStatisticsMapper createdMapper = new DatePeriodStatisticsMapper(ChartUtil.getTimePeriodClass(periodName), dateFieldId, DateRangeTimeChart.this.timeZoneManager.getLoggedInUserTimeZone());
                        SearchRequest searchUrlSuffix = createdMapper.getSearchUrlSuffix(period, searchRequest);
                        if (searchUrlSuffix == null) {
                            query = new QueryImpl();
                        } else {
                            RedundantClausesQueryOptimizer optimizer = new RedundantClausesQueryOptimizer();
                            query = optimizer.optimizeQuery(searchUrlSuffix.getQuery());
                        }
                        return velocityRequestContext.getCanonicalBaseUrl() + "/secure/IssueNavigator.jspa?reset=true" + DateRangeTimeChart.this.searchService.getQueryString(remoteUser, query);
                    }
                    return null;
                }
            };
            renderer.setURLGenerator((XYURLGenerator)urlGenerator);
            plot.setRenderer((XYItemRenderer)renderer);
            TimeSeries series = dataset.getSeries(0);
            List resolvedIssuesCount = series.getItems();
            Integer totalIssuesCount = 0;
            if (resolvedIssuesCount != null) {
                for (TimeSeriesDataItem timeSeriesDataItem : resolvedIssuesCount) {
                    Number value = timeSeriesDataItem.getValue();
                    totalIssuesCount = totalIssuesCount + (value == null ? 0 : value.intValue());
                }
            }
            helper.generate(width, height);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chart", helper.getLocation());
            params.put("chartDataset", chartDataset);
            params.put("numIssues", totalIssuesCount);
            params.put("completeDataset", dataset);
            params.put("completeDatasetUrlGenerator", urlGenerator);
            params.put("daysPrevious", days);
            params.put("period", periodName.toString());
            params.put("imagemap", helper.getImageMap());
            params.put("imagemapName", helper.getImageMapName());
            return new Chart(helper.getLocation(), helper.getImageMap(), helper.getImageMapName(), params);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating chart", e);
        }
        catch (SearchException e) {
            throw new RuntimeException("Error generating chart", e);
        }
    }

    private TimeSeriesCollection getAverageOpenTimes(Query query, User remoteUser, ChartFactory.PeriodName periodName, int days, String dateFieldId, long yAxisTimePeriodSizeInMillis) throws IOException, SearchException {
        Class timePeriodClass = ChartUtil.getTimePeriodClass(periodName);
        TimeZone timePeriodZone = this.timeZoneManager.getLoggedInUserTimeZone();
        DatePeriodStatisticsMapper createdMapper = new DatePeriodStatisticsMapper(timePeriodClass, "created", timePeriodZone);
        DatePeriodStatisticsMapper dateMapper = new DatePeriodStatisticsMapper(timePeriodClass, dateFieldId, timePeriodZone);
        TreeMap<RegularTimePeriod, List<Long>> allOpenTimes = new TreeMap<RegularTimePeriod, List<Long>>();
        this.searchProvider.search(query, remoteUser, new DateRangeObjectHitCollector(createdMapper.getDocumentConstant(), dateMapper.getDocumentConstant(), allOpenTimes, this.issueIndexManager.getIssueSearcher(), timePeriodClass, timePeriodZone));
        DataUtils.normaliseDateRange(allOpenTimes, days - 1, timePeriodClass, timePeriodZone);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        I18nBean i18nBean = this.getI18nBean(remoteUser);
        TimeSeries countSeries = new TimeSeries((Comparable)((Object)i18nBean.getText("datacollector.issuesresolvedcapital")), timePeriodClass);
        TimeSeries totalSeries = new TimeSeries((Comparable)((Object)i18nBean.getText("datacollector.totalresolvetime")), timePeriodClass);
        TimeSeries averageSeries = new TimeSeries((Comparable)((Object)i18nBean.getText("datacollector.averageresolvetime")), timePeriodClass);
        for (Map.Entry entry : allOpenTimes.entrySet()) {
            RegularTimePeriod period = (RegularTimePeriod)entry.getKey();
            List times = (List)entry.getValue();
            long total = 0L;
            long average = 0L;
            if (times != null) {
                for (Long time : times) {
                    total += time.longValue();
                }
                if (times.size() > 0) {
                    average = total / (long)times.size();
                }
                if (total == 0L && times.size() == 1) {
                    countSeries.add(period, 0.0);
                } else {
                    countSeries.add(period, (double)times.size());
                }
            }
            totalSeries.add(period, (double)(total / yAxisTimePeriodSizeInMillis));
            averageSeries.add(period, (double)(average / yAxisTimePeriodSizeInMillis));
        }
        dataset.addSeries(countSeries);
        dataset.addSeries(totalSeries);
        dataset.addSeries(averageSeries);
        return dataset;
    }

    private I18nBean getI18nBean(User remoteUser) {
        return new I18nBean(remoteUser);
    }

    private String getTimePeriodi18nName(long timePeriodLength) {
        if (DateUtils.DAY_MILLIS == timePeriodLength) {
            return "datacollector.days";
        }
        if (DateUtils.HOUR_MILLIS == timePeriodLength) {
            return "datacollector.hours";
        }
        return "";
    }

    static class DateRangeObjectHitCollector
    extends DocumentHitCollector {
        private String dateDocumentConstant1;
        private String dateDocumentConstant2;
        private final Map<RegularTimePeriod, List<Long>> result;
        private final Class timePeriodClass;
        private final TimeZone periodTimeZone;

        public DateRangeObjectHitCollector(String dateDocumentConstant1, String dateDocumentConstant2, Map<RegularTimePeriod, List<Long>> result, IndexSearcher searcher, Class timePeriodClass, TimeZone periodTimeZone) {
            super(searcher);
            this.dateDocumentConstant1 = dateDocumentConstant1;
            this.dateDocumentConstant2 = dateDocumentConstant2;
            this.result = result;
            this.timePeriodClass = timePeriodClass;
            this.periodTimeZone = periodTimeZone;
        }

        @Override
        public void collect(Document d) {
            Date creationDate = LuceneUtils.stringToDate(d.get(this.dateDocumentConstant1));
            Date otherDate = LuceneUtils.stringToDate(d.get(this.dateDocumentConstant2));
            RegularTimePeriod period = RegularTimePeriod.createInstance((Class)this.timePeriodClass, (Date)otherDate, (TimeZone)this.periodTimeZone);
            List<Long> values = this.result.get(period);
            if (values == null) {
                values = new ArrayList<Long>();
            }
            values.add(otherDate.getTime() - creationDate.getTime());
            this.result.put(period, values);
        }
    }
}

