/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts;

import com.atlassian.core.util.DateUtils;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.jfreechart.ChartHelper;
import com.atlassian.jira.charts.jfreechart.CreatedVsResolvedChartGenerator;
import com.atlassian.jira.charts.jfreechart.util.ChartUtil;
import com.atlassian.jira.charts.util.DataUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.transformer.ProjectSearchInputTransformer;
import com.atlassian.jira.issue.statistics.DatePeriodStatisticsMapper;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.util.OneDimensionalObjectHitCollector;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

class CreatedVsResolvedChart {
    private final SearchProvider searchProvider;
    private final VersionManager versionManager;
    private final IssueIndexManager issueIndexManager;
    private final IssueSearcherManager issueSearcherManager;
    private final ProjectManager projectManager;
    private final ApplicationProperties applicationProperties;
    private final SearchService searchService;
    private final TimeZoneManager timeZoneManager;

    public CreatedVsResolvedChart(SearchProvider searchProvider, VersionManager versionManager, IssueIndexManager issueIndexManager, IssueSearcherManager issueSearcherManager, ProjectManager projectManager, ApplicationProperties applicationProperties, SearchService searchService, TimeZoneManager timeZoneManager) {
        this.searchProvider = searchProvider;
        this.versionManager = versionManager;
        this.issueIndexManager = issueIndexManager;
        this.issueSearcherManager = issueSearcherManager;
        this.projectManager = projectManager;
        this.applicationProperties = applicationProperties;
        this.searchService = searchService;
        this.timeZoneManager = timeZoneManager;
    }

    public Chart generateChart(final User remoteUser, final SearchRequest searchRequest, int days, final ChartFactory.PeriodName periodName, ChartFactory.VersionLabel versionLabel, final boolean cumulative, boolean showUnresolvedTrend, int width, int height) {
        Assertions.notNull("searchrequest", searchRequest);
        days = DataUtils.normalizeDaysValue(days, periodName);
        try {
            String[] stringArray;
            Map[] mapArray;
            HashMap<String, Object> params = new HashMap<String, Object>();
            Query query = searchRequest.getQuery();
            SearchContext searchContext = this.searchService.getSearchContext(remoteUser, query);
            List domainMarkers = null;
            IssueSearcher<?> projectSearcher = this.issueSearcherManager.getSearcher("project");
            ProjectSearchInputTransformer searchInputTransformer = (ProjectSearchInputTransformer)projectSearcher.getSearchInputTransformer();
            Set<String> projectIds = searchInputTransformer.getIdValuesAsStrings(remoteUser, query, searchContext);
            if (projectIds != null && !ChartFactory.VersionLabel.none.equals((Object)versionLabel)) {
                domainMarkers = this.getDomainMarkers(projectIds, days, periodName, versionLabel);
            }
            JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder(query);
            JqlClauseBuilder whereClauseBuilder = jqlQueryBuilder.where().defaultAnd();
            whereClauseBuilder.createdAfter("-" + days + "d");
            Map<RegularTimePeriod, Number> createdDataMap = this.getCreatedIssues(whereClauseBuilder.buildQuery(), remoteUser, periodName);
            jqlQueryBuilder = JqlQueryBuilder.newBuilder(query);
            whereClauseBuilder = jqlQueryBuilder.where().defaultAnd();
            whereClauseBuilder.resolutionDateAfter("-" + days + "d");
            Map<RegularTimePeriod, Number> resolvedDataMap = this.getResolvedIssues(whereClauseBuilder.buildQuery(), remoteUser, periodName);
            params.put("numCreatedIssues", DataUtils.getTotalNumber(createdDataMap));
            params.put("numResolvedIssues", DataUtils.getTotalNumber(resolvedDataMap));
            Class timePeriodClass = ChartUtil.getTimePeriodClass(periodName);
            DataUtils.normaliseDateRangeCount(createdDataMap, days - 1, timePeriodClass, this.timeZoneManager.getLoggedInUserTimeZone());
            DataUtils.normaliseMapKeys(createdDataMap, resolvedDataMap);
            TreeMap<RegularTimePeriod, Integer> unresolvedTrendDataMap = new TreeMap<RegularTimePeriod, Integer>();
            if (showUnresolvedTrend) {
                int unresolvedTrend = 0;
                for (RegularTimePeriod key : createdDataMap.keySet()) {
                    Integer created = (Integer)createdDataMap.get(key);
                    Integer resolved = (Integer)resolvedDataMap.get(key);
                    unresolvedTrend = unresolvedTrend + created - resolved;
                    unresolvedTrendDataMap.put(key, unresolvedTrend);
                }
            }
            I18nBean i18nBean = this.getI18nBean(remoteUser);
            String created = i18nBean.getText("issue.field.created");
            String resolved = i18nBean.getText("portlet.createdvsresolved.resolved");
            String unresolvedTrend = i18nBean.getText("portlet.createdvsresolved.trendOfUnresolved");
            if (showUnresolvedTrend) {
                Map[] mapArray2 = new Map[3];
                mapArray2[0] = createdDataMap;
                mapArray2[1] = resolvedDataMap;
                mapArray = mapArray2;
                mapArray2[2] = unresolvedTrendDataMap;
            } else {
                Map[] mapArray3 = new Map[2];
                mapArray3[0] = createdDataMap;
                mapArray = mapArray3;
                mapArray3[1] = resolvedDataMap;
            }
            Map[] dataMaps = mapArray;
            if (showUnresolvedTrend) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = created;
                stringArray2[1] = resolved;
                stringArray = stringArray2;
                stringArray2[2] = unresolvedTrend;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = created;
                stringArray = stringArray3;
                stringArray3[1] = resolved;
            }
            String[] seriesNames = stringArray;
            CategoryDataset dataset = this.getCategoryDataset(dataMaps, seriesNames);
            if (cumulative) {
                DataUtils.makeCumulative(createdDataMap);
                DataUtils.makeCumulative(resolvedDataMap);
            }
            XYDataset createdVsResolved = this.generateTimeSeriesXYDataset(created, createdDataMap, resolved, resolvedDataMap);
            TimeSeries trendSeries = null;
            if (showUnresolvedTrend) {
                trendSeries = this.createTimeSeries(unresolvedTrend, unresolvedTrendDataMap);
            }
            ChartHelper chartHelper = new CreatedVsResolvedChartGenerator(createdVsResolved, trendSeries, domainMarkers, i18nBean).generateChart();
            XYPlot plot = (XYPlot)chartHelper.getChart().getPlot();
            XYItemRenderer renderer = plot.getRenderer();
            renderer.setToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0} {2} " + i18nBean.getText("portlet.createdvsresolved.tooltip.issues"), NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance()));
            final VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext();
            XYURLGenerator xyurlGenerator = new XYURLGenerator(){

                public String generateURL(XYDataset xyDataset, int series, int item) {
                    TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)xyDataset;
                    if (!cumulative && series < timeSeriesCollection.getSeriesCount()) {
                        TimeSeries timeSeries = timeSeriesCollection.getSeries(series);
                        RegularTimePeriod timePeriod = timeSeries.getTimePeriod(item);
                        StatisticsMapper mapper = null;
                        if (series == 0) {
                            mapper = new DatePeriodStatisticsMapper(ChartUtil.getTimePeriodClass(periodName), "created", CreatedVsResolvedChart.this.getTimeZone());
                        } else if (series == 1) {
                            mapper = new DatePeriodStatisticsMapper(ChartUtil.getTimePeriodClass(periodName), "resolutiondate", CreatedVsResolvedChart.this.getTimeZone());
                        }
                        if (mapper != null) {
                            SearchRequest searchUrlSuffix = mapper.getSearchUrlSuffix(timePeriod, searchRequest);
                            return velocityRequestContext.getCanonicalBaseUrl() + "/secure/IssueNavigator.jspa?reset=true" + CreatedVsResolvedChart.this.searchService.getQueryString(remoteUser, searchUrlSuffix == null ? new QueryImpl() : searchUrlSuffix.getQuery());
                        }
                    }
                    return null;
                }
            };
            renderer.setURLGenerator(xyurlGenerator);
            chartHelper.generate(width, height);
            params.put("chart", chartHelper.getLocation());
            params.put("daysPrevious", days);
            params.put("chartDataset", createdVsResolved);
            params.put("trendSeries", trendSeries);
            params.put("completeDataset", dataset);
            params.put("completeDatasetUrlGenerator", xyurlGenerator);
            params.put("period", periodName.toString());
            params.put("cumulative", Boolean.toString(cumulative));
            params.put("showUnresolvedTrend", Boolean.toString(showUnresolvedTrend));
            params.put("versionLabels", versionLabel.toString());
            params.put("imagemap", chartHelper.getImageMap());
            params.put("imagemapName", chartHelper.getImageMapName());
            params.put("imageWidth", width);
            params.put("imageHeight", height);
            return new Chart(chartHelper.getLocation(), chartHelper.getImageMap(), chartHelper.getImageMapName(), params);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating chart", e);
        }
        catch (SearchException e) {
            throw new RuntimeException("Error generating chart", e);
        }
    }

    private TimeZone getTimeZone() {
        return this.timeZoneManager.getLoggedInUserTimeZone();
    }

    private List getDomainMarkers(Set<String> projectIds, int days, ChartFactory.PeriodName periodName, ChartFactory.VersionLabel versionLabel) {
        if (ChartFactory.VersionLabel.none.equals((Object)versionLabel) || projectIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List<Long> searchedProjectIds = this.transformToLongs(projectIds);
        HashSet<Version> versions = new HashSet<Version>();
        HashMap<Long, String> projectIdToNameMapping = new HashMap<Long, String>();
        for (Long searchedProjectId : searchedProjectIds) {
            Project projectObj;
            versions.addAll(this.versionManager.getVersionsUnarchived(searchedProjectId));
            if (searchedProjectIds.size() <= 1 || (projectObj = this.projectManager.getProjectObj(searchedProjectId)) == null) continue;
            projectIdToNameMapping.put(searchedProjectId, projectObj.getKey());
        }
        Date releasedAfter = new Date(System.currentTimeMillis() - (long)days * DateUtils.DAY_MILLIS);
        ArrayList<ValueMarker> markers = new ArrayList<ValueMarker>();
        Class periodClass = ChartUtil.getTimePeriodClass(periodName);
        for (Version version : versions) {
            if (version.getReleaseDate() == null || !releasedAfter.before(version.getReleaseDate())) continue;
            RegularTimePeriod timePeriod = RegularTimePeriod.createInstance((Class)periodClass, (Date)version.getReleaseDate(), (TimeZone)RegularTimePeriod.DEFAULT_TIME_ZONE);
            ValueMarker valueMarker = new ValueMarker((double)timePeriod.getFirstMillisecond());
            boolean isMinorVersion = this.isMinorVersion(version);
            if (ChartFactory.VersionLabel.major.equals((Object)versionLabel) && isMinorVersion) continue;
            if (isMinorVersion) {
                valueMarker.setPaint((Paint)Color.LIGHT_GRAY);
                valueMarker.setStroke((Stroke)new BasicStroke(1.0f));
            } else {
                valueMarker.setPaint((Paint)Color.GRAY);
                valueMarker.setStroke((Stroke)new BasicStroke(1.2f));
                valueMarker.setLabelPaint((Paint)Color.GRAY);
                String valueMarkerLabel = version.getName();
                Long projectId = version.getProjectObject().getId();
                if (projectIdToNameMapping.containsKey(projectId)) {
                    valueMarkerLabel = valueMarkerLabel + "[" + (String)projectIdToNameMapping.get(projectId) + "]";
                }
                valueMarker.setLabel(valueMarkerLabel);
            }
            markers.add(valueMarker);
        }
        return markers;
    }

    private List<Long> transformToLongs(Set<String> projects) {
        ArrayList<Long> ids = new ArrayList<Long>(projects.size());
        for (String idStr : projects) {
            Long id = this.getValueAsLong(idStr);
            if (id == null) continue;
            ids.add(id);
        }
        return ids;
    }

    private Long getValueAsLong(String value) {
        try {
            return new Long(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private CategoryDataset getCategoryDataset(Map[] dataMaps, String[] seriesNames) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        if (dataMaps.length != seriesNames.length) {
            throw new IllegalArgumentException("Number of datamaps and series names must be the equal.");
        }
        for (int i = 0; i < seriesNames.length; ++i) {
            String seriesName = seriesNames[i];
            Map data = dataMaps[i];
            for (RegularTimePeriod period : data.keySet()) {
                dataset.addValue((Number)data.get(period), (Comparable)((Object)seriesName), (Comparable)period);
            }
        }
        return dataset;
    }

    private XYDataset generateTimeSeriesXYDataset(String series1Name, Map series1Map, String series2Name, Map series2Map) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        if (series1Name != null && series1Map != null) {
            dataset.addSeries(this.createTimeSeries(series1Name, series1Map));
        }
        if (series2Name != null && series2Map != null) {
            dataset.addSeries(this.createTimeSeries(series2Name, series2Map));
        }
        return dataset;
    }

    private TimeSeries createTimeSeries(String seriesName, Map seriesMap) {
        TimeSeries series = null;
        for (RegularTimePeriod period : seriesMap.keySet()) {
            if (series == null) {
                series = new TimeSeries((Comparable)((Object)seriesName), period.getClass());
            }
            series.add(period, (Number)seriesMap.get(period));
        }
        return series;
    }

    private Map<RegularTimePeriod, Number> getCreatedIssues(Query query, User remoteUser, ChartFactory.PeriodName periodName) throws IOException, SearchException {
        DatePeriodStatisticsMapper createdMapper = new DatePeriodStatisticsMapper(ChartUtil.getTimePeriodClass(periodName), "created", this.getTimeZone());
        TreeMap<RegularTimePeriod, Number> result = new TreeMap<RegularTimePeriod, Number>();
        OneDimensionalObjectHitCollector hitCollector = new OneDimensionalObjectHitCollector(createdMapper, result, this.issueIndexManager.getIssueSearcher().getIndexReader());
        this.searchProvider.search(query, remoteUser, hitCollector);
        return result;
    }

    private Map<RegularTimePeriod, Number> getResolvedIssues(Query query, User remoteUser, ChartFactory.PeriodName periodName) throws IOException, SearchException {
        TreeMap<RegularTimePeriod, Number> data = new TreeMap<RegularTimePeriod, Number>();
        DatePeriodStatisticsMapper resolvedMapper = new DatePeriodStatisticsMapper(ChartUtil.getTimePeriodClass(periodName), "resolutiondate", this.getTimeZone());
        OneDimensionalObjectHitCollector hitCollector = new OneDimensionalObjectHitCollector(resolvedMapper, data, this.issueIndexManager.getIssueSearcher().getIndexReader());
        this.searchProvider.search(query, remoteUser, hitCollector);
        return data;
    }

    private I18nBean getI18nBean(User user) {
        return new I18nBean(user);
    }

    private boolean isMinorVersion(Version version) {
        return StringUtils.countMatches((String)version.getName(), (String)".") > 1 || StringUtils.contains((String)version.getName().toLowerCase(), (String)"alpha") || StringUtils.contains((String)version.getName().toLowerCase(), (String)"beta");
    }
}

