/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.workflow;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class DefaultWorkflowService
implements WorkflowService {
    private static final Logger log = Logger.getLogger(DefaultWorkflowService.class);
    private final WorkflowManager workflowManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final Lock overwriteWorkflowLock = new ReentrantLock();

    public DefaultWorkflowService(WorkflowManager workflowManager, JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager) {
        this.workflowManager = workflowManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
    }

    @Override
    public JiraWorkflow getDraftWorkflow(JiraServiceContext jiraServiceContext, String parentWorkflowName) {
        if (!this.hasAdminPermission(jiraServiceContext)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return null;
        }
        if (StringUtils.isEmpty((String)parentWorkflowName)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.parent"));
            return null;
        }
        JiraWorkflow parentWorkflow = this.workflowManager.getWorkflow(parentWorkflowName);
        if (parentWorkflow == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.retrieve.no.parent"));
            return null;
        }
        return this.workflowManager.getDraftWorkflow(parentWorkflowName);
    }

    @Override
    public JiraWorkflow createDraftWorkflow(JiraServiceContext jiraServiceContext, String parentWorkflowName) {
        if (!this.hasAdminPermission(jiraServiceContext)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return null;
        }
        if (StringUtils.isEmpty((String)parentWorkflowName)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.parent"));
            return null;
        }
        JiraWorkflow parentWorkflow = this.workflowManager.getWorkflow(parentWorkflowName);
        if (parentWorkflow == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.parent"));
            return null;
        }
        if (!this.workflowManager.isActive(parentWorkflow)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.parent.not.active"));
            return null;
        }
        String username = jiraServiceContext.getLoggedInUser() == null ? "" : jiraServiceContext.getLoggedInUser().getName();
        try {
            return this.workflowManager.createDraftWorkflow(username, parentWorkflowName);
        }
        catch (IllegalStateException e) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.draft.exists.or.workflow.not.active"));
            return null;
        }
    }

    @Override
    public boolean deleteDraftWorkflow(JiraServiceContext jiraServiceContext, String parentWorkflowName) {
        if (StringUtils.isEmpty((String)parentWorkflowName)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.delete.no.parent"));
            return false;
        }
        if (!this.hasAdminPermission(jiraServiceContext)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return false;
        }
        return this.workflowManager.deleteDraftWorkflow(parentWorkflowName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overwriteActiveWorkflow(JiraServiceContext jiraServiceContext, String parentWorkflowName) {
        if (!this.hasAdminPermission(jiraServiceContext)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return;
        }
        this.overwriteWorkflowLock.lock();
        try {
            this.validateOverwriteWorkflow(jiraServiceContext, parentWorkflowName);
            if (jiraServiceContext.getErrorCollection().hasAnyErrors()) {
                return;
            }
            String username = jiraServiceContext.getLoggedInUser() == null ? "" : jiraServiceContext.getLoggedInUser().getName();
            this.workflowManager.overwriteActiveWorkflow(username, parentWorkflowName);
        }
        finally {
            this.overwriteWorkflowLock.unlock();
        }
    }

    @Override
    public void validateOverwriteWorkflow(JiraServiceContext jiraServiceContext, String workflowName) {
        if (!this.hasAdminPermission(jiraServiceContext)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return;
        }
        if (StringUtils.isEmpty((String)workflowName)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.overwrite.no.parent", workflowName));
            return;
        }
        JiraWorkflow liveJiraWorkflow = this.workflowManager.getWorkflow(workflowName);
        if (liveJiraWorkflow == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.overwrite.no.parent", workflowName));
            return;
        }
        if (!liveJiraWorkflow.isActive()) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.overwrite.inactive.parent", workflowName));
            return;
        }
        JiraWorkflow draftJiraWorkflow = this.workflowManager.getDraftWorkflow(workflowName);
        if (draftJiraWorkflow == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.overwrite.no.draft", workflowName));
            return;
        }
        this.validateOverwriteWorkflow(liveJiraWorkflow, draftJiraWorkflow, jiraServiceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateWorkflow(JiraServiceContext jiraServiceContext, JiraWorkflow workflow) {
        if (!this.hasAdminPermission(jiraServiceContext)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return;
        }
        if (workflow == null || workflow.getDescriptor() == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.update.no.workflow"));
            return;
        }
        if (!workflow.isEditable()) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.not.editable"));
            return;
        }
        String username = jiraServiceContext.getLoggedInUser() == null ? "" : jiraServiceContext.getLoggedInUser().getName();
        this.overwriteWorkflowLock.lock();
        try {
            this.workflowManager.updateWorkflow(username, workflow);
        }
        finally {
            this.overwriteWorkflowLock.unlock();
        }
    }

    @Override
    public void validateUpdateWorkflowNameAndDescription(JiraServiceContext jiraServiceContext, JiraWorkflow currentWorkflow, String newWorkflowName) {
        if (!this.hasAdminPermission(jiraServiceContext)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return;
        }
        if (currentWorkflow == null || currentWorkflow.getDescriptor() == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.update.no.workflow"));
            return;
        }
        if (!currentWorkflow.isEditable()) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.errors.workflow.cannot.be.edited.as.it.is.not.editable"));
            return;
        }
        if (currentWorkflow.isDraftWorkflow() && !newWorkflowName.equals(currentWorkflow.getName())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.edit.name.draft.workflow"));
            return;
        }
        if (StringUtils.isBlank((String)newWorkflowName)) {
            jiraServiceContext.getErrorCollection().addError("newWorkflowName", this.getI18nBean().getText("admin.errors.you.must.specify.a.workflow.name"));
            return;
        }
        if (!WorkflowUtil.isAcceptableName(newWorkflowName)) {
            jiraServiceContext.getErrorCollection().addError("newWorkflowName", this.getI18nBean().getText("admin.errors.please.use.only.ascii.characters"));
            return;
        }
        if (!newWorkflowName.equals(currentWorkflow.getName()) && this.workflowManager.workflowExists(newWorkflowName)) {
            jiraServiceContext.getErrorCollection().addError("newWorkflowName", this.getI18nBean().getText("admin.errors.a.workflow.with.this.name.already.exists"));
            return;
        }
    }

    @Override
    public void updateWorkflowNameAndDescription(JiraServiceContext jiraServiceContext, JiraWorkflow currentWorkflow, String newName, String newDescription) {
        if (!this.hasAdminPermission(jiraServiceContext)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return;
        }
        String username = jiraServiceContext.getLoggedInUser() == null ? "" : jiraServiceContext.getLoggedInUser().getName();
        this.workflowManager.updateWorkflowNameAndDescription(username, currentWorkflow, newName, newDescription);
    }

    @Override
    public JiraWorkflow getWorkflow(JiraServiceContext jiraServiceContext, String name) {
        if (StringUtils.isEmpty((String)name)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.null.name"));
            return null;
        }
        return this.workflowManager.getWorkflow(name);
    }

    @Override
    public void validateCopyWorkflow(JiraServiceContext jiraServiceContext, String newWorkflowName) {
        if (!this.hasAdminPermission(jiraServiceContext)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return;
        }
        if (StringUtils.isBlank((String)newWorkflowName)) {
            jiraServiceContext.getErrorCollection().addError("newWorkflowName", this.getI18nBean().getText("admin.errors.you.must.specify.a.workflow.name"));
            return;
        }
        if (!WorkflowUtil.isAcceptableName(newWorkflowName)) {
            jiraServiceContext.getErrorCollection().addError("newWorkflowName", this.getI18nBean().getText("admin.common.errors.use.only.ascii"));
            return;
        }
        try {
            if (this.workflowManager.workflowExists(newWorkflowName)) {
                jiraServiceContext.getErrorCollection().addError("newWorkflowName", this.getI18nBean().getText("admin.errors.a.workflow.with.this.name.already.exists"));
            }
        }
        catch (WorkflowException e) {
            log.error((Object)"Error occurred while accessing workflow information.", (Throwable)e);
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.errors.workflows.error.occurred.accessing.information"));
        }
    }

    @Override
    public JiraWorkflow copyWorkflow(JiraServiceContext jiraServiceContext, String clonedWorkflowName, String clonedWorkflowDescription, JiraWorkflow workflowToClone) {
        if (!this.hasAdminPermission(jiraServiceContext)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return null;
        }
        String username = jiraServiceContext.getLoggedInUser() == null ? "" : jiraServiceContext.getLoggedInUser().getName();
        return this.workflowManager.copyWorkflow(username, clonedWorkflowName, clonedWorkflowDescription, workflowToClone);
    }

    @Override
    public boolean isStepOnDraftWithNoTransitionsOnParentWorkflow(JiraServiceContext jiraServiceContext, JiraWorkflow workflow, int stepId) {
        List availableActions;
        JiraWorkflow parentWorkflow;
        StepDescriptor originalStep;
        return workflow.isDraftWorkflow() && (originalStep = (parentWorkflow = this.getWorkflow(jiraServiceContext, workflow.getName())).getDescriptor().getStep(stepId)) != null && ((availableActions = originalStep.getActions()) == null || availableActions.isEmpty());
    }

    @Override
    public void validateAddWorkflowTransitionToDraft(JiraServiceContext jiraServiceContext, JiraWorkflow newJiraWorkflow, int stepId) {
        StepDescriptor newStep;
        List newActions;
        if (!this.hasAdminPermission(jiraServiceContext)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.no.admin.permission"));
            return;
        }
        if (this.isStepOnDraftWithNoTransitionsOnParentWorkflow(jiraServiceContext, newJiraWorkflow, stepId) && (newActions = (newStep = newJiraWorkflow.getDescriptor().getStep(stepId)).getActions()) != null && !newActions.isEmpty()) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflowtransitions.error.add.transition.draft.step.without.transition", newStep.getName()));
        }
    }

    private void validateOverwriteWorkflow(JiraWorkflow oldJiraWorkflow, JiraWorkflow newJiraWorkflow, JiraServiceContext jiraServiceContext) {
        List<GenericValue> linkedStatuses = oldJiraWorkflow.getLinkedStatuses();
        for (GenericValue gvStatus : linkedStatuses) {
            StepDescriptor oldStepDescriptor = oldJiraWorkflow.getLinkedStep(gvStatus);
            StepDescriptor newStepDescriptor = newJiraWorkflow.getLinkedStep(gvStatus);
            if (newStepDescriptor == null) {
                jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.overwrite.missing.status", gvStatus.getString("name")));
                break;
            }
            if (oldStepDescriptor.getId() != newStepDescriptor.getId()) {
                jiraServiceContext.getErrorCollection().addErrorMessage(this.getI18nBean().getText("admin.workflows.service.error.overwrite.step.associated.with.wrong.status", String.valueOf(oldStepDescriptor.getId()), gvStatus.getString("name")));
                break;
            }
            this.validateAddWorkflowTransitionToDraft(jiraServiceContext, newJiraWorkflow, oldStepDescriptor.getId());
            if (!jiraServiceContext.getErrorCollection().hasAnyErrors()) continue;
            break;
        }
    }

    I18nHelper getI18nBean() {
        return this.jiraAuthenticationContext.getI18nHelper();
    }

    boolean hasAdminPermission(JiraServiceContext jiraServiceContext) {
        return this.permissionManager.hasPermission(0, jiraServiceContext.getLoggedInUser());
    }
}

