/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.whitelist;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.gadgets.event.AddGadgetEvent;
import com.atlassian.gadgets.event.AddGadgetFeedEvent;
import com.atlassian.gadgets.event.ClearHttpCacheEvent;
import com.atlassian.jira.bc.whitelist.WhitelistManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;

public class DefaultWhitelistManager
implements WhitelistManager,
Startable {
    public static final String NO_WILDCARDS_PREFIX = "=";
    public static final String REGEX_PREFIX = "/";
    private static final String[] RULE_ESCAPE_CHARACTERS = new String[]{".", "?", "+", "|"};
    private static final String WILDCARD_CHARACTER_PATTERN = ".*";
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;
    private ResettableLazyReference<List<String>> rules = new ResettableLazyReference<List<String>>(){

        protected List<String> create() throws Exception {
            String rulesString = DefaultWhitelistManager.this.applicationProperties.getText("jira.whitelist.rules");
            String[] split = StringUtils.split((String)rulesString, null);
            ArrayList<String> ret = new ArrayList<String>();
            if (split != null) {
                ret.addAll(Arrays.asList(split));
            }
            return Collections.unmodifiableList(ret);
        }
    };

    public DefaultWhitelistManager(ApplicationProperties applicationProperties, EventPublisher eventPublisher) {
        this.applicationProperties = applicationProperties;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public List<String> getRules() {
        if (this.isDisabled()) {
            return Collections.emptyList();
        }
        return (List)this.rules.get();
    }

    @Override
    public boolean isDisabled() {
        return this.applicationProperties.getOption("jira.whitelist.disabled");
    }

    @Override
    public List<String> updateRules(List<String> newRules, boolean disabled) {
        Assertions.notNull("newRules", newRules);
        StringBuilder builder = new StringBuilder();
        for (String rule : newRules) {
            builder.append(rule).append("\n");
        }
        this.applicationProperties.setText("jira.whitelist.rules", builder.toString());
        this.applicationProperties.setOption("jira.whitelist.disabled", disabled);
        this.rules.reset();
        this.eventPublisher.publish((Object)ClearHttpCacheEvent.INSTANCE);
        return this.getRules();
    }

    @Override
    public boolean isAllowed(URI uri) {
        if (this.isDisabled()) {
            return true;
        }
        for (String rule : this.getRules()) {
            if (!this.urlMatches(uri, rule)) continue;
            return true;
        }
        return false;
    }

    private boolean urlMatches(URI uri, String rule) {
        boolean matches = false;
        String uriString = uri.normalize().toASCIIString();
        if (rule.startsWith(NO_WILDCARDS_PREFIX)) {
            matches = uriString.equalsIgnoreCase(rule.substring(NO_WILDCARDS_PREFIX.length()));
        } else {
            try {
                Pattern pattern = rule.startsWith(REGEX_PREFIX) ? Pattern.compile(rule.substring(REGEX_PREFIX.length())) : Pattern.compile(this.createRegex(rule), 2);
                matches = pattern.matcher(uriString).matches();
            }
            catch (PatternSyntaxException e) {
                // empty catch block
            }
        }
        return matches;
    }

    protected String createRegex(String rule) {
        String regex = rule;
        for (String escapeChar : RULE_ESCAPE_CHARACTERS) {
            regex = regex.replaceAll("\\" + escapeChar, "\\\\" + escapeChar);
        }
        regex = regex.replaceAll("\\*", WILDCARD_CHARACTER_PATTERN);
        return regex;
    }

    @EventListener
    public void onAddGadget(AddGadgetEvent addGadgetEvent) {
        this.addWhitelistEntry(addGadgetEvent.getGadgetUri());
    }

    @EventListener
    public void onAddGadgetFeed(AddGadgetFeedEvent addGadgetFeedEvent) {
        this.addWhitelistEntry(addGadgetFeedEvent.getFeedUri());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.rules.reset();
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    private void addWhitelistEntry(URI uri) {
        String newRule = uri.getScheme() + "://" + uri.getAuthority() + "/*";
        List<String> rules = this.getRules();
        if (!rules.contains(newRule) && !this.isDisabled()) {
            ArrayList<String> newRules = new ArrayList<String>(rules);
            newRules.add(newRule);
            this.updateRules(newRules, this.isDisabled());
        }
    }
}

