/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.user.search.UserMatcherPredicate;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.comparator.UserBestNameComparator;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultUserPickerSearchService
implements UserPickerSearchService {
    private static final Logger log = Logger.getLogger(DefaultUserPickerSearchService.class);
    private static final String RUNNING_USER_PICKER_SEARCH = "Running user-picker search: ";
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private static final String VISIBILITY_PUBLIC = "show";
    private static final String VISIBILITY_USER = "user";
    private static final String VISIBILITY_MASKED = "mask";

    public DefaultUserPickerSearchService(UserManager userManager, ApplicationProperties applicationProperties, PermissionManager permissionManager) {
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
    }

    @Override
    public List<User> findUsers(JiraServiceContext jiraServiceContext, String query) {
        if (StringUtils.isBlank((String)query)) {
            return Collections.emptyList();
        }
        return this.findUsersAllowEmptyQuery(jiraServiceContext, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<User> findUsersAllowEmptyQuery(JiraServiceContext jiraServiceContext, String query) {
        if (!this.canPerformAjaxSearch(jiraServiceContext)) {
            return Collections.emptyList();
        }
        String convertedQuery = query == null ? "" : query.toLowerCase().trim();
        UtilTimerStack.push((String)(RUNNING_USER_PICKER_SEARCH + convertedQuery));
        try {
            ArrayList<User> returnUsers = new ArrayList<User>();
            boolean canShowEmailAddresses = this.canShowEmailAddresses(jiraServiceContext);
            Collection<User> allUsers = this.userManager.getUsers();
            UserMatcherPredicate userMatcher = new UserMatcherPredicate(convertedQuery, canShowEmailAddresses);
            for (User user : allUsers) {
                if (!userMatcher.apply(user)) continue;
                returnUsers.add(user);
            }
            Collections.sort(returnUsers, new UserBestNameComparator(jiraServiceContext.getI18nBean().getLocale()));
            ArrayList<User> arrayList = returnUsers;
            return arrayList;
        }
        finally {
            UtilTimerStack.pop((String)(RUNNING_USER_PICKER_SEARCH + convertedQuery));
        }
    }

    Collection<User> getAllUsers() {
        return this.userManager.getUsers();
    }

    @Override
    public boolean canShowEmailAddresses(JiraServiceContext jiraServiceContext) {
        String emailVisibility;
        return this.canPerformAjaxSearch(jiraServiceContext) && (VISIBILITY_PUBLIC.equals(emailVisibility = this.applicationProperties.getDefaultBackedString("jira.option.emailvisible")) || VISIBILITY_MASKED.equals(emailVisibility) || VISIBILITY_USER.equals(emailVisibility) && jiraServiceContext.getLoggedInUser() != null);
    }

    @Override
    public boolean canPerformAjaxSearch(JiraServiceContext jiraServiceContext) {
        User loggedInUser = jiraServiceContext != null ? jiraServiceContext.getLoggedInUser() : null;
        return this.canPerformAjaxSearch(loggedInUser);
    }

    @Override
    public boolean canPerformAjaxSearch(User user) {
        return this.permissionManager.hasPermission(27, user);
    }
}

