/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.subtask.conversion;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.subtask.conversion.DefaultIssueConversionService;
import com.atlassian.jira.bc.subtask.conversion.SubTaskToIssueConversionService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.workflow.WorkflowManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DefaultSubTaskToIssueConversionService
extends DefaultIssueConversionService
implements SubTaskToIssueConversionService {
    private final IssueLinkManager issueLinkManager;
    private final SubTaskManager subTaskManager;

    public DefaultSubTaskToIssueConversionService(PermissionManager permissionManager, WorkflowManager workflowManager, FieldLayoutManager fieldLayoutManager, IssueTypeSchemeManager issueTypeSchemeManager, JiraAuthenticationContext jiraAuthenticationContext, FieldManager fieldManager, IssueLinkManager issueLinkManager, SubTaskManager subTaskManager) {
        super(permissionManager, workflowManager, fieldLayoutManager, issueTypeSchemeManager, jiraAuthenticationContext, fieldManager);
        this.issueLinkManager = issueLinkManager;
        this.subTaskManager = subTaskManager;
    }

    @Override
    public boolean canConvertIssue(JiraServiceContext context, Issue issue) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (issue == null) {
            throw new IllegalArgumentException("Issue must not be null");
        }
        if (!issue.isSubTask()) {
            errorCollection.addErrorMessage(this.getText("convert.subtask.to.issue.errormessage.issuenotsubtask", issue.getKey()));
        }
        if (!this.hasPermission(context, issue)) {
            if (context.getLoggedInUser() == null) {
                errorCollection.addErrorMessage(this.getText("convert.subtask.to.issue.errormessage.nopermissionanon"));
            } else {
                errorCollection.addErrorMessage(this.getText("convert.subtask.to.issue.errormessage.nopermisionuser"));
            }
        }
        context.getErrorCollection().addErrorCollection(errorCollection);
        return !errorCollection.hasAnyErrors();
    }

    @Override
    public void validateTargetIssueType(JiraServiceContext context, Issue issue, IssueType issueType, String fieldNameIssueTypeId) {
        ErrorCollection errorCollection = context.getErrorCollection();
        if (issueType.isSubTask()) {
            errorCollection.addError(fieldNameIssueTypeId, this.getText("convert.subtask.to.issue.error.issuetypenotsubtask", issueType.getName()));
        }
        Collection<IssueType> issueTypes = this.issueTypeSchemeManager.getIssueTypesForProject(issue.getProjectObject());
        boolean found = false;
        Iterator<IssueType> it = issueTypes.iterator();
        while (it.hasNext() && !found) {
            IssueType type = it.next();
            if (!type.getId().equals(issueType.getId())) continue;
            found = true;
        }
        if (!found) {
            errorCollection.addError(fieldNameIssueTypeId, this.getText("convert.issue.to.subtask.error.issuetypenotforproject", issueType.getName()));
        }
    }

    @Override
    protected boolean canIssueSecurityFieldIgnore() {
        return false;
    }

    @Override
    public void preStoreUpdates(JiraServiceContext context, IssueChangeHolder changeHolder, Issue currentIssue, MutableIssue targetIssue) {
        List<IssueLink> inwardLinks = this.issueLinkManager.getInwardLinks(currentIssue.getId());
        for (IssueLink issueLink : inwardLinks) {
            if (!issueLink.getIssueLinkType().isSubTaskLinkType()) continue;
            try {
                this.issueLinkManager.removeIssueLink(issueLink, context.getLoggedInUser());
            }
            catch (RemoveException e) {
                throw new DataAccessException(e);
            }
        }
        this.subTaskManager.resetSequences(currentIssue.getParentObject());
        Issue parentIssue = currentIssue.getParentObject();
        changeHolder.addChangeItem(new ChangeItemBean("jira", "Parent", parentIssue.getId().toString(), parentIssue.getKey(), null, null));
    }
}

