/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.subtask.conversion;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.subtask.conversion.IssueConversionService;
import com.atlassian.jira.event.issue.IssueEventDispatcher;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public abstract class DefaultIssueConversionService
implements IssueConversionService {
    private static final Logger log = Logger.getLogger(DefaultIssueConversionService.class);
    private final PermissionManager permissionManager;
    private final WorkflowManager workflowManager;
    protected final FieldLayoutManager fieldLayoutManager;
    protected final IssueTypeSchemeManager issueTypeSchemeManager;
    protected final JiraAuthenticationContext jiraAuthenticationContext;
    protected final FieldManager fieldManager;

    public DefaultIssueConversionService(PermissionManager permissionManager, WorkflowManager workflowManager, FieldLayoutManager fieldLayoutManager, IssueTypeSchemeManager issueTypeSchemeManager, JiraAuthenticationContext jiraAuthenticationContext, FieldManager fieldManager) {
        this.permissionManager = permissionManager;
        this.workflowManager = workflowManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.fieldManager = fieldManager;
    }

    @Override
    public boolean hasPermission(JiraServiceContext context, Issue issue) {
        return this.permissionManager.hasPermission(this.getPermissionNeeded(), issue, context.getLoggedInUser());
    }

    protected int getPermissionNeeded() {
        return 12;
    }

    @Override
    public boolean isStatusChangeRequired(JiraServiceContext context, Issue issue, IssueType issueType) {
        String subTaskId;
        Long projectId;
        Status status = issue.getStatusObject();
        return !this.isStatusInWorkflowForProjectAndIssueType(status, projectId = issue.getProjectObject().getId(), subTaskId = issueType.getId());
    }

    @Override
    public void validateTargetStatus(JiraServiceContext context, Status status, String fieldName, Issue issue, IssueType issueType) {
        Long projectId = issue.getProjectObject().getId();
        String subTaskId = issueType.getId();
        ErrorCollection errorCollection = context.getErrorCollection();
        if (!this.isStatusChangeRequired(context, issue, issueType) && !status.getId().equals(issue.getStatusObject().getId())) {
            errorCollection.addErrorMessage(this.getText("convert.issue.to.subtask.errormessage.nochangeneeded"));
        }
        if (!this.isStatusInWorkflowForProjectAndIssueType(status, projectId, subTaskId)) {
            errorCollection.addError(fieldName, this.getText("convert.issue.to.subtask.error.invalidstatusfortargetworkflow", status.getNameTranslation()));
        }
    }

    protected boolean isStatusInWorkflowForProjectAndIssueType(Status status, Long projectId, String issueTypeId) {
        List<Status> linkedStatusObjects = this.getWorkflowForProjectAndIssueType(projectId, issueTypeId).getLinkedStatusObjects();
        for (Status wfStatus : linkedStatusObjects) {
            if (!wfStatus.getId().equals(status.getId())) continue;
            return true;
        }
        return false;
    }

    private JiraWorkflow getWorkflowForProjectAndIssueType(Long projectId, String issueTypeId) {
        try {
            return this.workflowManager.getWorkflow(projectId, issueTypeId);
        }
        catch (WorkflowException e) {
            String msg = "Failed retrieving workflow for project: " + projectId + " and issue type:" + issueTypeId;
            log.error((Object)msg, (Throwable)e);
            throw new DataAccessException(msg, e);
        }
    }

    @Override
    public Collection getFieldLayoutItems(JiraServiceContext context, Issue originalIssue, Issue targetIssue) {
        ArrayList<FieldLayoutItem> convertFieldLayoutItems = new ArrayList<FieldLayoutItem>();
        FieldLayout targetFieldLayout = this.getFieldLayout(targetIssue);
        Project targetProject = targetIssue.getProjectObject();
        List issueTypeIds = EasyList.build((Object)targetIssue.getIssueTypeObject().getId());
        List<FieldLayoutItem> visibleLayoutItems = targetFieldLayout.getVisibleLayoutItems(context.getLoggedInUser(), targetProject, issueTypeIds);
        for (FieldLayoutItem fieldLayoutItem : visibleLayoutItems) {
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            if ("issuetype".equals(orderableField.getId()) || this.canIssueSecurityFieldIgnore() && "security".equals(orderableField.getId()) || !orderableField.needsMove(EasyList.build((Object)originalIssue), targetIssue, fieldLayoutItem).getResult()) continue;
            convertFieldLayoutItems.add(fieldLayoutItem);
        }
        Collections.sort(convertFieldLayoutItems);
        return convertFieldLayoutItems;
    }

    protected abstract boolean canIssueSecurityFieldIgnore();

    private FieldLayout getFieldLayout(Issue issue) {
        return this.fieldLayoutManager.getFieldLayout(issue);
    }

    @Override
    public void populateFields(JiraServiceContext context, OperationContext operationContext, I18nHelper i18nHelper, Issue targetIssue, Collection fieldLayoutItems) {
        ErrorCollection errorCollection = context.getErrorCollection();
        for (FieldLayoutItem fieldLayoutItem : fieldLayoutItems) {
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            if (orderableField.isShown(targetIssue)) {
                orderableField.populateFromParams(operationContext.getFieldValuesHolder(), ActionContext.getParameters());
                orderableField.validateParams(operationContext, errorCollection, i18nHelper, targetIssue, new FieldScreenRenderLayoutItemImpl(null, fieldLayoutItem));
                continue;
            }
            orderableField.populateDefaults(operationContext.getFieldValuesHolder(), targetIssue);
            orderableField.validateParams(operationContext, errorCollection, i18nHelper, targetIssue, new FieldScreenRenderLayoutItemImpl(null, fieldLayoutItem));
        }
    }

    @Override
    public Collection getRemovedFields(JiraServiceContext context, Issue origIssue, Issue targetIssue) {
        ArrayList<OrderableField> removedFields = new ArrayList<OrderableField>();
        FieldLayout targetFieldLayout = this.getFieldLayout(targetIssue);
        List<Field> hiddenFields = targetFieldLayout.getHiddenFields(context.getLoggedInUser(), targetIssue.getProjectObject(), (List<String>)EasyList.build((Object)targetIssue.getIssueTypeObject().getId()));
        for (Field field : hiddenFields) {
            if (field == null || !this.fieldManager.isOrderableField(field)) continue;
            boolean doValueCheck = this.isShouldCheckFieldValue(context, origIssue, field);
            OrderableField orderableField = (OrderableField)field;
            if (!doValueCheck || !orderableField.hasValue(targetIssue) || !orderableField.canRemoveValueFromIssueObject(targetIssue)) continue;
            removedFields.add(orderableField);
        }
        return removedFields;
    }

    protected boolean isShouldCheckFieldValue(JiraServiceContext context, Issue origIssue, Field field) {
        boolean doValueCheck = true;
        List issueTypeList = EasyList.build((Object)origIssue.getIssueTypeObject().getId());
        if (this.fieldManager.isCustomField(field) && !((CustomField)field).isInScope(origIssue.getProjectObject(), (List<String>)issueTypeList)) {
            doValueCheck = false;
        }
        return doValueCheck;
    }

    @Override
    public void validateFields(JiraServiceContext context, OperationContext operationContext, I18nHelper i18nHelper, Issue targetIssue, Collection fieldLayoutItems) {
        ErrorCollection errorCollection = context.getErrorCollection();
        for (FieldLayoutItem fieldLayoutItem : fieldLayoutItems) {
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            orderableField.validateParams(operationContext, errorCollection, i18nHelper, targetIssue, new FieldScreenRenderLayoutItemImpl(null, fieldLayoutItem));
        }
    }

    private IssueChangeHolder convertIssueDetails(JiraServiceContext context, Issue currentIssue, MutableIssue targetIssue) {
        DefaultIssueChangeHolder changeHolder = new DefaultIssueChangeHolder();
        if (!currentIssue.getWorkflowId().equals(targetIssue.getWorkflowId())) {
            JiraWorkflow currentWorkflow = this.getWorkflowForIssue(currentIssue);
            JiraWorkflow targetWorkflow = this.getWorkflowForIssue(targetIssue);
            changeHolder.addChangeItem(new ChangeItemBean("jira", "Workflow", currentIssue.getWorkflowId().toString(), currentWorkflow.getName(), targetIssue.getWorkflowId().toString(), targetWorkflow.getName()));
            Status currentStatus = currentIssue.getStatusObject();
            Status targetStatus = targetIssue.getStatusObject();
            if (!currentStatus.getId().equals(targetStatus.getId())) {
                changeHolder.addChangeItem(new ChangeItemBean("jira", "status", currentStatus.getId(), currentStatus.getName(), targetStatus.getId(), targetStatus.getName()));
            }
        }
        this.preStoreUpdates(context, changeHolder, currentIssue, targetIssue);
        targetIssue.store();
        Map<String, ModifiedValue> modifiedFields = targetIssue.getModifiedFields();
        for (String fieldId : modifiedFields.keySet()) {
            if (!this.fieldManager.isOrderableField(fieldId)) continue;
            OrderableField field = this.fieldManager.getOrderableField(fieldId);
            FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(targetIssue).getFieldLayoutItem(field);
            field.updateValue(fieldLayoutItem, targetIssue, modifiedFields.get(fieldId), changeHolder);
        }
        targetIssue.resetModifiedFields();
        return changeHolder;
    }

    private JiraWorkflow getWorkflowForIssue(Issue issue) {
        return this.getWorkflowForProjectAndIssueType(issue.getProjectObject().getId(), issue.getIssueTypeObject().getId());
    }

    @Override
    public void convertIssue(JiraServiceContext context, Issue currentIssue, MutableIssue updatedIssue) {
        this.migrateWorkflowIfNecessary(currentIssue, updatedIssue);
        updatedIssue.setUpdated(new Timestamp(System.currentTimeMillis()));
        IssueChangeHolder issueChangeHolder = this.convertIssueDetails(context, currentIssue, updatedIssue);
        GenericValue updateLog = ChangeLogUtils.createChangeGroup(context.getLoggedInUser(), currentIssue, updatedIssue, (Collection)issueChangeHolder.getChangeItems(), false);
        if (updateLog != null && !issueChangeHolder.getChangeItems().isEmpty()) {
            IssueEventDispatcher.dispatchEvent(EventType.ISSUE_UPDATED_ID, (Issue)updatedIssue, context.getLoggedInUser(), updateLog, true, issueChangeHolder.isSubtasksUpdated());
        }
    }

    private void migrateWorkflowIfNecessary(Issue currentIssue, MutableIssue updatedIssue) {
        JiraWorkflow currentWorkflow = this.getWorkflowForIssue(currentIssue);
        JiraWorkflow targetWorkflow = this.getWorkflowForIssue(updatedIssue);
        if (!targetWorkflow.equals(currentWorkflow)) {
            try {
                this.workflowManager.migrateIssueToWorkflow(updatedIssue, targetWorkflow, updatedIssue.getStatusObject());
            }
            catch (WorkflowException e) {
                String msg = "Could not migrate to sub-task workflow for issue: " + currentIssue.getKey();
                log.error((Object)msg, (Throwable)e);
                throw new DataAccessException(msg, e);
            }
        }
    }

    protected String getText(String key) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key);
    }

    protected String getText(String key, Object param) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, param);
    }

    protected String getText(String key, String param0, String param1) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, param0, param1);
    }
}

