/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.projectroles;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorDoesNotExistException;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.sharing.SharePermissionDeleteUtils;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultProjectRoleService
implements ProjectRoleService {
    private static final Logger log = Logger.getLogger(DefaultProjectRoleService.class);
    private ProjectRoleManager projectRoleManager;
    private PermissionManager permissionManager;
    private JiraAuthenticationContext jiraAuthenticationContext;
    private RoleActorFactory roleActorFactory;
    private NotificationSchemeManager notificationSchemeManager;
    private PermissionSchemeManager permissionSchemeManager;
    private WorkflowManager workflowManager;
    private ProjectManager projectManager;
    private SchemeFactory schemeFactory;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final SharePermissionDeleteUtils sharePermissionDeleteUtils;
    private IssueSecuritySchemeManager issueSecuritySchemeManager;

    public DefaultProjectRoleService(ProjectRoleManager projectRoleManager, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, RoleActorFactory roleActorFactory, NotificationSchemeManager notificationSchemeManager, PermissionSchemeManager permissionSchemeManager, WorkflowManager workflowManager, ProjectManager projectManager, SchemeFactory schemeFactory, IssueSecurityLevelManager issueSecurityLevelManager, SharePermissionDeleteUtils sharePermissionDeleteUtils, IssueSecuritySchemeManager issueSecuritySchemeManager) {
        this.projectRoleManager = projectRoleManager;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.roleActorFactory = roleActorFactory;
        this.notificationSchemeManager = notificationSchemeManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.workflowManager = workflowManager;
        this.projectManager = projectManager;
        this.schemeFactory = schemeFactory;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.sharePermissionDeleteUtils = sharePermissionDeleteUtils;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
    }

    @Override
    public Collection<ProjectRole> getProjectRoles(User currentUser, ErrorCollection errorCollection) {
        return this.projectRoleManager.getProjectRoles();
    }

    @Override
    public ProjectRole getProjectRole(User currentUser, Long id, ErrorCollection errorCollection) {
        ProjectRole projectRole = null;
        if (id == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.id.null"));
        } else {
            projectRole = this.projectRoleManager.getProjectRole(id);
        }
        return projectRole;
    }

    @Override
    public ProjectRole getProjectRoleByName(User currentUser, String name, ErrorCollection errorCollection) {
        ProjectRole projectRole = null;
        if (StringUtils.isBlank((String)name)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.name.null"));
        } else {
            projectRole = this.projectRoleManager.getProjectRole(name);
        }
        return projectRole;
    }

    @Override
    public ProjectRole createProjectRole(User currentUser, ProjectRole projectRole, ErrorCollection errorCollection) {
        ProjectRole createdProjectRole = null;
        boolean internalError = false;
        String roleName = null;
        if (projectRole == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.null.create"));
            internalError = true;
        } else {
            roleName = projectRole.getName();
        }
        if (roleName == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.name.null.create"));
            internalError = true;
        }
        if (!this.hasAdminPermission(currentUser)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"));
            internalError = true;
        }
        if (!this.isProjectRoleNameUnique(currentUser, roleName, errorCollection)) {
            internalError = true;
        }
        if (!internalError) {
            createdProjectRole = this.projectRoleManager.createRole(projectRole);
        }
        return createdProjectRole;
    }

    @Override
    public boolean isProjectRoleNameUnique(User currentUser, String name, ErrorCollection errorCollection) {
        boolean roleNameUnique = false;
        if (this.hasAdminPermission(currentUser)) {
            roleNameUnique = this.projectRoleManager.isRoleNameUnique(name);
            if (!roleNameUnique) {
                errorCollection.addError("name", this.getText("admin.projectroles.duplicate.role.name.error", name));
            }
        } else {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"));
        }
        return roleNameUnique;
    }

    @Override
    public void deleteProjectRole(User currentUser, ProjectRole projectRole, ErrorCollection errorCollection) {
        boolean internalError = false;
        if (projectRole == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.null.delete"));
            internalError = true;
        }
        if (!internalError && projectRole.getId() == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.null.id.delete"));
            internalError = true;
        }
        if (!this.hasAdminPermission(currentUser)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"));
            internalError = true;
        }
        if (!internalError) {
            try {
                this.notificationSchemeManager.removeEntities("Project_Role", projectRole.getId().toString());
            }
            catch (RemoveException e) {
                log.error((Object)("Unable to remove notification scheme entites for project role: " + projectRole.getName()));
            }
            try {
                this.permissionSchemeManager.removeEntities("projectrole", projectRole.getId().toString());
            }
            catch (RemoveException e) {
                log.error((Object)("Unable to remove permission scheme entites for project role: " + projectRole.getName()));
            }
            try {
                this.issueSecuritySchemeManager.removeEntities("projectrole", projectRole.getId().toString());
            }
            catch (RemoveException e) {
                log.error((Object)("Unable to remove issue security scheme entites for project role: " + projectRole.getName()));
            }
            this.sharePermissionDeleteUtils.deleteRoleSharePermissions(projectRole.getId());
            this.projectRoleManager.deleteRole(projectRole);
            this.clearIssueSecurityLevelCache();
        }
    }

    @Override
    public void updateProjectRole(User currentUser, ProjectRole projectRole, ErrorCollection errorCollection) {
        boolean internalError = false;
        if (projectRole == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.null.update"));
            internalError = true;
        }
        if (!internalError && projectRole.getId() == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.null.id.update"));
            internalError = true;
        }
        if (!this.hasAdminPermission(currentUser)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"));
            internalError = true;
        }
        if (!internalError) {
            ProjectRole roleByName = this.projectRoleManager.getProjectRole(projectRole.getName());
            if (roleByName != null && !roleByName.getId().equals(projectRole.getId())) {
                errorCollection.addErrorMessage(this.getText("admin.projectroles.duplicate.role.name.error", projectRole.getName()));
            } else {
                this.projectRoleManager.updateRole(projectRole);
            }
        }
    }

    @Override
    public ProjectRoleActors getProjectRoleActors(User currentUser, ProjectRole projectRole, Project project, ErrorCollection errorCollection) {
        boolean internalError = false;
        if (projectRole == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.actors.null.project.role"));
            internalError = true;
        }
        if (project == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.actors.null.project"));
            internalError = true;
        }
        ProjectRoleActors projectRoleActors = null;
        if (!internalError && this.hasProjectRolePermission(currentUser, project)) {
            projectRoleActors = this.projectRoleManager.getProjectRoleActors(projectRole, project);
        } else {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.permission"));
        }
        return projectRoleActors;
    }

    @Override
    public void addActorsToProjectRole(User currentUser, Collection<String> actors, ProjectRole projectRole, Project project, String actorType, ErrorCollection errorCollection) {
        this.updateActorsToProjectRole(currentUser, actors, projectRole, project, actorType, errorCollection, true);
    }

    @Override
    public void removeActorsFromProjectRole(User currentUser, Collection<String> actors, ProjectRole projectRole, Project project, String actorType, ErrorCollection errorCollection) {
        if (this.hasProjectRolePermission(currentUser, project)) {
            if (this.canRemoveCurrentUser(currentUser, actors, projectRole, project, actorType)) {
                this.updateActorsToProjectRole(currentUser, actors, projectRole, project, actorType, errorCollection, false);
            } else {
                errorCollection.addErrorMessage(this.getText("project.roles.service.error.removeself.actor"));
            }
        } else {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.no.permission.to.remove"));
        }
    }

    @Override
    public void setActorsForProjectRole(User currentUser, Map<String, Set<String>> newRoleActors, ProjectRole projectRole, Project project, ErrorCollection errorCollection) {
        ProjectRoleActors projectRoleActors = this.getProjectRoleActors(currentUser, projectRole, project, errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        if (projectRoleActors == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.actors.null"));
            return;
        }
        if (newRoleActors == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.new.role.actors.null"));
            return;
        }
        Set<RoleActor> roleActors = projectRoleActors.getRoleActors();
        HashMap existingRoleActors = Maps.newHashMap();
        for (RoleActor roleActor : roleActors) {
            String actorType = roleActor.getType();
            String actorName = roleActor.getParameter();
            Set actorNames = (Set)existingRoleActors.get(actorType);
            if (actorNames == null) {
                actorNames = Sets.newHashSet();
            }
            actorNames.add(actorName);
            existingRoleActors.put(actorType, actorNames);
        }
        Set<String> allActorTypes = CollectionBuilder.newBuilder().addAll(existingRoleActors.keySet()).addAll((Collection<String>)newRoleActors.keySet()).asSet();
        HashMap toDelete = Maps.newHashMap((Map)existingRoleActors);
        HashMap toAdd = Maps.newHashMap(newRoleActors);
        for (String actorType : allActorTypes) {
            Set<String> newActors = newRoleActors.get(actorType);
            Set actorsToDelete = (Set)toDelete.get(actorType);
            if (newActors != null && actorsToDelete != null) {
                HashSet actorsToDeleteCopy = Sets.newHashSet((Iterable)actorsToDelete);
                actorsToDeleteCopy.removeAll(newActors);
                toDelete.put(actorType, actorsToDeleteCopy);
            }
            Set existingActors = (Set)existingRoleActors.get(actorType);
            Set actorsToAdd = (Set)toAdd.get(actorType);
            if (existingActors == null || actorsToAdd == null) continue;
            HashSet actorsToAddCopy = Sets.newHashSet((Iterable)actorsToAdd);
            actorsToAddCopy.removeAll(existingActors);
            toAdd.put(actorType, actorsToAddCopy);
        }
        for (String actorType : allActorTypes) {
            Set actorNamesToDelete;
            Set actorNamesToAdd = (Set)toAdd.get(actorType);
            if (actorNamesToAdd != null && actorNamesToAdd.size() > 0) {
                this.addActorsToProjectRole(currentUser, actorNamesToAdd, projectRole, project, actorType, errorCollection);
            }
            if ((actorNamesToDelete = (Set)toDelete.get(actorType)) == null || actorNamesToDelete.size() <= 0) continue;
            this.removeActorsFromProjectRole(currentUser, actorNamesToDelete, projectRole, project, actorType, errorCollection);
        }
    }

    boolean canRemoveCurrentUser(User currentUser, Collection<String> actors, ProjectRole projectRole, Project project, String actorType) {
        if (this.permissionManager.hasPermission(0, currentUser)) {
            return true;
        }
        if (!this.doesProjectRoleExistForAdministerProjectsPermission(project, projectRole)) {
            return true;
        }
        ProjectRoleActors projectRoleActors = this.projectRoleManager.getProjectRoleActors(projectRole, project);
        ArrayList<User> allUsers = new ArrayList<User>();
        int rolesRemovedWithMeInIt = 0;
        for (RoleActor roleActorFromProjectRole : projectRoleActors.getRoleActors()) {
            Set<User> roleActorFromProjectRoleUsers = roleActorFromProjectRole.getUsers();
            allUsers.addAll(roleActorFromProjectRoleUsers);
            if (!this.roleActorsToRemoveContainsRoleActorFromProjectRole(roleActorFromProjectRole, actorType, currentUser, actors, projectRole, project)) continue;
            ++rolesRemovedWithMeInIt;
        }
        int amountOfTimesIAmReferenced = this.getAmountOfTimesUsernameInList(allUsers, currentUser);
        return amountOfTimesIAmReferenced > rolesRemovedWithMeInIt;
    }

    boolean doesProjectRoleExistForAdministerProjectsPermission(Project project, ProjectRole projectRole) {
        List<GenericValue> schemesGvs;
        if (this.permissionSchemeManager == null) {
            throw new NullPointerException("Instance of " + PermissionSchemeManager.class.getName() + " required.");
        }
        if (this.schemeFactory == null) {
            throw new NullPointerException("Instance of " + SchemeFactory.class.getName() + " required.");
        }
        if (project == null) {
            throw new NullPointerException("Instance of " + Project.class.getName() + " required.");
        }
        if (projectRole == null) {
            throw new NullPointerException("Instance of " + ProjectRole.class.getName() + " required.");
        }
        try {
            schemesGvs = this.permissionSchemeManager.getSchemes(project.getGenericValue());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
        for (GenericValue schemeGv : schemesGvs) {
            Scheme scheme = this.schemeFactory.getSchemeWithEntitiesComparable(schemeGv);
            List<SchemeEntity> entitiesForProjectAdmin = scheme.getEntitiesByType(new Long(23L));
            for (SchemeEntity schemeEntity : entitiesForProjectAdmin) {
                boolean schemeEntityIsForProjectRole;
                boolean bl = schemeEntityIsForProjectRole = schemeEntity.getParameter() != null && projectRole.getId().toString().equals(schemeEntity.getParameter());
                boolean schemeEntityIsOfTypeProjectRole = "projectrole".equals(schemeEntity.getType());
                if (!schemeEntityIsOfTypeProjectRole || !schemeEntityIsForProjectRole) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DefaultRoleActors getDefaultRoleActors(User currentUser, ProjectRole projectRole, ErrorCollection errorCollection) {
        boolean internalError = false;
        if (projectRole == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.actors.null.project.role"));
            internalError = true;
        }
        DefaultRoleActors defaultRoleActors = null;
        if (!internalError && this.hasAdminPermission(currentUser)) {
            defaultRoleActors = this.projectRoleManager.getDefaultRoleActors(projectRole);
        } else if (!this.hasAdminPermission(currentUser)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"));
        }
        return defaultRoleActors;
    }

    @Override
    public void addDefaultActorsToProjectRole(User currentUser, Collection<String> actors, ProjectRole projectRole, String type, ErrorCollection errorCollection) {
        this.updateActorsToDefaultRole(currentUser, actors, projectRole, type, errorCollection, true);
    }

    @Override
    public void removeDefaultActorsFromProjectRole(User currentUser, Collection<String> actors, ProjectRole projectRole, String actorType, ErrorCollection errorCollection) {
        this.updateActorsToDefaultRole(currentUser, actors, projectRole, actorType, errorCollection, false);
    }

    @Override
    public void removeAllRoleActorsByNameAndType(User currentUser, String name, String type, ErrorCollection errorCollection) {
        ErrorCollection errors = this.validateRemoveAllRoleActorsByNameAndType(currentUser, name, type);
        if (errors.hasAnyErrors()) {
            errorCollection.addErrorCollection(errors);
        } else {
            this.removeAllRoleActorsByNameAndType(name, type);
        }
    }

    @Override
    public ErrorCollection validateRemoveAllRoleActorsByNameAndType(User currentUser, String name, String type) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!TextUtils.stringSet((String)name)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.name.null.remove"));
        }
        if (!TextUtils.stringSet((String)type)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.type.null.remove"));
        }
        if (!this.hasAdminPermission(currentUser)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"));
        }
        return errorCollection;
    }

    @Override
    public void removeAllRoleActorsByNameAndType(String name, String type) {
        this.projectRoleManager.removeAllRoleActorsByNameAndType(name, type);
    }

    @Override
    public void removeAllRoleActorsByProject(User currentUser, Project project, ErrorCollection errorCollection) {
        boolean internalError = false;
        if (project == null || project.getId() == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.null"));
            internalError = true;
        }
        if (!this.hasAdminPermission(currentUser)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"));
            internalError = true;
        }
        if (!internalError) {
            this.projectRoleManager.removeAllRoleActorsByProject(project);
        }
    }

    @Override
    public Collection getAssociatedNotificationSchemes(User currentUser, ProjectRole projectRole, ErrorCollection errorCollection) {
        boolean internalError = false;
        Collection<Object> schemes = new ArrayList();
        if (projectRole == null || projectRole.getId() == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.null"));
            internalError = true;
        }
        if (!internalError) {
            schemes = this.notificationSchemeManager.getSchemesContainingEntity("Project_Role", projectRole.getId().toString());
        }
        return schemes;
    }

    @Override
    public Collection<GenericValue> getAssociatedIssueSecuritySchemes(User currentUser, ProjectRole projectRole, ErrorCollection errorCollection) {
        boolean internalError = false;
        Collection<GenericValue> schemes = new ArrayList<GenericValue>();
        if (projectRole == null || projectRole.getId() == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.null"));
            internalError = true;
        }
        if (!internalError) {
            schemes = this.issueSecuritySchemeManager.getSchemesContainingEntity("projectrole", projectRole.getId().toString());
        }
        return schemes;
    }

    @Override
    public Collection<GenericValue> getAssociatedPermissionSchemes(User currentUser, ProjectRole projectRole, ErrorCollection errorCollection) {
        boolean internalError = false;
        Collection<GenericValue> schemes = new ArrayList<GenericValue>();
        if (projectRole == null || projectRole.getId() == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.null"));
            internalError = true;
        }
        if (!internalError) {
            schemes = this.permissionSchemeManager.getSchemesContainingEntity("projectrole", projectRole.getId().toString());
        }
        return schemes;
    }

    @Override
    public MultiMap getAssociatedWorkflows(User currentUser, ProjectRole projectRole, ErrorCollection errorCollection) {
        Collection<JiraWorkflow> workflows = this.workflowManager.getWorkflows();
        MultiHashMap associatedWorkflows = new MultiHashMap(workflows.size());
        for (JiraWorkflow jiraWorkflow : workflows) {
            Collection<ActionDescriptor> actions = jiraWorkflow.getAllActions();
            for (ActionDescriptor actionDescriptor : actions) {
                ConditionsDescriptor conditionsDescriptor;
                RestrictionDescriptor restriction = actionDescriptor.getRestriction();
                if (restriction == null || !this.conditionsDescriptorContainsProjectRoleCondition(conditionsDescriptor = restriction.getConditionsDescriptor(), projectRole.getId())) continue;
                associatedWorkflows.put((Object)jiraWorkflow, (Object)actionDescriptor);
            }
        }
        return associatedWorkflows;
    }

    @Override
    public Collection<Project> getProjectsContainingRoleActorByNameAndType(User currentUser, String name, String type, ErrorCollection errorCollection) {
        boolean internalError = false;
        if (!TextUtils.stringSet((String)name)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.name.null.remove"));
            internalError = true;
        }
        if (!TextUtils.stringSet((String)type)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.type.null.remove"));
            internalError = true;
        }
        if (!this.hasAdminPermission(currentUser)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"));
            internalError = true;
        }
        if (internalError) {
            return Collections.emptyList();
        }
        Collection<Long> projectIds = this.projectRoleManager.getProjectIdsContainingRoleActorByNameAndType(name, type);
        if (projectIds == null) {
            return Collections.emptyList();
        }
        return this.projectManager.convertToProjectObjects(projectIds);
    }

    @Override
    public List<Long> roleActorOfTypeExistsForProjects(User currentUser, List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String projectRoleParameter, ErrorCollection errorCollection) {
        ArrayList<Long> projectsRoleActorExistsFor = new ArrayList<Long>();
        boolean internalError = false;
        if (projectsToLimitBy == null || projectsToLimitBy.isEmpty()) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.projects.to.limit.needed"));
            internalError = true;
        }
        if (!this.hasAdminPermission(currentUser)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"));
            internalError = true;
        }
        if (!internalError) {
            projectsRoleActorExistsFor.addAll(this.projectRoleManager.roleActorOfTypeExistsForProjects(projectsToLimitBy, projectRole, projectRoleType, projectRoleParameter));
        }
        return projectsRoleActorExistsFor;
    }

    @Override
    public Map<Long, List<String>> getProjectIdsForUserInGroupsBecauseOfRole(User currentUser, List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String userName, ErrorCollection errorCollection) {
        boolean internalError = false;
        if (!this.hasAdminPermission(currentUser)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"));
            internalError = true;
        }
        if (!internalError) {
            return this.projectRoleManager.getProjectIdsForUserInGroupsBecauseOfRole(projectsToLimitBy, projectRole, projectRoleType, userName);
        }
        return new HashMap<Long, List<String>>();
    }

    private boolean conditionsDescriptorContainsProjectRoleCondition(ConditionsDescriptor conditionsDescriptor, Long projectRoleId) {
        for (Object o : conditionsDescriptor.getConditions()) {
            ConditionDescriptor conditionDescriptor;
            Map args;
            String foundProjectRoleId;
            if (!(o instanceof ConditionsDescriptor ? this.conditionsDescriptorContainsProjectRoleCondition((ConditionsDescriptor)o, projectRoleId) : (foundProjectRoleId = (String)(args = (conditionDescriptor = (ConditionDescriptor)o).getArgs()).get("jira.projectrole.id")) != null && foundProjectRoleId.equals(projectRoleId.toString()))) continue;
            return true;
        }
        return false;
    }

    private void updateActorsToProjectRole(User currentUser, Collection<String> actorNames, ProjectRole projectRole, Project project, String actorType, ErrorCollection errorCollection, boolean add) {
        ProjectRoleActors projectRoleActors = this.getProjectRoleActors(currentUser, projectRole, project, errorCollection);
        if (projectRoleActors == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.actors.null"));
            return;
        }
        ArrayList<RoleActor> actors = new ArrayList<RoleActor>();
        boolean internalError = this.createRoleActors(actorNames, projectRole, project, actorType, projectRoleActors, errorCollection, actors, add);
        Project projectRoleProject = this.projectManager.getProjectObj(projectRoleActors.getProjectId());
        if (!internalError && this.hasProjectRolePermission(currentUser, projectRoleProject) && actors.size() > 0) {
            projectRoleActors = add ? (ProjectRoleActors)projectRoleActors.addRoleActors(actors) : (ProjectRoleActors)projectRoleActors.removeRoleActors(actors);
            this.projectRoleManager.updateProjectRoleActors(projectRoleActors);
            this.clearIssueSecurityLevelCache();
        } else if (!this.hasProjectRolePermission(currentUser, projectRoleProject)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.permission"));
        }
    }

    @Override
    public boolean hasProjectRolePermission(User currentUser, Project project) {
        return this.hasAdminPermission(currentUser) || this.hasProjectAdminPermission(currentUser, project);
    }

    private boolean createRoleActors(Collection<String> actors, ProjectRole projectRole, Project project, String actorType, DefaultRoleActors roleActors, ErrorCollection errorCollection, List<RoleActor> actorsTo, boolean add) {
        boolean internalError = false;
        for (String actorName : actors) {
            try {
                Long projectId = project != null ? project.getId() : null;
                Long projectRoleId = projectRole != null ? projectRole.getId() : null;
                ProjectRoleActor projectRoleActor = this.roleActorFactory.createRoleActor(null, projectRoleId, projectId, actorType, actorName);
                if (add && roleActors.getRoleActors().contains(projectRoleActor)) {
                    errorCollection.addErrorMessage(this.getText("admin.user.role.actor.action.error.exists", actorName));
                    internalError = true;
                    continue;
                }
                actorsTo.add(projectRoleActor);
            }
            catch (RoleActorDoesNotExistException ex) {
                errorCollection.addErrorMessage(this.getText("admin.user.role.actor.action.error.invalid", actorName));
                internalError = true;
            }
        }
        return internalError;
    }

    private String getText(String key) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key);
    }

    private String getText(String key, String param) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, param);
    }

    private boolean hasProjectAdminPermission(User currentUser, Project project) {
        return this.permissionManager.hasPermission(23, project, currentUser);
    }

    private boolean hasAdminPermission(User currentUser) {
        return this.permissionManager.hasPermission(0, currentUser);
    }

    private void updateActorsToDefaultRole(User currentUser, Collection<String> actorNames, ProjectRole projectRole, String actorType, ErrorCollection errorCollection, boolean add) {
        DefaultRoleActors defaultRoleActors = this.getDefaultRoleActors(currentUser, projectRole, errorCollection);
        if (defaultRoleActors == null) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.project.role.actors.null"));
            return;
        }
        ArrayList<RoleActor> actors = new ArrayList<RoleActor>();
        boolean internalError = this.createRoleActors(actorNames, projectRole, null, actorType, defaultRoleActors, errorCollection, actors, add);
        if (!internalError && this.hasAdminPermission(currentUser) && actors.size() > 0) {
            defaultRoleActors = add ? defaultRoleActors.addRoleActors(actors) : defaultRoleActors.removeRoleActors(actors);
            this.projectRoleManager.updateDefaultRoleActors(defaultRoleActors);
        } else if (!this.hasAdminPermission(currentUser)) {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"));
        }
    }

    private int getAmountOfTimesUsernameInList(Collection<User> allUsers, User currentUser) {
        int numberOfTimesIAmReferenced = 0;
        for (User user : allUsers) {
            if (!user.getName().equals(currentUser.getName())) continue;
            ++numberOfTimesIAmReferenced;
        }
        return numberOfTimesIAmReferenced;
    }

    private boolean roleActorsToRemoveContainsRoleActorFromProjectRole(RoleActor roleActorFromProjectRole, String actorType, User currentUser, Collection<String> actors, ProjectRole projectRole, Project project) {
        if (roleActorFromProjectRole.getType().equals(actorType) && roleActorFromProjectRole.contains(currentUser)) {
            for (String actorName : actors) {
                ProjectRoleActor roleActorToRemove = null;
                try {
                    roleActorToRemove = this.roleActorFactory.createRoleActor(null, projectRole.getId(), project.getId(), actorType, actorName);
                }
                catch (RoleActorDoesNotExistException e) {
                    throw new IllegalArgumentException("Unexpected error: the role actor '" + actorName + "' of type '" + actorType + "' does not exist.");
                }
                if (!roleActorToRemove.equals(roleActorFromProjectRole)) continue;
                return true;
            }
        }
        return false;
    }

    private void clearIssueSecurityLevelCache() {
        try {
            if (this.issueSecurityLevelManager != null) {
                this.issueSecurityLevelManager.clearUsersLevels();
            }
        }
        catch (UnsupportedOperationException uoe) {
            log.debug((Object)"Unsupported operation was thrown when trying to clear the issue security level manager cache", (Throwable)uoe);
        }
    }
}

