/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.component;

import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.ComponentConverter;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentStore;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfBizProjectComponentStore
implements ProjectComponentStore {
    public static final Logger log = Logger.getLogger(ProjectComponentStore.class);
    private final OfBizDelegator delegator;
    static final String FIELD_ID = "id";
    static final String FIELD_NAME = "name";
    static final String FIELD_DESCRIPTION = "description";
    static final String FIELD_LEAD = "lead";
    static final String FIELD_PROJECT = "project";
    static final String FIELD_ASSIGNEE_TYPE = "assigneetype";

    public OfBizProjectComponentStore(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    @Override
    public MutableProjectComponent find(Long id) throws EntityNotFoundException {
        this.validateId(id);
        GenericValue componentGV = this.findComponentGV(FIELD_ID, id);
        if (componentGV == null) {
            throw new EntityNotFoundException("Component with ID = '" + id + "' does not exist.");
        }
        return this.getComponentConverter().convertToComponent(componentGV);
    }

    @Override
    public Collection findAllForProject(Long projectId) {
        return this.getComponentConverter().convertToComponents(this.findComponentGVs(FIELD_PROJECT, projectId, FIELD_NAME));
    }

    protected ComponentConverter getComponentConverter() {
        return new ComponentConverter();
    }

    @Override
    public MutableProjectComponent findByComponentName(Long projectId, String componentName) throws IllegalArgumentException {
        if (projectId == null) {
            throw new IllegalArgumentException("Project ID is required, was null.");
        }
        if (componentName == null) {
            throw new IllegalArgumentException("Component Name is required, was null.");
        }
        List<GenericValue> components = this.delegator.findByAnd("Component", MapBuilder.newBuilder().add(FIELD_PROJECT, projectId).add(FIELD_NAME, (Long)((Object)componentName)).toMap());
        if (components.size() == 1) {
            return this.getComponentConverter().convertToComponent(components.get(0));
        }
        if (components.size() == 0) {
            return null;
        }
        log.error((Object)("found " + components.size() + " components with name " + componentName + " in project with id " + projectId));
        return (MutableProjectComponent)components.get(0);
    }

    @Override
    public Collection<MutableProjectComponent> findByComponentNameCaseInSensitive(String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException("Component Name is required, was null.");
        }
        Collection<MutableProjectComponent> components = this.getComponentConverter().convertToComponents(this.delegator.findAll("Component"));
        ArrayList<MutableProjectComponent> matched = new ArrayList<MutableProjectComponent>();
        for (MutableProjectComponent component : components) {
            if (!componentName.equalsIgnoreCase(component.getName())) continue;
            matched.add(component);
        }
        return matched;
    }

    @Override
    public Long findProjectIdForComponent(Long componentId) throws EntityNotFoundException {
        GenericValue componentGV = this.findComponentGV(FIELD_ID, componentId);
        if (componentGV == null) {
            throw new EntityNotFoundException("Component with ID = '" + componentId + "' does not exist.");
        }
        return componentGV.getLong(FIELD_PROJECT);
    }

    @Override
    public MutableProjectComponent store(MutableProjectComponent component) throws EntityNotFoundException, DataAccessException {
        this.validateProjectId(component);
        this.validateName(component);
        Long id = component.getId();
        if (id == null) {
            String name = component.getName();
            HashMap<String, Object> componentParams = new HashMap<String, Object>();
            componentParams.put(FIELD_NAME, name);
            componentParams.put(FIELD_DESCRIPTION, component.getDescription());
            componentParams.put(FIELD_LEAD, component.getLead());
            componentParams.put(FIELD_PROJECT, component.getProjectId());
            componentParams.put(FIELD_ASSIGNEE_TYPE, component.getAssigneeType());
            GenericValue componentGV = this.delegator.createValue("Component", componentParams);
            component.setId(componentGV.getLong(FIELD_ID));
            component.setGenericValue(componentGV);
        } else {
            if (this.findComponentGV(FIELD_ID, component.getId()) == null) {
                throw new EntityNotFoundException("Component with ID = '" + id + "' does not exist.");
            }
            GenericValue componentGV = component.getGenericValue();
            if (componentGV == null) {
                throw new EntityNotFoundException("Component with ID = '" + id + "' does not exist.");
            }
            componentGV.setString(FIELD_NAME, component.getName());
            componentGV.setString(FIELD_DESCRIPTION, component.getDescription());
            componentGV.setString(FIELD_LEAD, component.getLead());
            componentGV.set(FIELD_ASSIGNEE_TYPE, (Object)component.getAssigneeType());
            try {
                componentGV.store();
            }
            catch (GenericEntityException e) {
                throw new DataAccessException("Unable to update the component with ID = '" + id + "'.", e);
            }
        }
        return MutableProjectComponent.copy(component);
    }

    private void validateName(MutableProjectComponent component) throws IllegalArgumentException {
        if (component.getName() == null) {
            throw new IllegalArgumentException("Name is required, was null.");
        }
    }

    private void validateProjectId(MutableProjectComponent component) throws IllegalArgumentException {
        if (component.getProjectId() == null) {
            throw new IllegalArgumentException("Project ID is required, was null.");
        }
    }

    private void validateId(Long id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("Project Component ID is required, was null.");
        }
    }

    @Override
    public void delete(Long componentId) throws EntityNotFoundException {
        int deleted = this.delegator.removeByAnd("Component", MapBuilder.build(FIELD_ID, componentId));
        if (deleted == 0) {
            throw new EntityNotFoundException("Unable to find the component with ID = '" + componentId + "' for deletion.");
        }
    }

    @Override
    public boolean containsName(String name, Long projectId) {
        if (projectId == null) {
            throw new IllegalArgumentException("Component project ID can not be null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Component name can not be null!");
        }
        List<GenericValue> componentsForProject = this.findComponentGVs(FIELD_PROJECT, projectId);
        for (GenericValue componentGV : componentsForProject) {
            if (!name.equalsIgnoreCase(componentGV.getString(FIELD_NAME))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection findComponentsBylead(String userName) {
        return this.getComponentConverter().convertToComponents(this.findComponentGVs(FIELD_LEAD, userName));
    }

    @Override
    public Collection findAll() {
        return this.getComponentConverter().convertToComponents(this.delegator.findAll("Component", CollectionBuilder.list(FIELD_NAME)));
    }

    private GenericValue findComponentGV(String fieldName, Object fieldValue) {
        return EntityUtil.getOnly(this.findComponentGVs(fieldName, fieldValue));
    }

    private List<GenericValue> findComponentGVs(String fieldName, Object fieldValue) {
        return this.delegator.findByAnd("Component", MapBuilder.build(fieldName, fieldValue));
    }

    private List<GenericValue> findComponentGVs(String fieldName, Object fieldValue, String orderByField) {
        return this.delegator.findByAnd("Component", MapBuilder.build(fieldName, fieldValue), CollectionBuilder.list(orderByField));
    }
}

