/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.component;

import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.ComponentConverter;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.bc.project.component.ProjectComponentStore;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comparator.ComponentComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultProjectComponentManager
implements ProjectComponentManager {
    private final ProjectComponentStore store;
    private final IssueManager issueManager;
    protected static final String FIELD_PROJECT_ID = "projectId";
    protected static final String FIELD_NAME = "name";
    protected static final String FIELD_LEAD = "lead";

    public DefaultProjectComponentManager(ProjectComponentStore store, IssueManager issueManager) {
        this.store = store;
        this.issueManager = issueManager;
    }

    @Override
    public ProjectComponent create(String name, String description, String lead, long assigneeType, Long projectId) throws IllegalArgumentException {
        try {
            MutableProjectComponent component = new MutableProjectComponent(null, name, description, lead, assigneeType, projectId);
            return this.convertToProjectComponent(this.store.store(component));
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    @Override
    public ProjectComponent find(Long id) throws EntityNotFoundException {
        return this.convertToProjectComponent(this.store.find(id));
    }

    @Override
    public Collection<ProjectComponent> findAllForProject(Long projectId) {
        return this.convertToProjectComponents(this.store.findAllForProject(projectId));
    }

    @Override
    public Collection<ProjectComponent> findAll() {
        return this.convertToProjectComponents(this.store.findAll());
    }

    @Override
    public List<ProjectComponent> getComponents(List<Long> ids) throws EntityNotFoundException {
        ArrayList<ProjectComponent> components = new ArrayList<ProjectComponent>(ids.size());
        for (Long id : ids) {
            components.add(this.find(id));
        }
        return components;
    }

    @Override
    public ProjectComponent update(MutableProjectComponent component) throws EntityNotFoundException {
        this.store.store(component);
        return this.convertToProjectComponent(component);
    }

    @Override
    public void delete(Long componentId) throws EntityNotFoundException {
        this.store.delete(componentId);
    }

    @Override
    public boolean containsName(String name, Long projectId) {
        return this.store.containsName(name, projectId);
    }

    @Override
    public Long findProjectIdForComponent(Long id) throws EntityNotFoundException {
        return this.store.findProjectIdForComponent(id);
    }

    protected ProjectComponent convertToProjectComponent(MutableProjectComponent value) {
        return this.getComponentConverter().convertToProjectComponent(value);
    }

    protected MutableProjectComponent convertToMutableProjectComponent(ProjectComponent value) {
        return new MutableProjectComponent(value.getId(), value.getName(), value.getDescription(), value.getLead(), value.getAssigneeType(), value.getProjectId());
    }

    private Collection<ProjectComponent> convertToProjectComponents(Collection<MutableProjectComponent> mutables) {
        return this.getComponentConverter().convertToProjectComponents(mutables);
    }

    @Override
    public GenericValue convertToGenericValue(ProjectComponent projectComponent) {
        if (projectComponent == null) {
            return null;
        }
        return projectComponent.getGenericValue();
    }

    @Override
    public Collection<GenericValue> convertToGenericValues(Collection<ProjectComponent> projectComponents) {
        ArrayList<GenericValue> projectComponentGVs = new ArrayList<GenericValue>(projectComponents.size());
        for (ProjectComponent projectComponent : projectComponents) {
            projectComponentGVs.add(projectComponent.getGenericValue());
        }
        return projectComponentGVs;
    }

    @Override
    public ProjectComponent findByComponentName(Long projectId, String componentName) {
        try {
            MutableProjectComponent pc = this.store.findByComponentName(projectId, componentName);
            return pc == null ? null : this.convertToProjectComponent(pc);
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    @Override
    public Collection<ProjectComponent> findByComponentNameCaseInSensitive(String componentName) {
        return this.convertToProjectComponents(this.store.findByComponentNameCaseInSensitive(componentName));
    }

    @Override
    public Collection<ProjectComponent> findComponentsByLead(String userName) {
        return this.store.findComponentsBylead(userName);
    }

    @Override
    public Collection<ProjectComponent> findComponentsByIssue(Issue issue) {
        Collection<GenericValue> components = issue.getComponents();
        Collection<MutableProjectComponent> mutableComponents = this.getComponentConverter().convertToComponents(components);
        return this.convertToProjectComponents(mutableComponents);
    }

    @Override
    public Collection<GenericValue> findComponentsByIssueGV(Issue issue) {
        List<GenericValue> components;
        GenericValue genericValue = issue.getGenericValue();
        if (genericValue != null) {
            try {
                ArrayList<GenericValue> newValue = new ArrayList<GenericValue>(this.issueManager.getEntitiesByIssue("IssueComponent", genericValue));
                Collections.sort(newValue, ComponentComparator.COMPARATOR);
                components = newValue;
            }
            catch (GenericEntityException e) {
                throw new DataAccessException("Error occurred while retrieving components for issue with id " + issue.getId() + "'.", e);
            }
        } else {
            components = Collections.emptyList();
        }
        return components;
    }

    protected ComponentConverter getComponentConverter() {
        return new ComponentConverter();
    }
}

