/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.portal;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.gadgets.directory.spi.ExternalGadgetSpec;
import com.atlassian.gadgets.directory.spi.ExternalGadgetSpecStore;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GadgetApplinkUpgradeUtil
implements Startable {
    private final ExternalGadgetSpecStore externalGadgetSpecStore;
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private final EventPublisher eventPublisher;
    private final ResettableLazyReference<Boolean> ref = new ResettableLazyReference<Boolean>(){

        protected Boolean create() throws Exception {
            if (!GadgetApplinkUpgradeUtil.this.applicationProperties.getOption("jira.gadget.applink.upgrade.finished")) {
                Iterable entries = GadgetApplinkUpgradeUtil.this.externalGadgetSpecStore.entries();
                return !Iterables.isEmpty((Iterable)entries);
            }
            return false;
        }
    };

    public GadgetApplinkUpgradeUtil(ExternalGadgetSpecStore externalGadgetSpecStore, ApplicationProperties applicationProperties, PermissionManager permissionManager, EventPublisher eventPublisher) {
        this.externalGadgetSpecStore = externalGadgetSpecStore;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.eventPublisher = eventPublisher;
    }

    public boolean isUpgradeRequired(User user) {
        if (this.permissionManager.hasPermission(44, user)) {
            return (Boolean)this.ref.get();
        }
        return false;
    }

    public Map<URI, List<ExternalGadgetSpec>> getExternalGadgetsRequiringUpgrade() {
        LinkedHashMap<URI, List<ExternalGadgetSpec>> ret = new LinkedHashMap<URI, List<ExternalGadgetSpec>>();
        for (ExternalGadgetSpec spec : this.externalGadgetSpecStore.entries()) {
            URI specUri = spec.getSpecUri();
            URI host = URI.create(specUri.getScheme() + "://" + specUri.getAuthority());
            if (!ret.containsKey(host)) {
                ret.put(host, new ArrayList());
            }
            ((List)ret.get(host)).add(spec);
        }
        return ret;
    }

    public void disableUpgradeCheck() {
        this.applicationProperties.setOption("jira.gadget.applink.upgrade.finished", true);
        this.ref.reset();
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.ref.reset();
    }
}

