/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.license;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.license.JiraLicenseUpdaterService;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import java.text.NumberFormat;

public class JiraLicenseServiceImpl
implements JiraLicenseUpdaterService {
    private static final int MIN_LICENSE_VERSION = 2;
    private final JiraLicenseManager licenseManager;
    private final BuildUtilsInfo buildUtilsInfo;
    private final UserUtil userUtil;

    public JiraLicenseServiceImpl(JiraLicenseManager licenseManager, BuildUtilsInfo buildUtilsInfo, UserUtil userUtil) {
        this.licenseManager = Assertions.notNull("licenseManager", licenseManager);
        this.buildUtilsInfo = Assertions.notNull("buildUtilsInfo", buildUtilsInfo);
        this.userUtil = Assertions.notNull("userUtil", userUtil);
    }

    @Override
    public String getServerId() {
        return this.licenseManager.getServerId();
    }

    @Override
    public LicenseDetails getLicense() {
        return this.licenseManager.getLicense();
    }

    @Override
    public JiraLicenseService.ValidationResult validate(I18nHelper i18nHelper, String licenseString) {
        OurValidationResult validationResult = new OurValidationResult(licenseString);
        if (!this.licenseManager.isDecodeable(licenseString)) {
            validationResult.addError(i18nHelper.getText("setup.error.invalidlicensekey"));
        } else {
            LicenseDetails licenseDetails = this.licenseManager.getLicense(licenseString);
            if (this.checkLicenseVersion(i18nHelper, validationResult, licenseDetails)) {
                String buildPartnerName = this.buildUtilsInfo.getBuildPartnerName();
                String licensePartnerName = licenseDetails.getPartnerName();
                if (StringUtils.isNotBlank((String)licensePartnerName) && !licensePartnerName.equals(buildPartnerName)) {
                    validationResult.addError(i18nHelper.getText("setup.error.invalidlicensekey.regional.license", licensePartnerName));
                } else if (StringUtils.isBlank((String)licensePartnerName) && StringUtils.isNotBlank((String)buildPartnerName)) {
                    validationResult.addError(i18nHelper.getText("setup.error.invalidlicensekey.regional.installation", buildPartnerName));
                }
            }
        }
        return validationResult;
    }

    private boolean checkLicenseVersion(I18nHelper i18nHelper, OurValidationResult validationResult, LicenseDetails licenseDetails) {
        int licenseVersion = licenseDetails.getLicenseVersion();
        validationResult.setLicenseVersion(licenseVersion);
        if (licenseVersion < 2) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            int totalUserCount = this.userUtil.getTotalUserCount();
            int activeUserCount = this.userUtil.getActiveUserCount();
            validationResult.setTotalUserCount(totalUserCount);
            validationResult.setActiveUserCount(activeUserCount);
            validationResult.addError(i18nHelper.getText("setup.error.invalidlicensekey.v1.license.version", nf.format(totalUserCount), nf.format(activeUserCount)));
            return false;
        }
        return true;
    }

    @Override
    public LicenseDetails setLicense(JiraLicenseService.ValidationResult validationResult) {
        if (validationResult == null || validationResult.getErrorCollection() == null || validationResult.getErrorCollection().hasAnyErrors()) {
            throw new IllegalStateException("setLicense called with illegal ValidationResult object");
        }
        return this.licenseManager.setLicense(validationResult.getLicenseString());
    }

    @Override
    public void confirmProceedUnderEvaluationTerms(String userName) {
        this.licenseManager.confirmProceedUnderEvaluationTerms(userName);
    }

    private static final class OurValidationResult
    implements JiraLicenseService.ValidationResult {
        private static final String LICENSE_FIELD = "license";
        private final SimpleErrorCollection errorCollection;
        private final String licenceString;
        private int totalUserCount;
        private int activeUserCount;
        private int licenseVersion;

        public OurValidationResult(String licenceString) {
            this.licenceString = licenceString;
            this.errorCollection = new SimpleErrorCollection();
        }

        private void addError(String message) {
            this.errorCollection.addError(LICENSE_FIELD, message);
        }

        @Override
        public ErrorCollection getErrorCollection() {
            SimpleErrorCollection copied = new SimpleErrorCollection();
            copied.addErrorCollection(this.errorCollection);
            return copied;
        }

        @Override
        public String getLicenseString() {
            return this.licenceString;
        }

        @Override
        public int getLicenseVersion() {
            return this.licenseVersion;
        }

        public void setLicenseVersion(int licenseVersion) {
            this.licenseVersion = licenseVersion;
        }

        @Override
        public int getTotalUserCount() {
            return this.totalUserCount;
        }

        public void setTotalUserCount(int totalUserCount) {
            this.totalUserCount = totalUserCount;
        }

        @Override
        public int getActiveUserCount() {
            return this.activeUserCount;
        }

        public void setActiveUserCount(int activeUserCount) {
            this.activeUserCount = activeUserCount;
        }
    }
}

