/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.watcher;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bc.issue.watcher.WatchingDisabledException;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWatcherService
implements WatcherService {
    private final Logger log = LoggerFactory.getLogger(DefaultWatcherService.class);
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory i18n;
    private final PermissionManager permissionManager;
    private final WatcherManager watcherManager;
    private final UserManager userManager;

    public DefaultWatcherService(ApplicationProperties applicationProperties, I18nHelper.BeanFactory i18n, PermissionManager permissionManager, WatcherManager watcherManager, UserManager userManager) {
        this.watcherManager = watcherManager;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.i18n = i18n;
    }

    @Override
    public ServiceOutcome<Pair<Integer, List<User>>> getWatchers(Issue issue, @Nullable User remoteUser) throws WatchingDisabledException {
        Pair<Integer, List<String>> watchers = this.getWatcherUsernames(issue, remoteUser);
        return ServiceOutcomeImpl.ok(this.convertUsers(watchers, new UserFromName()));
    }

    @Override
    public ServiceOutcome<List<User>> addWatcher(Issue issue, User remoteUser, User watcher) throws WatchingDisabledException {
        try {
            this.checkModifyWatchersPermission(issue, remoteUser, watcher);
            this.watcherManager.startWatching(watcher, issue.getGenericValue());
            return ServiceOutcomeImpl.ok(this.getCurrentWatchersFor(issue));
        }
        catch (PermissionException e) {
            return ServiceOutcomeImpl.error(this.buildAddWatcherNotAllowedString(issue, remoteUser));
        }
    }

    @Override
    public ServiceOutcome<List<User>> removeWatcher(Issue issue, User remoteUser, User watcher) throws WatchingDisabledException {
        try {
            this.checkModifyWatchersPermission(issue, remoteUser, watcher);
            this.watcherManager.stopWatching(watcher, issue.getGenericValue());
            return ServiceOutcomeImpl.ok(this.getCurrentWatchersFor(issue));
        }
        catch (PermissionException e) {
            return ServiceOutcomeImpl.error(this.buildRemoveUserNotAllowedString(issue, remoteUser));
        }
    }

    @Override
    public boolean isWatchingEnabled() {
        return this.applicationProperties.getOption("jira.option.watching");
    }

    @Override
    public boolean hasViewWatcherListPermission(Issue issue, @Nullable User remoteUser) {
        return this.permissionManager.hasPermission(31, issue, remoteUser) || this.canEditWatcherList(issue, remoteUser);
    }

    protected Pair<Integer, List<String>> getWatcherUsernames(Issue issue, User remoteUser) throws WatchingDisabledException {
        if (!this.isWatchingEnabled()) {
            throw new WatchingDisabledException();
        }
        List<String> watcherNames = this.watcherManager.getCurrentWatcherUsernames(issue);
        int watcherCount = watcherNames.size();
        if (!this.hasViewWatcherListPermission(issue, remoteUser)) {
            if (remoteUser == null) {
                watcherNames.clear();
            } else {
                watcherNames.retainAll(Collections.singletonList(remoteUser.getName()));
            }
        }
        this.log.trace("Visible watchers on issue '{}': {}", (Object)issue.getKey(), watcherNames);
        return Pair.of(watcherCount, watcherNames);
    }

    protected <T> List<User> getCurrentWatchersFor(Issue issue) {
        List<String> watcherNames = this.watcherManager.getCurrentWatcherUsernames(issue.getGenericValue());
        return DefaultWatcherService.newListFrom(watcherNames, new UserFromName());
    }

    protected boolean canEditWatcherList(Issue issue, @Nullable User remoteUser) {
        return this.permissionManager.hasPermission(32, issue, remoteUser);
    }

    protected <T extends User> Pair<Integer, List<T>> convertUsers(Pair<Integer, List<String>> watchers, Function<String, T> function) {
        return Pair.of(watchers.first(), Lists.newArrayList((Iterable)Lists.transform(watchers.second(), function)));
    }

    protected void checkModifyWatchersPermission(Issue issue, User remoteUser, User watcher) throws PermissionException, WatchingDisabledException {
        if (!this.isWatchingEnabled()) {
            throw new WatchingDisabledException();
        }
        boolean canView = this.permissionManager.hasPermission(10, issue, watcher);
        if (!canView) {
            throw new PermissionException();
        }
        boolean canManage = this.permissionManager.hasPermission(32, issue, remoteUser);
        if (!canManage && !remoteUser.equals(watcher)) {
            throw new PermissionException();
        }
    }

    private String buildAddWatcherNotAllowedString(Issue issue, User remoteUser) {
        return this.i18n.getInstance(remoteUser).getText("watcher.service.error.add.watcher.not.allowed", remoteUser.getName(), issue.getKey());
    }

    private String buildRemoveUserNotAllowedString(Issue issue, User remoteUser) {
        return this.i18n.getInstance(remoteUser).getText("watcher.service.error.remove.watcher.not.allowed", remoteUser.getName(), issue.getKey());
    }

    static <F, T> List<T> newListFrom(List<F> from, Function<F, T> fn) {
        return Lists.newArrayList((Iterable)Lists.transform(from, fn));
    }

    static class PermissionException
    extends Exception {
        PermissionException() {
        }
    }

    class UserFromName
    implements Function<String, User> {
        UserFromName() {
        }

        public User apply(String username) {
            return DefaultWatcherService.this.userManager.getUser(username);
        }
    }
}

