/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.QueryCache;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class QueryCacheImpl
implements QueryCache {
    @Override
    public Boolean getDoesQueryFitFilterFormCache(User searcher, Query query) {
        return this.getFitCache().get(new QueryCacheKey(searcher, query));
    }

    @Override
    public void setDoesQueryFitFilterFormCache(User searcher, Query query, boolean doesItFit) {
        this.getFitCache().put(new QueryCacheKey(searcher, query), doesItFit);
    }

    @Override
    public QueryContext getQueryContextCache(User searcher, Query query) {
        return this.getQueryCache().get(new QueryCacheKey(searcher, query));
    }

    @Override
    public void setQueryContextCache(User searcher, Query query, QueryContext queryContext) {
        this.getQueryCache().put(new QueryCacheKey(searcher, query), queryContext);
    }

    @Override
    public QueryContext getSimpleQueryContextCache(User searcher, Query query) {
        return this.getExplicitQueryCache().get(new QueryCacheKey(searcher, query));
    }

    @Override
    public void setSimpleQueryContextCache(User searcher, Query query, QueryContext queryContext) {
        this.getExplicitQueryCache().put(new QueryCacheKey(searcher, query), queryContext);
    }

    @Override
    public Collection<ClauseHandler> getClauseHandlers(User searcher, String jqlClauseName) {
        return this.getClauseHandlerCache().get(new QueryCacheClauseHandlerKey(searcher, jqlClauseName));
    }

    @Override
    public void setClauseHandlers(User searcher, String jqlClauseName, Collection<ClauseHandler> clauseHandlers) {
        this.getClauseHandlerCache().put(new QueryCacheClauseHandlerKey(searcher, jqlClauseName), clauseHandlers);
    }

    Map<QueryCacheKey, QueryContext> getExplicitQueryCache() {
        return QueryCacheImpl.getCache("jira.simple.query.context.cache");
    }

    Map<QueryCacheKey, QueryContext> getQueryCache() {
        return QueryCacheImpl.getCache("jira.query.context.cache");
    }

    Map<QueryCacheKey, Boolean> getFitCache() {
        return QueryCacheImpl.getCache("jira.query.does.it.fit.navigator.cache");
    }

    Map<QueryCacheClauseHandlerKey, Collection<ClauseHandler>> getClauseHandlerCache() {
        return QueryCacheImpl.getCache("jira.jql.clause.handler.cache");
    }

    static <K, V> Map<K, V> getCache(String key) {
        Map<String, Object> requestCache = JiraAuthenticationContextImpl.getRequestCache();
        HashMap result = (HashMap)requestCache.get(key);
        if (result == null) {
            result = new HashMap();
            requestCache.put(key, result);
        }
        return result;
    }

    static class QueryCacheClauseHandlerKey {
        private final User searcher;
        private final String jqlClauseName;

        public QueryCacheClauseHandlerKey(User searcher, String jqlClauseName) {
            this.searcher = searcher;
            this.jqlClauseName = Assertions.notNull("jqlClauseName", jqlClauseName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryCacheClauseHandlerKey that = (QueryCacheClauseHandlerKey)o;
            if (!this.jqlClauseName.equals(that.jqlClauseName)) {
                return false;
            }
            return !(this.searcher != null ? !this.searcher.equals(that.searcher) : that.searcher != null);
        }

        public int hashCode() {
            int result = this.searcher != null ? this.searcher.hashCode() : 0;
            result = 31 * result + this.jqlClauseName.hashCode();
            return result;
        }
    }

    static class QueryCacheKey {
        private final User searcher;
        private final Query query;

        public QueryCacheKey(User searcher, Query query) {
            this.searcher = searcher;
            this.query = Assertions.notNull("query", query);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryCacheKey that = (QueryCacheKey)o;
            if (!this.query.equals(that.query)) {
                return false;
            }
            return !(this.searcher != null ? !this.searcher.equals(that.searcher) : that.searcher != null);
        }

        public int hashCode() {
            int result = this.searcher != null ? this.searcher.hashCode() : 0;
            result = 31 * result + this.query.hashCode();
            return result;
        }
    }
}

