/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.search;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.issue.search.HistoryIssuePickerSearchProvider;
import com.atlassian.jira.bc.issue.search.IssuePickerResults;
import com.atlassian.jira.bc.issue.search.IssuePickerSearchProvider;
import com.atlassian.jira.bc.issue.search.IssuePickerSearchService;
import com.atlassian.jira.bc.issue.search.LuceneCurrentSearchIssuePickerSearchProvider;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class DefaultIssuePickerSearchService
implements IssuePickerSearchService {
    private final List<IssuePickerSearchProvider> searchProvidersCollection;
    private static final String RUNNING_ISSUE_PICKER_SEARCH = "Running issue-picker search: ";

    static DefaultIssuePickerSearchService create(IssuePickerSearchProvider ... providers) {
        return new DefaultIssuePickerSearchService(providers);
    }

    public DefaultIssuePickerSearchService(HistoryIssuePickerSearchProvider historyProvider, LuceneCurrentSearchIssuePickerSearchProvider searchProvider) {
        this(new IssuePickerSearchProvider[]{historyProvider, searchProvider});
    }

    private DefaultIssuePickerSearchService(IssuePickerSearchProvider ... providers) {
        this.searchProvidersCollection = new ArrayList<IssuePickerSearchProvider>(Arrays.asList(providers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IssuePickerResults> getResults(JiraServiceContext context, IssuePickerSearchService.IssuePickerParameters issuePickerParams) {
        String timer = RUNNING_ISSUE_PICKER_SEARCH + issuePickerParams.getQuery();
        UtilTimerStack.push((String)timer);
        try {
            ArrayList<IssuePickerResults> results = new ArrayList<IssuePickerResults>();
            int issuesRemaining = issuePickerParams.getLimit();
            for (IssuePickerSearchProvider issuePickerSearchProvider : this.searchProvidersCollection) {
                IssuePickerResults result;
                int size;
                if (!issuePickerSearchProvider.handlesParameters(context.getLoggedInUser(), issuePickerParams)) continue;
                if ((size = (result = issuePickerSearchProvider.getResults(context, issuePickerParams, --issuesRemaining)).getIssues().size()) == 0) {
                    size = 1;
                }
                results.add(result);
                if ((issuesRemaining -= size) > 0) continue;
                ArrayList<IssuePickerResults> arrayList = results;
                return arrayList;
            }
            ArrayList<IssuePickerResults> arrayList = results;
            return arrayList;
        }
        finally {
            UtilTimerStack.pop((String)timer);
        }
    }
}

