/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.link;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.link.RemoteIssueLinkService;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.exception.UpdateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRemoteIssueLinkService
implements RemoteIssueLinkService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRemoteIssueLinkService.class);
    private final RemoteIssueLinkManager remoteIssueLinkManager;
    private final IssueService issueService;
    private final IssueManager issueManager;
    private final IssueLinkManager issueLinkManager;
    private final I18nHelper.BeanFactory beanFactory;
    private final PermissionManager permissionManager;

    public DefaultRemoteIssueLinkService(RemoteIssueLinkManager remoteIssueLinkManager, IssueService issueService, IssueManager issueManager, IssueLinkManager issueLinkManager, I18nHelper.BeanFactory beanFactory, PermissionManager permissionManager) {
        this.remoteIssueLinkManager = remoteIssueLinkManager;
        this.issueService = issueService;
        this.issueManager = issueManager;
        this.issueLinkManager = issueLinkManager;
        this.beanFactory = beanFactory;
        this.permissionManager = permissionManager;
    }

    @Override
    public RemoteIssueLinkService.RemoteIssueLinkResult getRemoteIssueLink(User user, Long remoteIssueLinkId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.getI18n(user);
        this.validateLinkingEnabled(i18n, errors);
        RemoteIssueLink remoteIssueLink = null;
        if (!errors.hasAnyErrors() && (remoteIssueLink = this.remoteIssueLinkManager.getRemoteIssueLink(remoteIssueLinkId)) == null) {
            errors.addErrorMessage(i18n.getText("remotelink.service.does.not.exist"), ErrorCollection.Reason.NOT_FOUND);
        }
        if (!errors.hasAnyErrors()) {
            this.validatePermissionToView(user, remoteIssueLink, (ErrorCollection)errors, i18n);
        }
        return new RemoteIssueLinkService.RemoteIssueLinkResult(errors.hasAnyErrors() ? null : remoteIssueLink, errors);
    }

    @Override
    public RemoteIssueLinkService.RemoteIssueLinkListResult getRemoteIssueLinksForIssue(User user, Issue issue) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.getI18n(user);
        this.validateLinkingEnabled(i18n, errors);
        if (!errors.hasAnyErrors()) {
            this.validatePermissionToView(user, issue, (ErrorCollection)errors, i18n);
        }
        List<RemoteIssueLink> remoteIssueLinks = null;
        if (!errors.hasAnyErrors()) {
            remoteIssueLinks = this.remoteIssueLinkManager.getRemoteIssueLinksForIssue(issue);
        }
        return new RemoteIssueLinkService.RemoteIssueLinkListResult(errors.hasAnyErrors() ? null : remoteIssueLinks, errors);
    }

    @Override
    public RemoteIssueLinkService.RemoteIssueLinkResult getRemoteIssueLinkByGlobalId(User user, Issue issue, String globalId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.getI18n(user);
        this.validateLinkingEnabled(i18n, errors);
        if (!errors.hasAnyErrors()) {
            this.validatePermissionToView(user, issue, (ErrorCollection)errors, i18n);
        }
        RemoteIssueLink remoteIssueLink = null;
        if (!errors.hasAnyErrors() && (remoteIssueLink = this.remoteIssueLinkManager.getRemoteIssueLinkByGlobalId(issue, globalId)) == null) {
            errors.addErrorMessage(i18n.getText("remotelink.service.does.not.exist"), ErrorCollection.Reason.NOT_FOUND);
        }
        return new RemoteIssueLinkService.RemoteIssueLinkResult(errors.hasAnyErrors() ? null : remoteIssueLink, errors);
    }

    @Override
    public RemoteIssueLinkService.CreateValidationResult validateCreate(User user, RemoteIssueLink remoteIssueLink) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.getI18n(user);
        this.validateLinkingEnabled(i18n, errors);
        Issue issue = null;
        if (!errors.hasAnyErrors()) {
            issue = this.validateIssueExists(remoteIssueLink, errors, i18n);
        }
        if (!errors.hasAnyErrors()) {
            this.validatePermissionToCreate(user, issue, errors, i18n);
        }
        if (!errors.hasAnyErrors()) {
            this.validateMandatoryFields(remoteIssueLink, i18n, errors);
            this.validateFieldLengths(remoteIssueLink, i18n, errors);
            this.validateUrls(remoteIssueLink, i18n, errors);
            this.validateGlobalId(remoteIssueLink, issue, errors, i18n);
        }
        return new RemoteIssueLinkService.CreateValidationResult(errors.hasAnyErrors() ? null : remoteIssueLink, errors);
    }

    @Override
    public RemoteIssueLinkService.RemoteIssueLinkResult create(User user, RemoteIssueLinkService.CreateValidationResult createValidationResult) {
        if (createValidationResult == null) {
            throw new IllegalArgumentException("You cannot create a remote issue link with a null validation result.");
        }
        if (!createValidationResult.isValid()) {
            throw new IllegalStateException("You cannot create a remote issue link with an invalid validation result.");
        }
        RemoteIssueLink remoteIssueLink = createValidationResult.getRemoteIssueLink();
        if (remoteIssueLink == null) {
            throw new IllegalArgumentException("You cannot create a null remote issue link.");
        }
        SimpleErrorCollection errors = new SimpleErrorCollection();
        RemoteIssueLink createdRemoteIssueLink = null;
        try {
            createdRemoteIssueLink = this.remoteIssueLinkManager.createRemoteIssueLink(remoteIssueLink, user);
        }
        catch (CreateException e) {
            this.handleCreateException(this.getI18n(user), errors, e);
        }
        return new RemoteIssueLinkService.RemoteIssueLinkResult(createdRemoteIssueLink, errors);
    }

    @Override
    public RemoteIssueLinkService.UpdateValidationResult validateUpdate(User user, RemoteIssueLink remoteIssueLink) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.getI18n(user);
        this.validateLinkingEnabled(i18n, errors);
        Issue issue = null;
        if (!errors.hasAnyErrors()) {
            issue = this.validateIssueExists(remoteIssueLink, errors, i18n);
        }
        if (!errors.hasAnyErrors()) {
            this.validatePermissionToUpdate(user, issue, errors, i18n);
        }
        RemoteIssueLink found = null;
        if (!errors.hasAnyErrors()) {
            found = this.validateExists(remoteIssueLink.getId(), i18n, errors);
        }
        if (!errors.hasAnyErrors()) {
            this.validateMandatoryFields(remoteIssueLink, i18n, errors);
            this.validateFieldLengths(remoteIssueLink, i18n, errors);
            this.validateUrls(remoteIssueLink, i18n, errors);
            this.validateGlobalIdForUpdate(issue, found, remoteIssueLink, errors, i18n);
        }
        return new RemoteIssueLinkService.UpdateValidationResult(errors.hasAnyErrors() ? null : remoteIssueLink, errors);
    }

    @Override
    public RemoteIssueLinkService.RemoteIssueLinkResult update(User user, RemoteIssueLinkService.UpdateValidationResult updateValidationResult) {
        if (updateValidationResult == null) {
            throw new IllegalArgumentException("You cannot update a remote issue link with a null validation result.");
        }
        if (!updateValidationResult.isValid()) {
            throw new IllegalStateException("You cannot update a remote issue link with an invalid validation result.");
        }
        RemoteIssueLink remoteIssueLink = updateValidationResult.getRemoteIssueLink();
        if (remoteIssueLink == null) {
            throw new IllegalArgumentException("You cannot update a null remote issue link.");
        }
        SimpleErrorCollection errors = new SimpleErrorCollection();
        RemoteIssueLink updatedRemoteIssueLink = null;
        try {
            this.remoteIssueLinkManager.updateRemoteIssueLink(remoteIssueLink, user);
            updatedRemoteIssueLink = remoteIssueLink;
        }
        catch (UpdateException e) {
            this.handleUpdateException(this.getI18n(user), errors, e);
        }
        return new RemoteIssueLinkService.RemoteIssueLinkResult(updatedRemoteIssueLink, errors);
    }

    @Override
    public RemoteIssueLinkService.DeleteValidationResult validateDelete(User user, Long remoteIssueLinkId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.getI18n(user);
        this.validateLinkingEnabled(i18n, errors);
        RemoteIssueLink remoteIssueLink = null;
        if (!errors.hasAnyErrors()) {
            remoteIssueLink = this.validateExists(remoteIssueLinkId, i18n, errors);
        }
        if (!errors.hasAnyErrors()) {
            this.validatePermissionToDelete(user, remoteIssueLink, errors, i18n);
        }
        return new RemoteIssueLinkService.DeleteValidationResult(errors.hasAnyErrors() ? null : remoteIssueLinkId, errors);
    }

    @Override
    public void delete(User user, RemoteIssueLinkService.DeleteValidationResult deleteValidationResult) {
        if (deleteValidationResult == null) {
            throw new IllegalArgumentException("You cannot delete a remote issue link with a null validation result.");
        }
        if (!deleteValidationResult.isValid()) {
            throw new IllegalStateException("You cannot delete a remote issue link with an invalid validation result.");
        }
        Long remoteIssueLinkId = deleteValidationResult.getRemoteIssueLinkId();
        if (remoteIssueLinkId == null) {
            throw new IllegalArgumentException("You cannot delete with a null remote issue link id.");
        }
        this.remoteIssueLinkManager.removeRemoteIssueLink(remoteIssueLinkId, user);
    }

    @Override
    public RemoteIssueLinkService.DeleteByGlobalIdValidationResult validateDeleteByGlobalId(User user, Issue issue, String globalId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.getI18n(user);
        this.validateLinkingEnabled(i18n, errors);
        RemoteIssueLink remoteIssueLink = null;
        if (!errors.hasAnyErrors()) {
            remoteIssueLink = this.validateExistsByGlobalId(issue, globalId, i18n, errors);
        }
        if (!errors.hasAnyErrors()) {
            this.validatePermissionToDelete(user, remoteIssueLink, errors, i18n);
        }
        return new RemoteIssueLinkService.DeleteByGlobalIdValidationResult(issue, globalId, errors);
    }

    @Override
    public void deleteByGlobalId(User user, RemoteIssueLinkService.DeleteByGlobalIdValidationResult validationResult) {
        if (validationResult == null) {
            throw new IllegalArgumentException("You cannot delete a remote link with a null validation result.");
        }
        if (!validationResult.isValid()) {
            throw new IllegalStateException("You cannot delete a remote link with an invalid validation result.");
        }
        Issue issue = validationResult.getIssue();
        if (issue == null) {
            throw new IllegalArgumentException("You cannot delete with a null issue.");
        }
        String globalId = validationResult.getGlobalId();
        if (globalId == null) {
            throw new IllegalArgumentException("You cannot delete with a null remote link global id.");
        }
        this.remoteIssueLinkManager.removeRemoteIssueLinkByGlobalId(issue, globalId, user);
    }

    private void validateLinkingEnabled(I18nHelper i18n, ErrorCollection errors) {
        if (!this.issueLinkManager.isLinkingEnabled()) {
            errors.addErrorMessage(i18n.getText("admin.issuelinking.status", i18n.getText("admin.common.words.disabled")), ErrorCollection.Reason.FORBIDDEN);
        }
    }

    private RemoteIssueLink validateExists(Long remoteIssueLinkId, I18nHelper i18n, ErrorCollection errors) {
        if (remoteIssueLinkId == null) {
            errors.addError("id", i18n.getText("admin.common.words.is.required", "id"), ErrorCollection.Reason.VALIDATION_FAILED);
            return null;
        }
        RemoteIssueLink remoteIssueLink = this.remoteIssueLinkManager.getRemoteIssueLink(remoteIssueLinkId);
        if (remoteIssueLink == null) {
            errors.addError("id", i18n.getText("remotelink.service.id.does.not.exist", remoteIssueLinkId.toString()), ErrorCollection.Reason.NOT_FOUND);
        }
        return remoteIssueLink;
    }

    private RemoteIssueLink validateExistsByGlobalId(Issue issue, String globalId, I18nHelper i18n, ErrorCollection errors) {
        if (issue == null) {
            errors.addError("id", i18n.getText("admin.common.words.is.required", "issue"), ErrorCollection.Reason.VALIDATION_FAILED);
            return null;
        }
        if (globalId == null) {
            errors.addError("id", i18n.getText("admin.common.words.is.required", "globalId"), ErrorCollection.Reason.VALIDATION_FAILED);
            return null;
        }
        RemoteIssueLink remoteIssueLink = this.remoteIssueLinkManager.getRemoteIssueLinkByGlobalId(issue, globalId);
        if (remoteIssueLink == null) {
            errors.addError("globalId", i18n.getText("remotelink.service.globalid.does.not.exist.in.issue", globalId, issue.getId().toString()), ErrorCollection.Reason.NOT_FOUND);
        }
        return remoteIssueLink;
    }

    private void validateMandatoryFields(RemoteIssueLink remoteIssueLink, I18nHelper i18n, ErrorCollection errors) {
        if (remoteIssueLink.getIssueId() == null) {
            errors.addError("issueId", i18n.getText("admin.common.words.is.required", "issueId"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (StringUtils.isBlank((String)remoteIssueLink.getTitle())) {
            errors.addError("title", i18n.getText("admin.common.words.is.required", i18n.getText("remotelink.service.title")), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (StringUtils.isBlank((String)remoteIssueLink.getUrl())) {
            errors.addError("url", i18n.getText("admin.common.words.is.required", i18n.getText("remotelink.service.url")), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private void validateFieldLengths(RemoteIssueLink remoteIssueLink, I18nHelper i18n, ErrorCollection errors) {
        if (this.isLongerThan(remoteIssueLink.getGlobalId(), 255)) {
            errors.addError("globalId", i18n.getText("remotelink.service.field.too.long", i18n.getText("remotelink.service.globalid"), String.valueOf(255)), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (this.isLongerThan(remoteIssueLink.getTitle(), 255)) {
            errors.addError("title", i18n.getText("remotelink.service.field.too.long", i18n.getText("remotelink.service.title"), String.valueOf(255)), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (this.isLongerThan(remoteIssueLink.getRelationship(), 255)) {
            errors.addError("relationship", i18n.getText("remotelink.service.field.too.long", i18n.getText("remotelink.service.relationship"), String.valueOf(255)), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (this.isLongerThan(remoteIssueLink.getApplicationType(), 255)) {
            errors.addError("applicationType", i18n.getText("remotelink.service.field.too.long", i18n.getText("remotelink.service.applicationtype"), String.valueOf(255)), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (this.isLongerThan(remoteIssueLink.getApplicationName(), 255)) {
            errors.addError("applicationName", i18n.getText("remotelink.service.field.too.long", i18n.getText("remotelink.service.applicationname"), String.valueOf(255)), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private boolean isLongerThan(String value, int length) {
        return value != null && value.length() > length;
    }

    private void validateUrls(RemoteIssueLink remoteIssueLink, I18nHelper i18n, ErrorCollection errors) {
        if (!this.isValidUrl(remoteIssueLink.getUrl())) {
            errors.addError("url", i18n.getText("remotelink.service.invalid.uri", i18n.getText("remotelink.service.url")), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (!this.isValidUrl(remoteIssueLink.getIconUrl())) {
            errors.addError("iconUrl", i18n.getText("remotelink.service.invalid.uri", "iconUrl"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (!this.isValidUrl(remoteIssueLink.getStatusIconUrl())) {
            errors.addError("statusIconUrl", i18n.getText("remotelink.service.invalid.uri", "statusIconUrl"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (!this.isValidUrl(remoteIssueLink.getStatusIconLink())) {
            errors.addError("statusIconLink", i18n.getText("remotelink.service.invalid.uri", "statusIconLink"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private boolean isValidUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            return true;
        }
        try {
            URI uri = new URI(url);
            if (!"http".equalsIgnoreCase(uri.getScheme()) && !"https".equalsIgnoreCase(uri.getScheme())) {
                return false;
            }
            if (uri.getHost() == null) {
                return false;
            }
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    private Issue validateIssueExists(RemoteIssueLink remoteIssueLink, ErrorCollection errors, I18nHelper i18n) {
        MutableIssue issue = this.issueManager.getIssueObject(remoteIssueLink.getIssueId());
        if (issue == null) {
            errors.addError("issueId", i18n.getText("remotelink.service.issue.does.not.exist", String.valueOf(remoteIssueLink.getIssueId())), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return issue;
    }

    private void validateGlobalId(RemoteIssueLink remoteIssueLink, Issue issue, ErrorCollection errors, I18nHelper i18n) {
        if (remoteIssueLink.getGlobalId() == null) {
            return;
        }
        RemoteIssueLink found = this.remoteIssueLinkManager.getRemoteIssueLinkByGlobalId(issue, remoteIssueLink.getGlobalId());
        if (found != null) {
            errors.addError("globalId", i18n.getText("remotelink.service.globalid.duplicate", remoteIssueLink.getTitle()), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private void validateGlobalIdForUpdate(Issue issue, RemoteIssueLink found, RemoteIssueLink remoteIssueLink, ErrorCollection errors, I18nHelper i18n) {
        if (!this.isEqual(found.getGlobalId(), remoteIssueLink.getGlobalId())) {
            this.validateGlobalId(remoteIssueLink, issue, errors, i18n);
        }
    }

    private void validatePermissionToView(User user, RemoteIssueLink remoteIssueLink, ErrorCollection errors, I18nHelper i18n) {
        IssueService.IssueResult result = this.issueService.getIssue(user, remoteIssueLink.getIssueId());
        if (result.isValid()) {
            this.validatePermissionToView(user, result.getIssue(), errors, i18n);
        }
    }

    private void validatePermissionToView(User user, Issue issue, ErrorCollection errors, I18nHelper i18n) {
        this.validatePermissionToViewIssue(user, issue, errors, i18n);
    }

    private void validatePermissionToCreate(User user, Issue issue, ErrorCollection errors, I18nHelper i18n) {
        this.hasLinkIssuePermission(user, issue, errors, i18n);
    }

    private void validatePermissionToUpdate(User user, Issue issue, ErrorCollection errors, I18nHelper i18n) {
        this.hasLinkIssuePermission(user, issue, errors, i18n);
    }

    private void validatePermissionToDelete(User user, RemoteIssueLink remoteIssueLink, ErrorCollection errors, I18nHelper i18n) {
        IssueService.IssueResult result = this.issueService.getIssue(user, remoteIssueLink.getIssueId());
        if (result.isValid()) {
            MutableIssue issue = result.getIssue();
            this.hasLinkIssuePermission(user, issue, errors, i18n);
        }
    }

    private void validatePermissionToViewIssue(User user, Issue issue, ErrorCollection errors, I18nHelper i18n) {
        if (!this.permissionManager.hasPermission(10, issue, user)) {
            errors.addErrorMessage(i18n.getText("admin.errors.issues.no.permission.to.see"), ErrorCollection.Reason.FORBIDDEN);
        }
    }

    private void hasLinkIssuePermission(User user, Issue issue, ErrorCollection errors, I18nHelper i18n) {
        if (!this.permissionManager.hasPermission(21, issue, user)) {
            errors.addErrorMessage(i18n.getText("remotelink.service.no.link.issue.permission", issue.getKey()), ErrorCollection.Reason.FORBIDDEN);
        }
    }

    private void handleCreateException(I18nHelper i18n, ErrorCollection errors, CreateException createException) {
        errors.addErrorMessage(i18n.getText("remotelink.service.error.creating", createException.getMessage()), ErrorCollection.Reason.SERVER_ERROR);
    }

    private void handleUpdateException(I18nHelper i18n, ErrorCollection errors, UpdateException updateException) {
        errors.addErrorMessage(i18n.getText("remotelink.service.error.updating", updateException.getMessage()), ErrorCollection.Reason.SERVER_ERROR);
    }

    private void handleRemoveException(I18nHelper i18n, ErrorCollection errors, RemoveException removeException) {
        errors.addErrorMessage(i18n.getText("remotelink.service.error.removing", removeException.getMessage()), ErrorCollection.Reason.SERVER_ERROR);
    }

    private I18nHelper getI18n(User user) {
        return this.beanFactory.getInstance(user);
    }

    private boolean isEqual(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }
}

