/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.link;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.link.IssueLinkService;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.link.Direction;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;

public class DefaultIssueLinkService
implements IssueLinkService {
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueLinkManager issueLinkManager;
    private final PermissionManager permissionManager;
    private final IssueManager issueManager;
    private final I18nHelper.BeanFactory beanFactory;
    private final UserHistoryManager userHistoryManager;

    public DefaultIssueLinkService(IssueLinkTypeManager issueLinkTypeManager, IssueManager issueManager, PermissionManager permissionManager, I18nHelper.BeanFactory beanFactory, IssueLinkManager issueLinkManager, UserHistoryManager userHistoryManager) {
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.beanFactory = beanFactory;
        this.issueLinkManager = issueLinkManager;
        this.userHistoryManager = userHistoryManager;
    }

    @Override
    public Collection<IssueLinkType> getIssueLinkTypes() {
        return this.issueLinkTypeManager.getIssueLinkTypes();
    }

    @Override
    public IssueLink getIssueLink(Long sourceId, Long destinationId, Long issueLinkTypeId) {
        return this.issueLinkManager.getIssueLink(sourceId, destinationId, issueLinkTypeId);
    }

    @Override
    public IssueLinkService.SingleIssueLinkResult getIssueLink(Long issueLinkId, User user) {
        Assertions.notNull("issueLinkId", issueLinkId);
        IssueLink issueLink = this.issueLinkManager.getIssueLink(issueLinkId);
        if (issueLink == null) {
            SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
            simpleErrorCollection.addErrorMessage(this.beanFactory.getInstance(user).getText("rest.issue.link.not.found", issueLinkId.toString()));
            return new IssueLinkService.SingleIssueLinkResult(simpleErrorCollection, null);
        }
        MutableIssue sourceIssue = this.issueManager.getIssueObject(issueLink.getSourceId());
        ErrorCollection sourceIssueErrors = this.validateIssuePermission(user, sourceIssue, 10);
        MutableIssue destinationIssue = this.issueManager.getIssueObject(issueLink.getDestinationId());
        ErrorCollection destinationIssueErrors = this.validateIssuePermission(user, destinationIssue, 10);
        if (sourceIssueErrors.hasAnyErrors() || destinationIssueErrors.hasAnyErrors()) {
            sourceIssueErrors.getErrors().putAll(destinationIssueErrors.getErrors());
            sourceIssueErrors.getErrorMessages().addAll(destinationIssueErrors.getErrorMessages());
            return new IssueLinkService.SingleIssueLinkResult(sourceIssueErrors, null);
        }
        return new IssueLinkService.SingleIssueLinkResult(new SimpleErrorCollection(), issueLink);
    }

    @Override
    public IssueLinkService.IssueLinkResult getIssueLinks(User user, Issue issue) {
        return this.getIssueLinks(user, issue, true);
    }

    @Override
    public IssueLinkService.IssueLinkResult getIssueLinks(User user, Issue issue, boolean excludeSystemLinks) {
        ErrorCollection errorCollection = this.validateIssuePermission(user, issue, 10);
        if (!errorCollection.hasAnyErrors()) {
            LinkCollection linkCollection = this.issueLinkManager.getLinkCollection(issue, user, excludeSystemLinks);
            return new IssueLinkService.IssueLinkResult(errorCollection, linkCollection);
        }
        return new IssueLinkService.IssueLinkResult(errorCollection, null);
    }

    @Override
    public IssueLinkService.AddIssueLinkValidationResult validateAddIssueLinks(User user, Issue issue, String linkName, Collection<String> linkKeys) {
        IssueLinkType linkType = this.matchToIssueLinkType(linkName);
        if (null == linkType) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.invalid.link.name", linkName));
            return new IssueLinkService.AddIssueLinkValidationResult(user, errors, null, null, null, null);
        }
        Direction direction = linkName.equals(linkType.getInward()) ? Direction.IN : Direction.OUT;
        return this.validateAddIssueLinks(user, issue, linkType, direction, linkKeys, true);
    }

    @Override
    public IssueLinkService.AddIssueLinkValidationResult validateAddIssueLinks(User user, Issue issue, Long issueLinkTypeId, Direction direction, Collection<String> linkKeys, boolean excludeSystemLinks) {
        IssueLinkType linkType = this.issueLinkTypeManager.getIssueLinkType(issueLinkTypeId);
        if (null == linkType) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.invalid.link.id", issueLinkTypeId));
            return new IssueLinkService.AddIssueLinkValidationResult(user, errors, null, null, null, null);
        }
        return this.validateAddIssueLinks(user, issue, linkType, direction, linkKeys, excludeSystemLinks);
    }

    private IssueLinkService.AddIssueLinkValidationResult validateAddIssueLinks(User user, Issue issue, IssueLinkType linkType, Direction direction, Collection<String> linkKeys, boolean excludeSystemLinks) {
        Assertions.notNull("issue", issue);
        Assertions.notNull("linkKeys", linkKeys);
        ErrorCollection errorCollection = this.validateIssuePermission(user, issue, 12);
        if (!errorCollection.hasAnyErrors()) {
            this.validateLinkInput(user, errorCollection, issue, linkType, linkKeys, excludeSystemLinks);
        }
        return new IssueLinkService.AddIssueLinkValidationResult(user, errorCollection, issue, linkType, direction, linkKeys);
    }

    @Override
    public void addIssueLinks(User user, IssueLinkService.AddIssueLinkValidationResult result) {
        Assertions.notNull("result", result);
        if (!result.isValid()) {
            throw new IllegalStateException("Cannot add issue links with invalid validation result!");
        }
        IssueLinkType linkType = result.getLinkType();
        if (linkType == null) {
            throw new IllegalArgumentException("Cant find issue link type '" + result.getLinkType().getName() + "'");
        }
        Issue sourceIssue = result.getIssue();
        for (String targetIssueKey : result.getLinkKeys()) {
            MutableIssue destinationIssue = this.issueManager.getIssueObject(targetIssueKey);
            if (destinationIssue == null) {
                throw new IllegalArgumentException("Issue with key '" + targetIssueKey + "' no longer exists!");
            }
            try {
                if (result.getDirection() == Direction.OUT) {
                    this.issueLinkManager.createIssueLink(sourceIssue.getId(), destinationIssue.getId(), linkType.getId(), null, result.getUser());
                } else {
                    this.issueLinkManager.createIssueLink(destinationIssue.getId(), sourceIssue.getId(), linkType.getId(), null, result.getUser());
                }
                this.userHistoryManager.addItemToHistory(UserHistoryItem.ISSUELINKTYPE, result.getUser(), String.valueOf(linkType.getId()), result.getLinkName());
            }
            catch (CreateException createE) {
                throw new RuntimeException(createE);
            }
        }
    }

    @Override
    public IssueLinkService.DeleteIssueLinkValidationResult validateDelete(User user, Issue issue, IssueLink issueLink) {
        ErrorCollection errors = this.validateIssuePermission(user, issue, 21, "admin.errors.issues.no.permission.to.delete.links");
        this.validateLinkingEnabled(user, errors);
        if (issueLink == null) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("admin.errors.issues.cannot.find.link"), ErrorCollection.Reason.NOT_FOUND);
        }
        return new IssueLinkService.DeleteIssueLinkValidationResult(errors, errors.hasAnyErrors() ? null : issueLink, user);
    }

    @Override
    public void delete(IssueLinkService.DeleteIssueLinkValidationResult validationResult) {
        Assertions.notNull("validationResult", validationResult);
        if (!validationResult.isValid()) {
            throw new IllegalStateException("You cannot delete an issue link with an invalid validation result.");
        }
        IssueLink issueLink = validationResult.getIssueLink();
        Long sourceId = issueLink.getSourceObject().getId();
        Long destinationId = issueLink.getDestinationObject().getId();
        Long issueLinkTypeId = issueLink.getIssueLinkType().getId();
        try {
            this.issueLinkManager.removeIssueLink(this.issueLinkManager.getIssueLink(sourceId, destinationId, issueLinkTypeId), validationResult.getUser());
        }
        catch (RemoveException e) {
            throw new RuntimeException("Issue link deletion failed", e);
        }
    }

    private ErrorCollection validateIssuePermission(User user, Issue issue, int permissionsId) {
        return this.validateIssuePermission(user, issue, permissionsId, "issuelinking.service.error.issue.no.permission");
    }

    private ErrorCollection validateIssuePermission(User user, Issue issue, int permissionsId, String errorMsgKey) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (issue == null) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.issue.doesnt.exist"));
            return errors;
        }
        if (!this.permissionManager.hasPermission(permissionsId, issue, user)) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText(errorMsgKey, issue.getKey()));
        }
        return errors;
    }

    private void validateLinkingEnabled(User user, ErrorCollection errors) {
        I18nHelper i18n = this.beanFactory.getInstance(user);
        if (!this.issueLinkManager.isLinkingEnabled()) {
            errors.addErrorMessage(i18n.getText("admin.issuelinking.status", i18n.getText("admin.common.words.disabled")), ErrorCollection.Reason.FORBIDDEN);
        }
    }

    private void validateLinkInput(User user, ErrorCollection errors, Issue issue, IssueLinkType linkType, Collection<String> linkKeys, boolean excludeSystemLinks) {
        if (excludeSystemLinks && linkType.isSystemLinkType()) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.invalid.link.type", linkType.getName()));
        }
        if (linkKeys == null || linkKeys.isEmpty()) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.must.provide.issue.links"));
        } else {
            for (String linkKey : linkKeys) {
                MutableIssue linkedIssue;
                if (linkKey.equalsIgnoreCase(issue.getKey())) {
                    errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.self.reference", linkKey));
                }
                if ((linkedIssue = this.issueManager.getIssueObject(linkKey)) != null) continue;
                errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.linked.issue.doesnt.exist", linkKey));
            }
        }
    }

    private IssueLinkType matchToIssueLinkType(String linkName) {
        Collection<IssueLinkType> linkTypes = this.issueLinkTypeManager.getIssueLinkTypes();
        for (IssueLinkType linkType : linkTypes) {
            if (!linkName.equals(linkType.getOutward()) && !linkName.equals(linkType.getInward())) continue;
            return linkType;
        }
        return null;
    }
}

