/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.attachment;

import com.atlassian.jira.bc.issue.attachment.VersionedAttachmentsList;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentCreationDateComparator;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class FileNameBasedVersionedAttachmentsList
implements VersionedAttachmentsList {
    private final List<Attachment> attachments;
    private final Map<String, TreeSet<Attachment>> fileNameGroupingMap = new HashMap<String, TreeSet<Attachment>>();

    public FileNameBasedVersionedAttachmentsList(List<Attachment> attachments) {
        this.attachments = attachments;
        this.groupAttachmentsByFileName();
    }

    private void groupAttachmentsByFileName() {
        for (Attachment attachment : this.attachments) {
            TreeSet<Attachment> namedAttachments = this.fileNameGroupingMap.get(attachment.getFilename());
            if (namedAttachments == null) {
                namedAttachments = new TreeSet<Attachment>(new AttachmentCreationDateComparator());
                this.fileNameGroupingMap.put(attachment.getFilename(), namedAttachments);
            }
            namedAttachments.add(attachment);
        }
    }

    @Override
    public List<Attachment> asList() {
        return Collections.unmodifiableList(this.attachments);
    }

    @Override
    public boolean isLatestVersion(Attachment attachment) {
        Assertions.notNull("attachment", attachment);
        TreeSet<Attachment> namedAttachments = this.fileNameGroupingMap.get(attachment.getFilename());
        if (namedAttachments != null) {
            return namedAttachments.size() == 1 || namedAttachments.last().equals(attachment);
        }
        return false;
    }
}

