/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.filter;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.favourites.FavouritesManager;
import com.atlassian.jira.issue.comparator.FilterNameComparator;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.ShareTypeValidatorUtils;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.user.util.UserNames;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.util.sharing.SharedEntitySearchAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

public class DefaultSearchRequestService
implements SearchRequestService {
    private final SearchRequestManager searchRequestManager;
    private final FavouritesManager<SearchRequest> favouritesManager;
    private final ShareTypeValidatorUtils shareTypeValidatorUtils;
    private final UserUtil userUtil;
    private final PermissionManager permissionManager;

    public DefaultSearchRequestService(SearchRequestManager searchRequestManager, FavouritesManager<SearchRequest> favouritesManager, ShareTypeValidatorUtils shareTypeValidatorUtils, UserUtil userUtil, PermissionManager permissionManager) {
        this.searchRequestManager = Assertions.notNull("searchRequestManager", searchRequestManager);
        this.favouritesManager = Assertions.notNull("favouritesManager", favouritesManager);
        this.shareTypeValidatorUtils = Assertions.notNull("shareTypeValidatorUtils", shareTypeValidatorUtils);
        this.userUtil = Assertions.notNull("userUtil", userUtil);
        this.permissionManager = permissionManager;
    }

    @Override
    public Collection<SearchRequest> getFavouriteFilters(User user) {
        Collection<Long> ids = this.getFavouriteIds(user);
        ArrayList<SearchRequest> results = new ArrayList<SearchRequest>(ids.size());
        for (Long id : ids) {
            SearchRequest searchRequest = this.searchRequestManager.getSearchRequestById(user, id);
            if (searchRequest == null) continue;
            results.add(searchRequest);
        }
        Collections.sort(results, FilterNameComparator.COMPARATOR);
        return results;
    }

    @Override
    public Collection<SearchRequest> getOwnedFilters(User user) {
        return DefaultSearchRequestService.sortByName(this.searchRequestManager.getAllOwnedSearchRequests(user));
    }

    @Override
    public Collection<SearchRequest> getNonPrivateFilters(User user) {
        Collection<SearchRequest> filters = this.getOwnedFilters(user);
        CollectionUtils.filter(filters, (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return !((SearchRequest)o).getPermissions().isPrivate();
            }
        });
        return filters;
    }

    @Override
    public Collection<SearchRequest> getFiltersFavouritedByOthers(User user) {
        Collection<SearchRequest> nonPrivateFilters = this.getNonPrivateFilters(user);
        if (!nonPrivateFilters.isEmpty()) {
            final Collection<Long> favouriteIds = this.favouritesManager.getFavouriteIds(user, SearchRequest.ENTITY_TYPE);
            CollectionUtils.filter(nonPrivateFilters, (Predicate)new Predicate(){

                public boolean evaluate(Object o) {
                    SearchRequest request = (SearchRequest)o;
                    return favouriteIds.contains(request.getId()) ? request.getFavouriteCount() > 1L : request.getFavouriteCount() > 0L;
                }
            });
        }
        return nonPrivateFilters;
    }

    @Override
    public void deleteFilter(JiraServiceContext serviceCtx, Long filterId) {
        Assertions.notNull("serviceCtx", serviceCtx);
        Assertions.notNull("filterId", filterId);
        User user = serviceCtx.getLoggedInUser();
        this.validateForDelete(serviceCtx, filterId);
        if (!serviceCtx.getErrorCollection().hasAnyErrors()) {
            SearchRequest filter = this.searchRequestManager.getSearchRequestById(user, filterId);
            if (filter != null) {
                this.deleteFilter(filter);
            } else {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.filters.cannot.delete.filter"));
            }
        }
    }

    @Override
    public void deleteAllFiltersForUser(JiraServiceContext serviceCtx, User user) {
        Assertions.notNull("user", user);
        Collection<SearchRequest> ownedRequests = this.searchRequestManager.getAllOwnedSearchRequests(user);
        for (SearchRequest searchRequest : ownedRequests) {
            this.deleteFilter(searchRequest);
        }
        this.favouritesManager.removeFavouritesForUser(user, SearchRequest.ENTITY_TYPE);
    }

    @Override
    public SearchRequest getFilter(JiraServiceContext serviceCtx, Long filterId) {
        Assertions.notNull("serviceCtx", serviceCtx);
        Assertions.notNull("filterId", filterId);
        SearchRequest filter = this.searchRequestManager.getSearchRequestById(serviceCtx.getLoggedInUser(), filterId);
        if (filter == null) {
            serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.filters.nonexistent"));
        }
        return filter;
    }

    @Override
    public void validateFilterForUpdate(JiraServiceContext serviceCtx, SearchRequest request) {
        SearchRequest filterByName;
        Assertions.notNull("serviceCtx", serviceCtx);
        Assertions.notNull("request", request);
        this.validateUpdateSearchParameters(serviceCtx, request);
        if (this.validateFilterName(serviceCtx, request) && serviceCtx.getLoggedInUser() != null && (filterByName = this.searchRequestManager.getOwnedSearchRequestByName(serviceCtx.getLoggedInUser(), request.getName())) != null && (request.getId() == null || !request.getId().equals(filterByName.getId()))) {
            serviceCtx.getErrorCollection().addError("filterName", serviceCtx.getI18nBean().getText("admin.errors.filters.same.name"));
        }
        this.shareTypeValidatorUtils.isValidSharePermission(serviceCtx, request);
    }

    @Override
    public boolean validateUpdateSearchParameters(JiraServiceContext serviceCtx, SearchRequest request) {
        Assertions.notNull("serviceCtx", serviceCtx);
        Assertions.notNull("request", request);
        if (request.getId() == null) {
            serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.filters.not.saved"));
        }
        if (serviceCtx.getLoggedInUser() == null) {
            serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.filters.owned.anonymous.user"));
        } else {
            String currentOwnerUsername = this.searchRequestManager.getSearchRequestOwnerUserName(request.getId());
            if (currentOwnerUsername == null) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.filters.not.saved"));
            } else if (!UserNames.equal(currentOwnerUsername, serviceCtx.getLoggedInUser()) || request.getOwnerUserName() == null || !UserNames.equal(request.getOwnerUserName(), serviceCtx.getLoggedInUser())) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.filters.must.be.owner"));
            }
        }
        return !serviceCtx.getErrorCollection().hasAnyErrors();
    }

    @Override
    public void validateFilterForCreate(JiraServiceContext serviceCtx, SearchRequest request) {
        SearchRequest filterByName;
        Assertions.notNull("serviceCtx", serviceCtx);
        Assertions.notNull("request", request);
        if (serviceCtx.getLoggedInUser() == null) {
            serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.filters.owned.anonymous.user"));
        } else if (request.getOwnerUserName() == null || !UserNames.equal(request.getOwnerUserName(), serviceCtx.getLoggedInUser())) {
            serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.filters.must.be.owner"));
        }
        if (this.validateFilterName(serviceCtx, request) && serviceCtx.getLoggedInUser() != null && (filterByName = this.searchRequestManager.getOwnedSearchRequestByName(serviceCtx.getLoggedInUser(), request.getName())) != null) {
            serviceCtx.getErrorCollection().addError("filterName", serviceCtx.getI18nBean().getText("admin.errors.filters.same.name"));
        }
        this.shareTypeValidatorUtils.isValidSharePermission(serviceCtx, request);
    }

    private boolean validateFilterName(JiraServiceContext serviceCtx, SearchRequest request) {
        boolean valid = true;
        String filterName = request.getName();
        if (StringUtils.isBlank((String)filterName)) {
            serviceCtx.getErrorCollection().addError("filterName", serviceCtx.getI18nBean().getText("admin.errors.filters.must.specify.name"));
            valid = false;
        } else if (filterName.length() > 255) {
            serviceCtx.getErrorCollection().addError("filterName", serviceCtx.getI18nBean().getText("admin.errors.filters.name.toolong"));
            valid = false;
        }
        return valid;
    }

    @Override
    public void validateForDelete(JiraServiceContext serviceCtx, Long filterId) {
        Assertions.notNull("serviceCtx", serviceCtx);
        Assertions.notNull("filterId", filterId);
        if (serviceCtx.getLoggedInUser() == null) {
            serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.filters.owned.anonymous.user"));
        } else {
            String ownerUsername = this.searchRequestManager.getSearchRequestOwnerUserName(filterId);
            if (ownerUsername == null) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.filters.not.saved"));
            } else if (!UserNames.equal(ownerUsername, serviceCtx.getLoggedInUser()) && !this.permissionManager.hasPermission(0, serviceCtx.getLoggedInUser())) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.filters.must.be.owner"));
            }
        }
    }

    @Override
    public SearchRequest createFilter(JiraServiceContext serviceCtx, SearchRequest request) {
        Assertions.notNull("serviceCtx", serviceCtx);
        Assertions.notNull("request", request);
        if (this.checkPermissionsForCreate(serviceCtx, request)) {
            return this.searchRequestManager.create(request);
        }
        return null;
    }

    @Override
    public SearchRequest createFilter(JiraServiceContext serviceCtx, SearchRequest request, boolean isFavourite) {
        Assertions.notNull("serviceCtx", serviceCtx);
        Assertions.notNull("request", request);
        SearchRequest filter = this.createFilter(serviceCtx, request);
        if (!serviceCtx.getErrorCollection().hasAnyErrors()) {
            if (isFavourite) {
                try {
                    this.favouritesManager.addFavourite(serviceCtx.getLoggedInUser(), filter);
                }
                catch (PermissionException e) {
                    serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("common.favourites.not.added"));
                }
            } else {
                this.favouritesManager.removeFavourite(serviceCtx.getLoggedInUser(), filter);
            }
        }
        return filter;
    }

    @Override
    public SearchRequest updateFilter(JiraServiceContext serviceCtx, SearchRequest request) {
        Assertions.notNull("serviceCtx", serviceCtx);
        Assertions.notNull("request", request);
        if (this.checkPermissionsForUpdate(serviceCtx, request)) {
            return this.searchRequestManager.update(request);
        }
        return null;
    }

    @Override
    public SearchRequest updateFilter(JiraServiceContext serviceCtx, SearchRequest request, boolean isFavourite) {
        Assertions.notNull("serviceCtx", serviceCtx);
        Assertions.notNull("request", request);
        SearchRequest filter = this.updateFilter(serviceCtx, request);
        if (!serviceCtx.getErrorCollection().hasAnyErrors()) {
            if (isFavourite) {
                try {
                    this.favouritesManager.addFavourite(serviceCtx.getLoggedInUser(), filter);
                }
                catch (PermissionException e) {
                    serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("common.favourites.not.added"));
                }
            } else {
                this.favouritesManager.removeFavourite(serviceCtx.getLoggedInUser(), filter);
            }
        }
        return filter;
    }

    @Override
    public void validateFilterForChangeOwner(JiraServiceContext serviceCtx, SearchRequest request) {
        Assertions.notNull("serviceCtx", serviceCtx);
        Assertions.notNull("request", request);
        if (this.validateFilterName(serviceCtx, request)) {
            SearchRequest filterByName;
            if (serviceCtx.getLoggedInUser() != null && (filterByName = this.searchRequestManager.getOwnedSearchRequestByName(serviceCtx.getLoggedInUser(), request.getName())) != null) {
                serviceCtx.getErrorCollection().addError("filterName", serviceCtx.getI18nBean().getText("admin.errors.filters.already.owns.same.name", serviceCtx.getLoggedInUser().getDisplayName()));
            }
            if (request.getPermissions().isPrivate()) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.filters.private"));
            }
        }
    }

    @Override
    public SearchRequest updateFilterOwner(JiraServiceContext serviceCtx, User user, SearchRequest request) {
        Assertions.notNull("serviceCtx", serviceCtx);
        Assertions.notNull("request", request);
        if (this.checkPermissionsForOwnerUpdate(serviceCtx, user, request)) {
            return this.searchRequestManager.update(request);
        }
        return null;
    }

    @Override
    public SearchRequest updateSearchParameters(JiraServiceContext serviceCtx, SearchRequest request) {
        Assertions.notNull("serviceCtx", serviceCtx);
        Assertions.notNull("request", request);
        if (this.checkPermissionsForUpdateSearchParameters(serviceCtx, request)) {
            SearchRequest databaseRequest = this.searchRequestManager.getSearchRequestById(serviceCtx.getLoggedInUser(), request.getId());
            if (databaseRequest != null) {
                SearchRequest newRequest = new SearchRequest(request.getQuery(), databaseRequest.getOwnerUserName(), databaseRequest.getName(), databaseRequest.getDescription(), databaseRequest.getId(), databaseRequest.getFavouriteCount());
                newRequest.setPermissions(request.getPermissions());
                return this.searchRequestManager.update(newRequest);
            }
            serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.filters.not.saved"));
        }
        return null;
    }

    @Override
    public void validateForSearch(JiraServiceContext serviceCtx, SharedEntitySearchParameters searchParameters) {
        ShareTypeSearchParameter shareTypeSearchParameter;
        Assertions.notNull("serviceCtx", serviceCtx);
        Assertions.notNull("searchParameters", searchParameters);
        ErrorCollection errorCollection = serviceCtx.getErrorCollection();
        I18nHelper nBean = serviceCtx.getI18nBean();
        String searchOwnerUserName = searchParameters.getUserName();
        if (!StringUtils.isBlank((String)searchOwnerUserName) && !this.userUtil.userExists(searchOwnerUserName)) {
            errorCollection.addError("searchOwnerUserName", nBean.getText("admin.errors.filters.userdoesnotexist", searchOwnerUserName));
        }
        if ((shareTypeSearchParameter = searchParameters.getShareTypeParameter()) != null) {
            this.shareTypeValidatorUtils.isValidSearchParameter(serviceCtx, shareTypeSearchParameter);
        }
        SharedEntitySearchAction.QueryValidator.validate(searchParameters, errorCollection, serviceCtx.getI18nBean());
    }

    @Override
    public SharedEntitySearchResult<SearchRequest> search(JiraServiceContext serviceCtx, SharedEntitySearchParameters searchParameters, int pagePosition, int pageWidth) {
        Assertions.notNull("serviceCtx", serviceCtx);
        Assertions.notNull("searchParameters", searchParameters);
        if (pagePosition < 0) {
            throw new IllegalArgumentException("pagePosition < 0");
        }
        if (pageWidth <= 0) {
            throw new IllegalArgumentException("pageWidth <= 0");
        }
        return this.searchRequestManager.search(searchParameters, serviceCtx.getLoggedInUser(), pagePosition, pageWidth);
    }

    private static Collection<SearchRequest> sortByName(Collection<SearchRequest> filters) {
        if (filters.isEmpty()) {
            return filters;
        }
        ArrayList<SearchRequest> filtersList = new ArrayList<SearchRequest>(filters);
        Collections.sort(filtersList, FilterNameComparator.COMPARATOR);
        return filtersList;
    }

    private Collection<Long> getFavouriteIds(User user) {
        return user == null ? Collections.emptyList() : this.favouritesManager.getFavouriteIds(user, SearchRequest.ENTITY_TYPE);
    }

    private void deleteFilter(SearchRequest filter) {
        Assertions.notNull("filter", filter);
        this.favouritesManager.removeFavouritesForEntityDelete(filter);
        this.searchRequestManager.delete(filter.getId());
    }

    private boolean checkPermissionsForUpdate(JiraServiceContext ctx, SearchRequest request) {
        this.checkPermissionsForUpdateSearchParameters(ctx, request);
        this.shareTypeValidatorUtils.isValidSharePermission(ctx, request);
        return !ctx.getErrorCollection().hasAnyErrors();
    }

    private boolean checkPermissionsForOwnerUpdate(JiraServiceContext ctx, User user, SearchRequest request) {
        this.checkPermissionsForOwnerUpdateSearchParameters(ctx, user, request);
        this.shareTypeValidatorUtils.isValidSharePermission(ctx, request);
        return !ctx.getErrorCollection().hasAnyErrors();
    }

    private boolean checkPermissionsForUpdateSearchParameters(JiraServiceContext ctx, SearchRequest request) {
        if (request.getId() == null) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("admin.errors.filters.not.saved"));
        } else if (ctx.getLoggedInUser() == null) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("admin.errors.filters.owned.anonymous.user"));
        } else if (request.getOwnerUserName() == null || !UserNames.equal(request.getOwnerUserName(), ctx.getLoggedInUser())) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("admin.errors.filters.must.be.owner"));
        } else {
            String currentOwnerUsername = this.searchRequestManager.getSearchRequestOwnerUserName(request.getId());
            if (currentOwnerUsername == null) {
                ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("admin.errors.filters.not.saved"));
            } else if (!UserNames.equal(currentOwnerUsername, ctx.getLoggedInUser())) {
                ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("admin.errors.filters.must.be.owner"));
            }
        }
        return !ctx.getErrorCollection().hasAnyErrors();
    }

    private boolean checkPermissionsForOwnerUpdateSearchParameters(JiraServiceContext ctx, User user, SearchRequest request) {
        if (request.getId() == null) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("admin.errors.filters.not.saved"));
        } else if (ctx.getLoggedInUser() == null) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("admin.errors.filters.owned.anonymous.user"));
        } else if (request.getOwnerUserName() == null || !this.permissionManager.hasPermission(0, user)) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("admin.errors.filters.must.be.admin"));
        }
        return !ctx.getErrorCollection().hasAnyErrors();
    }

    private boolean checkPermissionsForCreate(JiraServiceContext ctx, SearchRequest request) {
        if (ctx.getLoggedInUser() == null) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("admin.errors.filters.owned.anonymous.user"));
        } else if (request.getOwnerUserName() == null || !UserNames.equal(request.getOwnerUserName(), ctx.getLoggedInUser())) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("admin.errors.filters.must.be.owner"));
        }
        this.shareTypeValidatorUtils.isValidSharePermission(ctx, request);
        return !ctx.getErrorCollection().hasAnyErrors();
    }
}

