/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.favourites;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.favourites.FavouritesManager;
import com.atlassian.jira.sharing.SharedEntity;

public class DefaultFavouritesService
implements FavouritesService {
    private final FavouritesManager favouritesManager;

    public DefaultFavouritesService(FavouritesManager favouritesManager) {
        this.favouritesManager = favouritesManager;
    }

    @Override
    public void addFavourite(JiraServiceContext ctx, SharedEntity entity) {
        try {
            this.favouritesManager.addFavourite(ctx.getLoggedInUser(), entity);
        }
        catch (PermissionException e) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("common.favourites.no.permission"));
        }
    }

    @Override
    public void addFavouriteInPosition(JiraServiceContext ctx, SharedEntity entity, long position) {
        try {
            this.favouritesManager.addFavouriteInPosition(ctx.getLoggedInUser(), entity, position);
        }
        catch (PermissionException e) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("common.favourites.not.added"));
        }
    }

    @Override
    public void removeFavourite(JiraServiceContext ctx, SharedEntity entity) {
        this.favouritesManager.removeFavourite(ctx.getLoggedInUser(), entity);
    }

    @Override
    public boolean isFavourite(User user, SharedEntity entity) {
        try {
            return this.favouritesManager.isFavourite(user, entity);
        }
        catch (PermissionException e) {
            throw new RuntimeException(e);
        }
    }
}

