/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.dataimport.DataImportParams;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;

public interface DataImportService {
    public ImportValidationResult validateImport(User var1, DataImportParams var2);

    public ImportResult doImport(User var1, ImportValidationResult var2, TaskProgressSink var3);

    public static class ImportResult
    extends ServiceResultImpl {
        private final ImportError error;
        private String specificErrorMessage;
        private DataImportParams params;

        private ImportResult(DataImportParams params, ErrorCollection errorCollection, ImportError error, String specificErrorMessage) {
            super(errorCollection);
            this.params = params;
            this.error = error;
            this.specificErrorMessage = specificErrorMessage;
        }

        public ImportError getImportError() {
            return this.error;
        }

        public String getSpecificErrorMessage() {
            return this.specificErrorMessage;
        }

        @Override
        public boolean isValid() {
            return super.isValid() && this.error.equals((Object)ImportError.NONE);
        }

        public DataImportParams getParams() {
            return this.params;
        }

        public static class Builder {
            private final ErrorCollection errors = new SimpleErrorCollection();
            private ImportError error = ImportError.NONE;
            private String specificErrorMessage;
            private final DataImportParams params;

            public Builder(DataImportParams params) {
                this.params = params;
            }

            public ErrorCollection getErrorCollection() {
                return this.errors;
            }

            public void setSpecificError(ImportError error, String specificErrorMessage) {
                this.error = error;
                this.specificErrorMessage = specificErrorMessage;
            }

            public ImportResult build() {
                return new ImportResult(this.params, this.errors, this.error, this.specificErrorMessage);
            }

            public boolean isValid() {
                return !this.errors.hasAnyErrors() && this.error.equals((Object)ImportError.NONE);
            }
        }
    }

    public static class ImportValidationResult
    extends ServiceResultImpl {
        private final DataImportParams params;

        public ImportValidationResult(ErrorCollection errorCollection, DataImportParams params) {
            super(errorCollection);
            this.params = params;
        }

        public DataImportParams getParams() {
            return this.params;
        }
    }

    public static enum ImportError {
        NONE,
        UPGRADE_EXCEPTION,
        V1_LICENSE_EXCEPTION,
        CUSTOM_PATH_EXCEPTION;

    }
}

