/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.admin;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.admin.ApplicationPropertiesService;
import com.atlassian.jira.bc.admin.ApplicationProperty;
import com.atlassian.jira.bc.admin.ApplicationPropertyMetadata;
import com.atlassian.jira.config.properties.ApplicationPropertiesStore;
import com.atlassian.jira.event.config.ApplicationPropertyChangeEvent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.validation.Validated;
import com.atlassian.validation.Validator;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class ApplicationPropertiesServiceImpl
implements ApplicationPropertiesService {
    private static final Logger log = Logger.getLogger(ApplicationPropertiesServiceImpl.class);
    private final ApplicationPropertiesStore applicationPropertiesStore;
    private EventPublisher eventPublisher;

    public ApplicationPropertiesServiceImpl(ApplicationPropertiesStore applicationPropertiesStore, EventPublisher eventPublisher) {
        this.applicationPropertiesStore = applicationPropertiesStore;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public List<ApplicationProperty> getEditableApplicationProperties() {
        return this.applicationPropertiesStore.getEditableApplicationProperties();
    }

    @Override
    public ApplicationProperty getApplicationProperty(String key) {
        return this.applicationPropertiesStore.getApplicationPropertyFromKey(key);
    }

    @Override
    public Validated<ApplicationProperty> setApplicationProperty(String key, String value) {
        ApplicationProperty applicationProperty = this.applicationPropertiesStore.getApplicationPropertyFromKey(key);
        String oldValue = applicationProperty.getCurrentValue();
        log.debug((Object)("validating value: " + value));
        ApplicationPropertyMetadata metadata = applicationProperty.getMetadata();
        Validator.Result result = metadata.validate(value);
        if (result.isValid()) {
            applicationProperty = this.applicationPropertiesStore.setApplicationProperty(key, value);
            this.eventPublisher.publish((Object)this.createEvent(metadata, oldValue, value));
        }
        return new Validated<ApplicationProperty>(result, applicationProperty);
    }

    private ApplicationPropertyChangeEvent createEvent(ApplicationPropertyMetadata metadata, String oldValue, String newValue) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("metadata", Assertions.notNull("metadata", metadata));
        params.put("oldValue", oldValue);
        params.put("newValue", newValue);
        return new ApplicationPropertyChangeEvent(params);
    }
}

