/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImpl;
import com.atlassian.jira.avatar.AvatarStore;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfbizAvatarStore
implements AvatarStore {
    static final String AVATAR_ENTITY = "Avatar";
    static final String ID = "id";
    static final String FILE_NAME = "fileName";
    static final String CONTENT_TYPE = "contentType";
    static final String AVATAR_TYPE = "avatarType";
    static final String OWNER = "owner";
    static final String SYSTEM_AVATAR = "systemAvatar";
    static final Integer IS_SYSTEM = 1;
    static final Integer NOT_SYSTEM = 0;
    private OfBizDelegator ofBizDelegator;

    public OfbizAvatarStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public Avatar getById(Long avatarId) {
        Assertions.notNull("avatarId", avatarId);
        GenericValue gv = this.ofBizDelegator.findByPrimaryKey(AVATAR_ENTITY, EasyMap.build((Object)ID, (Object)avatarId));
        return gv == null ? null : this.gvToAvatar(gv);
    }

    @Override
    public boolean delete(Long avatarId) {
        Assertions.notNull("avatarId", avatarId);
        int numRemoved = this.ofBizDelegator.removeByAnd(AVATAR_ENTITY, EasyMap.build((Object)ID, (Object)avatarId));
        return numRemoved != 0;
    }

    @Override
    public void update(Avatar avatar) {
        Assertions.notNull("avatar", avatar);
        Long avatarId = Assertions.notNull("avatar.id", avatar.getId());
        Assertions.notNull("avatar.fileName", avatar.getFileName());
        Assertions.notNull("avatar.contentType", avatar.getContentType());
        Assertions.notNull("avatar.avatarType", avatar.getAvatarType());
        Assertions.notNull("avatar.owner", avatar.getOwner());
        GenericValue gv = this.ofBizDelegator.findByPrimaryKey(AVATAR_ENTITY, EasyMap.build((Object)ID, (Object)avatarId));
        gv.setNonPKFields(this.getNonPkFields(avatar));
        try {
            gv.store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public Avatar create(Avatar avatar) {
        Assertions.notNull("avatar", avatar);
        Assertions.stateTrue("avatar.id must be null", avatar.getId() == null);
        Assertions.notNull("avatar.fileName", avatar.getFileName());
        Assertions.notNull("avatar.contentType", avatar.getContentType());
        Assertions.notNull("avatar.avatarType", avatar.getAvatarType());
        return this.gvToAvatar(this.ofBizDelegator.createValue(AVATAR_ENTITY, this.getNonPkFields(avatar)));
    }

    @Override
    public List<Avatar> getAllSystemAvatars(Avatar.Type type) {
        return this.getAvatars(EasyMap.build((Object)SYSTEM_AVATAR, (Object)IS_SYSTEM, (Object)AVATAR_TYPE, (Object)type.getName()));
    }

    @Override
    public List<Avatar> getCustomAvatarsForOwner(Avatar.Type type, String ownerId) {
        Assertions.notNull("type", type);
        Assertions.notNull("ownerId", ownerId);
        return this.getAvatars(EasyMap.build((Object)SYSTEM_AVATAR, (Object)NOT_SYSTEM, (Object)AVATAR_TYPE, (Object)type.getName(), (Object)OWNER, (Object)ownerId));
    }

    List<Avatar> getAvatars(Map constraint) {
        ArrayList<Avatar> systemAvatars = new ArrayList<Avatar>();
        for (GenericValue gv : this.ofBizDelegator.findByAnd(AVATAR_ENTITY, constraint)) {
            systemAvatars.add(this.gvToAvatar(gv));
        }
        return systemAvatars;
    }

    private Map getNonPkFields(Avatar avatar) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put(FILE_NAME, avatar.getFileName());
        fields.put(CONTENT_TYPE, avatar.getContentType());
        fields.put(AVATAR_TYPE, avatar.getAvatarType().getName());
        fields.put(OWNER, avatar.getOwner());
        fields.put(SYSTEM_AVATAR, avatar.isSystemAvatar() ? IS_SYSTEM : NOT_SYSTEM);
        return fields;
    }

    Avatar gvToAvatar(GenericValue gv) {
        return new AvatarImpl(gv.getLong(ID), gv.getString(FILE_NAME), gv.getString(CONTENT_TYPE), Avatar.Type.getByName(gv.getString(AVATAR_TYPE)), gv.getString(OWNER), gv.getInteger(SYSTEM_AVATAR) != 0);
    }
}

