/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarStore;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CachingAvatarStore
implements AvatarStore,
Startable {
    private final Map<Long, Avatar> cache = new ConcurrentHashMap<Long, Avatar>();
    private final AvatarStore delegate;
    private final EventPublisher eventPublisher;

    public CachingAvatarStore(AvatarStore delegate, EventPublisher eventPublisher) {
        this.delegate = delegate;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.clear();
    }

    @Override
    public Avatar getById(Long avatarId) throws DataAccessException {
        Assertions.notNull("avatarId", avatarId);
        Avatar avatar = this.cache.get(avatarId);
        if (avatar == null && (avatar = this.delegate.getById(avatarId)) != null) {
            this.cache.put(avatarId, avatar);
        }
        return avatar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(Long avatarId) throws DataAccessException {
        Assertions.notNull("avatarId", avatarId);
        try {
            boolean bl = this.delegate.delete(avatarId);
            return bl;
        }
        finally {
            this.cache.remove(avatarId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Avatar avatar) throws DataAccessException {
        Assertions.notNull("avatar", avatar);
        try {
            this.delegate.update(avatar);
        }
        finally {
            if (avatar.getId() != null) {
                this.cache.remove(avatar.getId());
            }
        }
    }

    @Override
    public Avatar create(Avatar avatar) throws DataAccessException {
        Assertions.notNull("avatar", avatar);
        Avatar createdAvatar = this.delegate.create(avatar);
        this.cache.put(createdAvatar.getId(), createdAvatar);
        return createdAvatar;
    }

    @Override
    public List<Avatar> getAllSystemAvatars(Avatar.Type type) throws DataAccessException {
        return this.delegate.getAllSystemAvatars(type);
    }

    @Override
    public List<Avatar> getCustomAvatarsForOwner(Avatar.Type type, String ownerId) throws DataAccessException {
        return this.delegate.getCustomAvatarsForOwner(type, ownerId);
    }
}

