/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.appconsistency.integrity.check.CheckImpl;
import com.atlassian.jira.appconsistency.integrity.check.DeleteTriggerAmendmentImpl;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.scheduler.cron.SimpleToCronTriggerConverter;
import com.atlassian.jira.util.SimpleToCronUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class SimpleTriggerCheck
extends CheckImpl {
    private static final Logger log = Logger.getLogger(SimpleTriggerCheck.class);
    private static final String SEND_SUBSCRIPTION = "SEND_SUBSCRIPTION";

    public SimpleTriggerCheck(OfBizDelegator ofBizDelegator, int id) {
        super(ofBizDelegator, id);
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.integrity.check.filter.subscriptions.simple.trigger.desc");
    }

    @Override
    public List preview() throws IntegrityException {
        return this.doCheck(false);
    }

    @Override
    public List correct() throws IntegrityException {
        return this.doCheck(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List doCheck(boolean correct) {
        Scheduler scheduler = ManagerFactory.getScheduler();
        ArrayList<DeleteTriggerAmendmentImpl> result = new ArrayList<DeleteTriggerAmendmentImpl>();
        SimpleToCronUtil simpleToCronUtil = new SimpleToCronUtil(scheduler, new SimpleToCronTriggerConverter());
        boolean restartScheduler = false;
        try {
            String[] triggerNames = scheduler.getTriggerNames(SEND_SUBSCRIPTION);
            if (triggerNames != null) {
                if (correct) {
                    restartScheduler = simpleToCronUtil.pauseScheduler();
                }
                for (int i = 0; i < triggerNames.length; ++i) {
                    String triggerName = triggerNames[i];
                    Trigger trigger = scheduler.getTrigger(triggerName, SEND_SUBSCRIPTION);
                    if (!(trigger instanceof SimpleTrigger)) continue;
                    String subscriptionId = triggerName.substring("SUBSCRIPTION_".length());
                    GenericValue subscriptionGV = this.ofBizDelegator.findByPrimaryKey("FilterSubscription", EasyMap.build((Object)"id", (Object)new Long(subscriptionId)));
                    SimpleTrigger simpleTrigger = (SimpleTrigger)trigger;
                    if (subscriptionGV == null) {
                        if (correct) {
                            simpleToCronUtil.unscheduleJob((Trigger)simpleTrigger);
                            result.add(new DeleteTriggerAmendmentImpl(0, this.getI18NBean().getText("admin.integrity.check.filter.subscriptions.simple.trigger.message", triggerName), simpleTrigger));
                            continue;
                        }
                        result.add(new DeleteTriggerAmendmentImpl(2, this.getI18NBean().getText("admin.integrity.check.filter.subscriptions.simple.trigger.preview", triggerName), simpleTrigger));
                        continue;
                    }
                    if (correct) {
                        simpleToCronUtil.convertSimpleToCronTrigger(simpleTrigger);
                        result.add(new DeleteTriggerAmendmentImpl(0, this.getI18NBean().getText("admin.integrity.check.filter.subscriptions.simple.trigger.with.subscription.message", triggerName), simpleTrigger));
                        continue;
                    }
                    result.add(new DeleteTriggerAmendmentImpl(2, this.getI18NBean().getText("admin.integrity.check.filter.subscriptions.simple.trigger.with.subscription.preview", triggerName), simpleTrigger));
                }
            }
        }
        catch (SchedulerException e) {
            log.error((Object)"Error retrieving all triggers!", (Throwable)e);
        }
        finally {
            simpleToCronUtil.restartScheduler(restartScheduler);
        }
        return result;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getUnavailableMessage() {
        return "";
    }
}

