/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.appconsistency.integrity.amendment.DeleteEntityAmendment;
import com.atlassian.jira.appconsistency.integrity.check.BaseFilterSubscriptionsCheck;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public class FilterSubscriptionsTriggerCheck
extends BaseFilterSubscriptionsCheck {
    public FilterSubscriptionsTriggerCheck(OfBizDelegator ofBizDelegator, int id) {
        super(ofBizDelegator, id);
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.integrity.check.filter.subscriptions.trigger.desc");
    }

    @Override
    protected void doRealCheck(boolean correct, GenericValue subscription, List messages) throws IntegrityException {
        GenericValue trigger = this.getTriggerGV(subscription);
        if (trigger == null) {
            if (correct) {
                messages.add(new DeleteEntityAmendment(0, this.getI18NBean().getText("admin.integrity.check.filter.subscriptions.trigger.message", subscription.getString("id")), subscription));
            } else {
                messages.add(new DeleteEntityAmendment(2, this.getI18NBean().getText("admin.integrity.check.filter.subscriptions.trigger.preview", subscription.getString("id")), subscription));
            }
        }
    }

    private GenericValue getTriggerGV(GenericValue subscription) {
        List<GenericValue> vals = this.ofBizDelegator.findByAnd("QRTZTriggers", EasyMap.build((Object)"triggerName", (Object)("SUBSCRIPTION_" + subscription.getString("id"))));
        if (vals != null && vals.size() == 1) {
            return vals.get(0);
        }
        return null;
    }
}

