/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.action.issue;

import com.atlassian.jira.action.issue.AbstractIssueAction;
import com.atlassian.jira.action.issue.IssueDeleteInterface;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.util.SimpleErrorCollection;
import webwork.action.ActionContext;

public class IssueDelete
extends AbstractIssueAction
implements IssueDeleteInterface {
    private final IssueManager issueManager;
    private final IssueFactory issueFactory;
    private final IssueService issueService;
    private boolean permissionOverride = false;

    public IssueDelete(IssueService issueService, IssueManager issueManager, IssueFactory issueFactory) {
        this.issueService = issueService;
        this.issueManager = issueManager;
        this.issueFactory = issueFactory;
    }

    protected String doExecute() throws RemoveException, PermissionException {
        boolean sendMail = this.isSendMail();
        EventDispatchOption currEventTypeOption = this.isDispatchEvent() ? EventDispatchOption.ISSUE_DELETED : EventDispatchOption.DO_NOT_DISPATCH;
        MutableIssue issue = this.issueFactory.getIssue(this.getIssue());
        if (this.permissionOverride) {
            this.issueManager.deleteIssue(this.getLoggedInUser(), issue, currEventTypeOption, sendMail);
        } else {
            SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
            this.issueService.delete(this.getLoggedInUser(), new IssueService.DeleteValidationResult(issue, simpleErrorCollection), currEventTypeOption, sendMail);
            if (simpleErrorCollection.hasAnyErrors()) {
                if (simpleErrorCollection.getErrors() != null) {
                    this.addErrors(simpleErrorCollection.getErrors());
                }
                if (simpleErrorCollection.getErrorMessages() != null) {
                    this.addErrorMessages(simpleErrorCollection.getErrorMessages());
                }
            }
        }
        return this.getResult();
    }

    private boolean isSendMail() {
        Boolean sendEmailParam = (Boolean)ActionContext.getParameters().get("sendMail");
        return sendEmailParam == null || sendEmailParam != false;
    }

    public void setPermissionOverride(boolean permissionOverride) {
        this.permissionOverride = permissionOverride;
    }
}

