/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.action.component;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.action.component.SelectComponentAssigneesUtil;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentService;
import com.atlassian.jira.project.ComponentAssigneeTypes;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class SelectComponentAssigneesUtilImpl
implements SelectComponentAssigneesUtil {
    private Map componentAssigneeTypes;
    private String fieldPrefix;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectComponentService projectComponentService;
    private PermissionManager permissionManager;

    public SelectComponentAssigneesUtilImpl(JiraAuthenticationContext authenticationContext, ProjectComponentService projectComponentService, PermissionManager permissionManager) {
        this.authenticationContext = authenticationContext;
        this.projectComponentService = projectComponentService;
        this.permissionManager = permissionManager;
    }

    @Override
    public ErrorCollection validate() {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Set components = this.componentAssigneeTypes.keySet();
        for (Object component1 : components) {
            Long assigneeType;
            GenericValue component = (GenericValue)component1;
            if (this.isAssigneeTypeValid(component, assigneeType = (Long)this.componentAssigneeTypes.get(component))) continue;
            errorCollection.addError(this.fieldPrefix + component.getLong("id"), this.authenticationContext.getI18nHelper().getText("admin.errors.invalid.default.assignee"));
        }
        return errorCollection;
    }

    @Override
    public boolean hasPermission(Project project, User user) {
        return this.permissionManager.hasPermission(0, user) || this.permissionManager.hasPermission(23, project, user);
    }

    @Override
    public ErrorCollection execute(User user) throws GenericEntityException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Set componentEntries = this.componentAssigneeTypes.entrySet();
        for (Map.Entry entry : componentEntries) {
            Long assigneeType = (Long)entry.getValue();
            Long componentId = ((GenericValue)entry.getKey()).getLong("id");
            MutableProjectComponent projectComponent = MutableProjectComponent.copy(this.projectComponentService.find(user, errorCollection, componentId));
            projectComponent.setAssigneeType(assigneeType);
            this.projectComponentService.update(user, errorCollection, projectComponent);
        }
        return errorCollection;
    }

    private boolean isAssigneeTypeValid(GenericValue component, Long assigneeType) {
        return ComponentAssigneeTypes.isAssigneeTypeValid(component, assigneeType);
    }

    @Override
    public Map getComponentAssigneeTypes() {
        return this.componentAssigneeTypes;
    }

    @Override
    public void setComponentAssigneeTypes(Map componentAssigneeTypes) {
        this.componentAssigneeTypes = componentAssigneeTypes;
    }

    @Override
    public String getFieldPrefix() {
        return this.fieldPrefix;
    }

    @Override
    public void setFieldPrefix(String fieldPrefix) {
        this.fieldPrefix = fieldPrefix;
    }
}

