/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.action.admin.export;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.action.admin.export.EntitiesExporter;
import com.atlassian.jira.action.admin.export.EntityXmlWriter;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.startup.FormattedLogMsg;
import com.atlassian.jira.startup.JiraSystemInfo;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.EntityListIterator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelViewEntity;

public class DefaultSaxEntitiesExporter
implements EntitiesExporter {
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    protected static final String NL = System.getProperty("line.separator");
    private static final Logger log = Logger.getLogger(DefaultSaxEntitiesExporter.class);
    private final DelegatorInterface delegator;
    private final ApplicationProperties applicationProperties;
    private final BuildUtilsInfo buildUtilsInfo;

    public DefaultSaxEntitiesExporter(DelegatorInterface delegator, ApplicationProperties applicationProperties, BuildUtilsInfo buildUtilsInfo) {
        this.delegator = Assertions.notNull("delegator", delegator);
        this.applicationProperties = Assertions.notNull("applicationProperties", applicationProperties);
        this.buildUtilsInfo = Assertions.notNull("buildUtilsInfo", buildUtilsInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long exportEntities(OutputStream outputStream, SortedSet<String> entityNames, EntityXmlWriter entityWriter, User exportingUser) throws IOException, GenericEntityException {
        long numberWritten = 0L;
        EntityCounter entityCounter = new EntityCounter();
        PrintWriter printWriter = this.getWriter(outputStream);
        this.writeHeader(printWriter, exportingUser);
        try {
            for (String curEntityName : entityNames) {
                log.debug((Object)("curEntityName = " + curEntityName));
                ModelEntity modelEntity = this.delegator.getModelReader().getModelEntity(curEntityName);
                if (!(modelEntity instanceof ModelViewEntity)) {
                    EntityListIterator listIterator = null;
                    try {
                        listIterator = this.delegator.findListIteratorByCondition(curEntityName, null, null, null);
                        GenericValue genericValue = listIterator.next();
                        while (genericValue != null) {
                            entityWriter.writeXmlText(genericValue, printWriter);
                            ++numberWritten;
                            entityCounter.increment(curEntityName);
                            genericValue = listIterator.next();
                        }
                        continue;
                    }
                    finally {
                        if (listIterator != null) {
                            listIterator.close();
                        }
                        continue;
                    }
                }
                log.debug((Object)("No need to export entity '" + curEntityName + "' as it is a view entity."));
            }
            this.writeFooter(printWriter, entityCounter);
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
            }
        }
        return numberWritten;
    }

    protected PrintWriter getWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, this.applicationProperties.getEncoding()), 32768));
    }

    protected void writeFooter(PrintWriter printWriter, EntityCounter entityCounter) {
        this.writeEntityCountComment(printWriter, entityCounter);
        printWriter.write("</entity-engine-xml>");
    }

    private void writeEntityCountComment(PrintWriter printWriter, EntityCounter entityCounter) {
        FormattedLogMsg logMsg = new FormattedLogMsg();
        try {
            entityCounter.outputToMessage(logMsg);
        }
        catch (RuntimeException rte) {
            log.error((Object)"An exception occuring while writing the JIRA system info end comment", (Throwable)rte);
            return;
        }
        printWriter.println("<!-- ");
        printWriter.println(this.escapeXmlComment(logMsg.toString()));
        printWriter.println(" -->");
    }

    protected void writeHeader(PrintWriter printWriter, User exportingUser) {
        printWriter.write("<?xml version=\"1.0\" encoding=\"" + this.applicationProperties.getEncoding() + "\"?>" + NL);
        this.writeSysInfoComment(printWriter, exportingUser);
        printWriter.write("<entity-engine-xml>" + NL);
    }

    private void writeSysInfoComment(PrintWriter printWriter, User exportingUser) {
        FormattedLogMsg logMsg = new FormattedLogMsg();
        try {
            DateFormat df = DateFormat.getDateTimeInstance(0, 0);
            String when = df.format(new Date());
            String exportingUserName = "Unknown???";
            if (exportingUser != null) {
                exportingUserName = exportingUser.getName();
                if (exportingUser.getDisplayName() != null) {
                    exportingUserName = exportingUserName + " ( " + exportingUser.getDisplayName() + " )";
                }
            }
            logMsg.outputHeader("Exported on");
            logMsg.outputProperty("on", when);
            logMsg.outputProperty("by", exportingUserName);
            JiraSystemInfo info = new JiraSystemInfo(logMsg, this.buildUtilsInfo);
            info.obtainBasicInfo(null);
            info.obtainDatabaseConfigurationInfo();
            info.obtainJiraAppProperties();
            info.obtainDatabaseStatistics();
            info.obtainUpgradeHistory();
            info.obtainFilePaths();
            info.obtainPlugins();
            info.obtainListeners();
            info.obtainServices();
            info.obtainTrustedApps();
        }
        catch (RuntimeException rte) {
            log.error((Object)"An exception occuring while writing the JIRA system info start commment", (Throwable)rte);
            return;
        }
        printWriter.println("<!-- ");
        printWriter.println(this.escapeXmlComment(logMsg.toString()));
        printWriter.println(" -->");
    }

    private String escapeXmlComment(String xmlComment) {
        String escapedComment = xmlComment;
        if (xmlComment.indexOf("--") != -1) {
            escapedComment = escapedComment.replaceAll("--", "-:");
            escapedComment = new StringBuffer().append("\nThe comment data contained one of more occurences of a '-' character followed immediately by another '-' character.").append("\nThis is not allowed according to http://www.w3.org/TR/REC-xml/#dt-comment.").append("\nThese have been replaced by '-:' characters to make the XML valid").append("\n\n").append(escapedComment).toString();
        }
        return escapedComment;
    }

    private static final class EntityCounter {
        Map<String, AtomicLong> map = new LinkedHashMap<String, AtomicLong>();
        AtomicLong total = new AtomicLong(0L);

        private EntityCounter() {
        }

        private void increment(String entityName) {
            AtomicLong count = this.map.get(entityName);
            if (count == null) {
                count = new AtomicLong(0L);
                this.map.put(entityName, count);
            }
            count.incrementAndGet();
            this.total.incrementAndGet();
        }

        private void outputToMessage(FormattedLogMsg logMsg) {
            logMsg.outputHeader("Entities");
            logMsg.outputProperty("Total", String.valueOf(this.total));
            logMsg.add("");
            for (Map.Entry<String, AtomicLong> entry : this.map.entrySet()) {
                logMsg.outputProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
        }
    }
}

