/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diff;

import com.atlassian.diff.CharacterChunk;
import com.atlassian.diff.DiffChunk;
import com.atlassian.diff.DiffType;
import com.atlassian.diff.WordChunk;
import com.atlassian.diff.WordLevelDiffer;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.log4j.Logger;

public class DiffViewBean {
    private static final Logger log = Logger.getLogger(DiffViewBean.class);
    private final List<DiffChunk> chunks;

    DiffViewBean(List<DiffChunk> chunks) {
        this.chunks = chunks;
    }

    public List<DiffChunk> getOriginalChunks() {
        return DiffViewBean.getFilteredList(this.chunks, CollectionBuilder.newBuilder(DiffType.ADDED_WORDS, DiffType.ADDED_CHARACTERS, DiffType.ADDED_LINES).asSet());
    }

    public List<DiffChunk> getRevisedChunks() {
        return DiffViewBean.getFilteredList(this.chunks, CollectionBuilder.newBuilder(DiffType.DELETED_WORDS, DiffType.DELETED_CHARACTERS, DiffType.DELETED_LINES).asSet());
    }

    public List<DiffChunk> getUnifiedChunks() {
        return CollectionUtil.copyAsImmutableList(this.chunks);
    }

    static List<DiffChunk> getFilteredList(List<DiffChunk> source, Set<DiffType> excludedTypes) {
        ArrayList<DiffChunk> result = new ArrayList<DiffChunk>(source.size());
        for (DiffChunk chunk : source) {
            WordChunk wordChunk;
            if (excludedTypes.contains((Object)chunk.getType())) continue;
            if (chunk instanceof WordChunk && (wordChunk = (WordChunk)chunk).getCharacterChunks() != null) {
                List<CharacterChunk> notDeletedChunks = DiffViewBean.getFilteredListOfCharacterChunks(wordChunk.getCharacterChunks(), excludedTypes);
                chunk = new WordChunk(wordChunk.getType(), notDeletedChunks);
            }
            result.add(chunk);
        }
        return CollectionUtil.copyAsImmutableList(result);
    }

    private static List<CharacterChunk> getFilteredListOfCharacterChunks(List<CharacterChunk> source, Set<DiffType> excludedTypes) {
        if (source != null) {
            ArrayList<CharacterChunk> result = new ArrayList<CharacterChunk>(source.size());
            for (CharacterChunk chunk : source) {
                if (excludedTypes.contains((Object)chunk.getType())) continue;
                result.add(chunk);
            }
            return CollectionUtil.copyAsImmutableList(result);
        }
        return Collections.emptyList();
    }

    public static DiffViewBean createWordLevelDiff(String originalLine, String revisedLine) {
        try {
            return new DiffViewBean(WordLevelDiffer.diffLine(originalLine, revisedLine));
        }
        catch (DifferentiationFailedException e) {
            log.warn((Object)e, (Throwable)e);
            return null;
        }
    }
}

