/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.ofbiz.test.mock;

import com.atlassian.core.ofbiz.CoreFactory;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericPK;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.util.UtilMisc;
import org.ofbiz.core.util.UtilValidate;

public class MockGenericValue
extends GenericValue {
    @SuppressWarnings(value={"MF_CLASS_MASKS_FIELD"}, justification="It is a mock, so we are okay with this.")
    Map fields;
    boolean created = false;
    boolean stored = false;
    boolean refreshed = false;
    boolean removed = false;
    Map related = new HashMap();
    GenericDelegator gd;

    public MockGenericValue(GenericValue value) {
        this(value.getEntityName());
        this.fields = value.getFields(value.getAllKeys());
    }

    public MockGenericValue(String entityName) {
        super(new ModelEntity(), null);
        this.entityName = entityName;
        this.fields = new HashMap();
    }

    public MockGenericValue(String entityName, Map fields) {
        this(entityName);
        if (fields != null) {
            this.fields = fields;
        }
    }

    public Object get(String name) {
        return this.fields.get(name);
    }

    public void set(String name, Object value) {
        this.fields.put(name, value);
    }

    public Collection getAllKeys() {
        return this.fields.keySet();
    }

    public Map getFields(Collection collection) {
        HashMap selectedFields = new HashMap();
        for (String key : collection) {
            selectedFields.put(key, this.fields.get(key));
        }
        return selectedFields;
    }

    public Map getAllFields() {
        return this.fields;
    }

    public List getRelated(String s) throws GenericEntityException {
        Object related = this.related.get(s);
        return related != null ? (List)related : Collections.EMPTY_LIST;
    }

    public List getRelated(String s, Map map, List order) throws GenericEntityException {
        return CoreFactory.getGenericDelegator().getRelated(s, map, order, (GenericValue)this);
    }

    public void setRelated(String s, List relatedGVs) {
        this.related.put(s, relatedGVs);
    }

    public GenericValue create() throws GenericEntityException {
        this.created = true;
        return CoreFactory.getGenericDelegator().create((GenericValue)this);
    }

    public boolean isCreated() {
        return this.created;
    }

    public boolean isStored() {
        return this.stored;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public boolean isRefreshed() {
        return this.refreshed;
    }

    public ModelEntity getModelEntity() {
        return new MockModelEntity(this);
    }

    public boolean matchesFields(Map keyValuePairs) {
        if (this.fields == null) {
            return true;
        }
        if (keyValuePairs == null || keyValuePairs.size() == 0) {
            return true;
        }
        for (Map.Entry anEntry : keyValuePairs.entrySet()) {
            if (UtilValidate.areEqual(anEntry.getValue(), this.fields.get(anEntry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public GenericPK getPrimaryKey() {
        return new GenericPK(this.getModelEntity(), UtilMisc.toMap((String)"id", this.fields.get("id")));
    }

    public void setDelegator(GenericDelegator internalDelegator) {
        this.gd = internalDelegator;
    }

    public GenericDelegator getDelegator() {
        return this.gd;
    }

    public void store() throws GenericEntityException {
        this.stored = true;
        CoreFactory.getGenericDelegator().store((GenericValue)this);
    }

    public void remove() throws GenericEntityException {
        this.removed = true;
        CoreFactory.getGenericDelegator().removeValue((GenericValue)this);
    }

    public void removeRelated(String relationName) throws GenericEntityException {
        this.related.remove(relationName);
    }

    public void refresh() throws GenericEntityException {
        this.refreshed = true;
        CoreFactory.getGenericDelegator().refresh((GenericValue)this);
    }

    public String toString() {
        StringBuffer theString = new StringBuffer();
        theString.append("[GenericEntity:");
        theString.append(this.getEntityName());
        theString.append(']');
        Iterator entries = this.fields.entrySet().iterator();
        Map.Entry anEntry = null;
        while (entries.hasNext()) {
            anEntry = entries.next();
            theString.append('[');
            theString.append(anEntry.getKey());
            theString.append(',');
            theString.append(anEntry.getValue());
            theString.append(']');
        }
        return theString.toString();
    }

    public Object dangerousGetNoCheckButFast(ModelField modelField) {
        if (modelField == null) {
            throw new IllegalArgumentException("Cannot get field with a null modelField");
        }
        return this.fields.get(modelField.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MockGenericValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MockGenericValue mockGenericValue = (MockGenericValue)((Object)o);
        return !(this.fields != null ? !((Object)this.fields).equals(mockGenericValue.fields) : mockGenericValue.fields != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.fields != null ? ((Object)this.fields).hashCode() : 0);
        result = 29 * result + (this.created ? 1 : 0);
        return result;
    }

    public void setString(String s, String s1) {
        this.set(s, s1);
    }

    public List getRelatedOrderBy(String relationName, List orderBy) throws GenericEntityException {
        return CoreFactory.getGenericDelegator().getRelatedOrderBy(relationName, orderBy, (GenericValue)this);
    }

    public List getRelatedByAnd(String relationName, Map fields) throws GenericEntityException {
        return CoreFactory.getGenericDelegator().getRelatedByAnd(relationName, fields, (GenericValue)this);
    }

    public Set entrySet() {
        return this.fields.entrySet();
    }

    public Set keySet() {
        return this.fields.keySet();
    }

    public int size() {
        return this.fields.size();
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public Collection values() {
        return this.fields.values();
    }

    public Object clone() {
        return new MockGenericValue(this.entityName, new HashMap(this.fields));
    }

    public class MockModelEntity
    extends ModelEntity {
        GenericValue value;

        public MockModelEntity() {
        }

        public MockModelEntity(GenericValue value) {
            this.value = value;
            this.setEntityName(value.getEntityName());
        }

        public List getAllFieldNames() {
            ArrayList<String> fieldnames = new ArrayList<String>();
            for (String key : this.value.getAllKeys()) {
                fieldnames.add(key);
            }
            return fieldnames;
        }

        public ModelField getField(String fieldName) {
            ModelField field = null;
            if (this.value.getAllKeys().contains(fieldName)) {
                field = new ModelField();
                field.setName(fieldName);
            }
            return field;
        }
    }
}

