/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.ofbiz.association;

import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.user.UserUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericPK;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilMisc;

public class DefaultAssociationManager
implements AssociationManager {
    private static final Logger log = Logger.getLogger(DefaultAssociationManager.class);
    private final DelegatorInterface delegator;

    public DefaultAssociationManager(DelegatorInterface delegator) {
        this.delegator = delegator;
    }

    @Override
    public GenericValue createAssociation(GenericValue source, GenericValue sink, String associationType) throws GenericEntityException {
        GenericValue existingAssociation = this.getAssociation(source, sink, associationType);
        if (existingAssociation == null) {
            GenericValue v = this.delegator.makeValue("NodeAssociation", UtilMisc.toMap((String)"associationType", (Object)associationType, (String)"sourceNodeId", (Object)source.getLong("id"), (String)"sourceNodeEntity", (Object)source.getEntityName(), (String)"sinkNodeId", (Object)sink.getLong("id"), (String)"sinkNodeEntity", (Object)sink.getEntityName()));
            v.create();
            return v;
        }
        return existingAssociation;
    }

    @Override
    public GenericValue createAssociation(Long sourceNodeId, String sourceNodeEntity, Long sinkNodeId, String sinkNodeEntity, String associationType) throws GenericEntityException {
        GenericValue existingAssociation = this.getAssociation(sourceNodeId, sourceNodeEntity, sinkNodeId, sinkNodeEntity, associationType);
        if (existingAssociation == null) {
            GenericValue v = this.delegator.makeValue("NodeAssociation", UtilMisc.toMap((String)"associationType", (Object)associationType, (String)"sourceNodeId", (Object)sourceNodeId, (String)"sourceNodeEntity", (Object)sourceNodeEntity, (String)"sinkNodeId", (Object)sinkNodeId, (String)"sinkNodeEntity", (Object)sinkNodeEntity));
            v.create();
            return v;
        }
        return existingAssociation;
    }

    public GenericValue createAssociation(String userName, Long sinkNodeId, String sinkNodeEntity, String associationType) throws GenericEntityException {
        GenericValue existingAssociation = this.getAssociation(userName, sinkNodeId, sinkNodeEntity, associationType);
        if (existingAssociation == null) {
            GenericValue v = this.delegator.makeValue("UserAssociation", UtilMisc.toMap((String)"associationType", (Object)associationType, (String)"sourceName", (Object)userName, (String)"sinkNodeId", (Object)sinkNodeId, (String)"sinkNodeEntity", (Object)sinkNodeEntity));
            v.create();
            v.refresh();
            return v;
        }
        return existingAssociation;
    }

    public GenericValue createAssociation(User user, GenericValue sink, String associationType) throws GenericEntityException {
        GenericValue v = this.delegator.makeValue("UserAssociation", UtilMisc.toMap((String)"associationType", (Object)associationType, (String)"sourceName", (Object)user.getName(), (String)"sinkNodeId", (Object)sink.getLong("id"), (String)"sinkNodeEntity", (Object)sink.getEntityName()));
        v.create();
        v.refresh();
        return v;
    }

    @Override
    public void removeAssociation(User user, GenericValue sink, String associationType) throws GenericEntityException {
        this.removeAssociation(user.getName(), sink, associationType);
    }

    @Override
    public void removeAssociation(String username, GenericValue sink, String associationType) throws GenericEntityException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sinkNodeId", sink.getLong("id"));
        fields.put("sinkNodeEntity", sink.getEntityName());
        fields.put("sourceName", username);
        fields.put("associationType", associationType);
        this.delegator.removeByPrimaryKey(this.delegator.makePK("UserAssociation", fields));
    }

    @Override
    public void removeAssociation(GenericValue source, GenericValue sink, String associationType) throws GenericEntityException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sinkNodeId", sink.getLong("id"));
        fields.put("sinkNodeEntity", sink.getEntityName());
        fields.put("sourceNodeId", source.getLong("id"));
        fields.put("sourceNodeEntity", source.getEntityName());
        fields.put("associationType", associationType);
        this.delegator.removeByPrimaryKey(this.delegator.makePK("NodeAssociation", fields));
    }

    @Override
    public void removeAssociationsFromSource(GenericValue source) throws GenericEntityException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sourceNodeId", source.getLong("id"));
        fields.put("sourceNodeEntity", source.getEntityName());
        this.delegator.removeByAnd("NodeAssociation", fields);
    }

    @Override
    public void removeAssociationsFromSink(GenericValue sink) throws GenericEntityException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sinkNodeId", sink.getLong("id"));
        fields.put("sinkNodeEntity", sink.getEntityName());
        this.delegator.removeByAnd("NodeAssociation", fields);
    }

    @Override
    public void removeUserAssociationsFromSink(GenericValue sink) throws GenericEntityException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sinkNodeId", sink.getLong("id"));
        fields.put("sinkNodeEntity", sink.getEntityName());
        this.delegator.removeByAnd("UserAssociation", fields);
    }

    @Override
    public void removeUserAssociationsFromSink(GenericValue sink, String associationType) throws GenericEntityException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sinkNodeId", sink.getLong("id"));
        fields.put("sinkNodeEntity", sink.getEntityName());
        fields.put("associationType", associationType);
        this.delegator.removeByAnd("UserAssociation", fields);
    }

    @Override
    public void removeUserAssociationsFromUser(User user) throws GenericEntityException {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("sourceName", user.getName());
        this.delegator.removeByAnd("UserAssociation", fields);
    }

    @Override
    public void removeUserAssociationsFromUser(User user, String associationType) throws GenericEntityException {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("sourceName", user.getName());
        fields.put("associationType", associationType);
        this.delegator.removeByAnd("UserAssociation", fields);
    }

    @Override
    public void removeUserAssociationsFromUser(User user, String associationType, String entityName) throws GenericEntityException {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("sourceName", user.getName());
        fields.put("associationType", associationType);
        fields.put("sinkNodeEntity", entityName);
        this.delegator.removeByAnd("UserAssociation", fields);
    }

    @Override
    public void swapAssociation(String sourceEntityName, String associationType, GenericValue fromSink, GenericValue toSink) throws GenericEntityException {
        List<GenericValue> sources = this.getSourceFromSink(fromSink, sourceEntityName, associationType, false);
        this.swapAssociation(sources, associationType, fromSink, toSink);
    }

    @Override
    public void swapAssociation(List<GenericValue> entities, String associationType, GenericValue fromSink, GenericValue toSink) throws GenericEntityException {
        for (GenericValue entity : entities) {
            this.createAssociation(entity, toSink, associationType);
            this.removeAssociation(entity, fromSink, associationType);
        }
    }

    List<GenericValue> getAssociations(String associationName, Map<String, ?> fields, boolean useCache, boolean useSequence) throws GenericEntityException {
        List result = useCache ? this.delegator.findByAndCache(associationName, fields) : this.delegator.findByAnd(associationName, fields);
        if (useSequence) {
            result = EntityUtil.orderBy((List)result, (List)UtilMisc.toList((Object)"sequence"));
        }
        return result;
    }

    @Override
    public GenericValue getAssociation(GenericValue source, GenericValue sink, String associationType) throws GenericEntityException {
        return this.getAssociation(source.getLong("id"), source.getEntityName(), sink.getLong("id"), sink.getEntityName(), associationType);
    }

    @Override
    public GenericValue getAssociation(User user, GenericValue sink, String associationType) throws GenericEntityException {
        if (user == null) {
            return null;
        }
        return EntityUtil.getOnly((List)this.delegator.findByAnd("UserAssociation", UtilMisc.toMap((String)"associationType", (Object)associationType, (String)"sourceName", (Object)user.getName(), (String)"sinkNodeId", (Object)sink.getLong("id"), (String)"sinkNodeEntity", (Object)sink.getEntityName())));
    }

    @Override
    public List<GenericValue> getSinkFromSource(GenericValue source, String sinkName, String associationType, boolean useCache) throws GenericEntityException {
        return this.getSinkFromSource(source, sinkName, associationType, useCache, false);
    }

    @Override
    public List<GenericValue> getSinkFromSource(GenericValue source, String sinkName, String associationType, boolean useCache, boolean useSequence) throws GenericEntityException {
        if (source == null) {
            throw new IllegalArgumentException("Source GenericValue can not be null.");
        }
        List<GenericValue> result = this.getSinkIdsFromSource(source, sinkName, associationType, useCache, useSequence);
        ArrayList outList = new ArrayList(result.size());
        for (GenericValue value : result) {
            GenericValue byPrimaryKey = useCache ? this.delegator.findByPrimaryKeyCache(sinkName, UtilMisc.toMap((String)"id", (Object)value.getLong("sinkNodeId"))) : this.delegator.findByPrimaryKey(sinkName, UtilMisc.toMap((String)"id", (Object)value.getLong("sinkNodeId")));
            if (byPrimaryKey == null) continue;
            outList.add(byPrimaryKey);
        }
        return result.isEmpty() ? Collections.emptyList() : outList;
    }

    private List<GenericValue> getSinkIdsFromSource(GenericValue source, String sinkName, String associationType, boolean useCache, boolean useSequence) throws GenericEntityException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sourceNodeId", source.getLong("id"));
        fields.put("sourceNodeEntity", source.getEntityName());
        fields.put("associationType", associationType);
        fields.put("sinkNodeEntity", sinkName);
        return this.getAssociations("NodeAssociation", fields, useCache, useSequence);
    }

    @Override
    public List<GenericValue> getSourceFromSink(GenericValue sink, String sourceName, String associationType, boolean useCache) throws GenericEntityException {
        return this.getSourceFromSink(sink, sourceName, associationType, useCache, false);
    }

    @Override
    public List<GenericValue> getSourceFromSink(GenericValue sink, String sourceName, String associationType, boolean useCache, boolean useSequence) throws GenericEntityException {
        if (sink == null) {
            throw new IllegalArgumentException("Sink GenericValue can not be null.");
        }
        List<GenericValue> result = this.getSourceIdsFromSink(sink, associationType, sourceName, useCache, useSequence);
        ArrayList outList = new ArrayList(result.size());
        for (GenericValue value : result) {
            GenericPK pk = this.delegator.makePK(sourceName, UtilMisc.toMap((String)"id", (Object)value.getLong("sourceNodeId")));
            GenericValue byPrimaryKey = useCache ? this.delegator.findByPrimaryKeyCache(pk) : this.delegator.findByPrimaryKey(pk);
            if (byPrimaryKey == null) continue;
            outList.add(byPrimaryKey);
        }
        return result.isEmpty() ? Collections.emptyList() : outList;
    }

    private List<GenericValue> getSourceIdsFromSink(GenericValue sink, String associationType, String sourceName, boolean useCache, boolean useSequence) throws GenericEntityException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sinkNodeId", sink.getLong("id"));
        fields.put("sinkNodeEntity", sink.getEntityName());
        fields.put("associationType", associationType);
        fields.put("sourceNodeEntity", sourceName);
        return this.getAssociations("NodeAssociation", fields, useCache, useSequence);
    }

    @Override
    public List<GenericValue> getSinkFromUser(User source, String sinkName, String associationType, boolean useCache) throws GenericEntityException {
        return this.getSinkFromUser(source, sinkName, associationType, useCache, false);
    }

    @Override
    public List<Long> getSinkIdsFromUser(User source, String sinkName, String associationType, boolean useCache) throws GenericEntityException {
        List<GenericValue> result = this.getAssociationsForUser(source, sinkName, associationType, useCache, false);
        ArrayList<Long> out = new ArrayList<Long>(result.size());
        for (GenericValue value : result) {
            out.add(value.getLong("sinkNodeId"));
        }
        return out;
    }

    @Override
    public List<GenericValue> getSinkFromUser(User source, String sinkName, String associationType, boolean useCache, boolean useSequence) throws GenericEntityException {
        List<GenericValue> result = this.getAssociationsForUser(source, sinkName, associationType, useCache, useSequence);
        ArrayList outList = new ArrayList(result.size());
        for (GenericValue value : result) {
            GenericPK pk = this.delegator.makePK(sinkName, UtilMisc.toMap((String)"id", (Object)value.getLong("sinkNodeId")));
            GenericValue byPrimaryKey = useCache ? this.delegator.findByPrimaryKeyCache(pk) : this.delegator.findByPrimaryKey(pk);
            if (byPrimaryKey == null) continue;
            outList.add(byPrimaryKey);
        }
        return result.isEmpty() ? Collections.emptyList() : outList;
    }

    private List<GenericValue> getAssociationsForUser(User source, String sinkName, String associationType, boolean useCache, boolean useSequence) throws GenericEntityException {
        if (source == null) {
            throw new IllegalArgumentException("User can not be null.");
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("sourceName", source.getName());
        fields.put("associationType", associationType);
        fields.put("sinkNodeEntity", sinkName);
        return this.getAssociations("UserAssociation", fields, useCache, useSequence);
    }

    @Override
    public List<User> getUserFromSink(GenericValue sink, String associationType, boolean useCache) throws GenericEntityException {
        return this.getUserFromSink(sink, associationType, useCache, false);
    }

    @Override
    public List<User> getUserFromSink(GenericValue sink, String associationType, boolean useCache, boolean useSequence) throws GenericEntityException {
        List<String> usernames = this.getUsernamesFromSink(sink, associationType, useCache, useSequence);
        ArrayList<User> users = new ArrayList<User>(usernames.size());
        for (String username : usernames) {
            User user = UserUtils.getUser(username);
            if (user != null) {
                users.add(user);
                continue;
            }
            log.error((Object)("Cannot find user with username '" + username + "'."));
        }
        return users;
    }

    @Override
    public List<String> getUsernamesFromSink(GenericValue sink, String associationType, boolean useCache, boolean useSequence) throws GenericEntityException {
        if (sink == null) {
            throw new IllegalArgumentException("Sink GenericValue can not be null.");
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sinkNodeId", sink.getLong("id"));
        fields.put("sinkNodeEntity", sink.getEntityName());
        fields.put("associationType", associationType);
        List<GenericValue> results = this.getAssociations("UserAssociation", fields, useCache, useSequence);
        if (results.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> outList = new ArrayList<String>(results.size());
        for (GenericValue result : results) {
            outList.add(result.getString("sourceName"));
        }
        return outList;
    }

    @Override
    public List<Long> getSinkIdsFromSource(GenericValue source, String sinkEntity, String associationType) throws GenericEntityException {
        List<GenericValue> sinks = this.getSinkIdsFromSource(source, sinkEntity, associationType, false, false);
        if (sinks != null && !sinks.isEmpty()) {
            ArrayList<Long> sinkIds = new ArrayList<Long>();
            for (GenericValue sink : sinks) {
                sinkIds.add(sink.getLong("sinkNodeId"));
            }
            return sinkIds;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> getSourceIdsFromSink(GenericValue sink, String sourceEntity, String associationType) throws GenericEntityException {
        List<GenericValue> sources = this.getSourceIdsFromSink(sink, associationType, sourceEntity, false, false);
        if (sources != null && !sources.isEmpty()) {
            ArrayList<Long> sourceIds = new ArrayList<Long>();
            for (GenericValue source : sources) {
                sourceIds.add(source.getLong("sourceNodeId"));
            }
            return sourceIds;
        }
        return Collections.emptyList();
    }

    private GenericValue getAssociation(Long sourceNodeId, String sourceNodeEntity, Long sinkNodeId, String sinkNodeEntity, String associationType) throws GenericEntityException {
        return EntityUtil.getOnly((List)this.delegator.findByAnd("NodeAssociation", UtilMisc.toMap((String)"associationType", (Object)associationType, (String)"sourceNodeId", (Object)sourceNodeId, (String)"sourceNodeEntity", (Object)sourceNodeEntity, (String)"sinkNodeId", (Object)sinkNodeId, (String)"sinkNodeEntity", (Object)sinkNodeEntity)));
    }

    private GenericValue getAssociation(String sourceName, Long sinkNodeId, String sinkNodeEntity, String associationType) throws GenericEntityException {
        return EntityUtil.getOnly((List)this.delegator.findByAnd("UserAssociation", UtilMisc.toMap((String)"associationType", (Object)associationType, (String)"sourceName", (Object)sourceName, (String)"sinkNodeId", (Object)sinkNodeId, (String)"sinkNodeEntity", (Object)sinkNodeEntity)));
    }
}

