/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.configurable;

import com.atlassian.configurable.EnabledCondition;
import com.atlassian.configurable.ObjectConfigurationProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ListOrderedMap;

public class ObjectConfigurationPropertyImpl
implements ObjectConfigurationProperty {
    private final String name;
    private final String description;
    private final String defaultValue;
    private final int type;
    private final EnabledCondition enabled;
    private final Map internalValues = Collections.synchronizedMap(new ListOrderedMap());
    private final Map userParams = Collections.synchronizedMap(new HashMap());
    private String cascadeFrom;
    private boolean i18nValues = true;

    ObjectConfigurationPropertyImpl(String name, String description, String defaultValue, int type) {
        this(name, description, defaultValue, type, EnabledCondition.TRUE);
    }

    ObjectConfigurationPropertyImpl(String name, String description, String defaultValue, int type, String enabledConditionClass) {
        this(name, description, defaultValue, type, EnabledCondition.Factory.create(enabledConditionClass));
    }

    ObjectConfigurationPropertyImpl(String name, String description, String defaultValue, int type, String enabledConditionClass, ClassLoader classLoader) {
        this(name, description, defaultValue, type, EnabledCondition.Factory.create(enabledConditionClass, classLoader));
    }

    ObjectConfigurationPropertyImpl(String name, String description, String defaultValue, int type, EnabledCondition enabledCondition) {
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
        this.type = type;
        this.enabled = enabledCondition == null ? EnabledCondition.TRUE : enabledCondition;
    }

    ObjectConfigurationPropertyImpl(String name, String description, String defaultValue, int type, Map propertyValues) {
        this(name, description, defaultValue, type);
        this.internalValues.putAll(propertyValues);
    }

    @Override
    public void init(Map userParams) {
        if (userParams != null) {
            this.userParams.clear();
            this.userParams.putAll(userParams);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDefault() {
        return this.defaultValue;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.isEnabled();
    }

    @Override
    public int size() {
        return this.getInternalValues(this.userParams).size();
    }

    @Override
    public boolean isEmpty() {
        return this.getInternalValues(this.userParams).isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getInternalValues(this.userParams).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getInternalValues(this.userParams).containsValue(value);
    }

    public Object get(Object key) {
        return this.getInternalValues(this.userParams).get(key);
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException("ObjectConfigurationProperty object is immutable");
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException("ObjectConfigurationProperty object is immutable");
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException("ObjectConfigurationProperty object is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("ObjectConfigurationProperty object is immutable");
    }

    public Set keySet() {
        return this.getInternalValues(this.userParams).keySet();
    }

    public Collection values() {
        return this.getInternalValues(this.userParams).values();
    }

    public Set entrySet() {
        return this.getInternalValues(this.userParams).entrySet();
    }

    @Override
    public boolean isI18nValues() {
        return this.i18nValues;
    }

    @Override
    public void setI18nValues(boolean i18nValues) {
        this.i18nValues = i18nValues;
    }

    @Override
    public String getCascadeFrom() {
        return this.cascadeFrom;
    }

    @Override
    public void setCascadeFrom(String cascadeFrom) {
        this.cascadeFrom = cascadeFrom;
    }

    protected Map getInternalValues(Map userParams) {
        return Collections.unmodifiableMap(this.internalValues);
    }

    protected Map getMutableInternalValues() {
        return this.internalValues;
    }
}

