/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.configurable;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.configurable.ObjectConfigurationProperty;
import com.atlassian.configurable.ObjectDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;

public class ObjectConfigurationImpl
implements ObjectConfiguration {
    private final ObjectDescriptor od;
    private final Map<String, ObjectConfigurationProperty> configProperties = Collections.synchronizedMap(new ListOrderedMap());
    private final Map params = Collections.synchronizedMap(new ListOrderedMap());

    public ObjectConfigurationImpl(Map<String, ObjectConfigurationProperty> configProperties, ObjectDescriptor od) {
        this.configProperties.putAll(configProperties);
        this.od = od;
    }

    @Override
    public void init(Map params) {
        this.params.clear();
        if (params != null) {
            this.params.putAll(params);
        }
    }

    @Override
    public String getFieldName(String key) throws ObjectConfigurationException {
        if (this.configProperties.containsKey(key)) {
            return this.configProperties.get(key).getName();
        }
        throw new ObjectConfigurationException("Field with key: " + key + " does not exist.");
    }

    @Override
    public String getFieldDescription(String key) throws ObjectConfigurationException {
        if (this.configProperties.containsKey(key)) {
            return this.configProperties.get(key).getDescription();
        }
        throw new ObjectConfigurationException("Field with key: " + key + " does not exist.");
    }

    @Override
    public String getFieldDefault(String key) throws ObjectConfigurationException {
        if (this.configProperties.containsKey(key)) {
            return this.configProperties.get(key).getDefault();
        }
        throw new ObjectConfigurationException("Field with key: " + key + " does not exist.");
    }

    @Override
    public int getFieldType(String key) throws ObjectConfigurationException {
        if (this.configProperties.containsKey(key)) {
            return new Integer(this.configProperties.get(key).getType());
        }
        throw new ObjectConfigurationException("Field with key: " + key + " does not exist.");
    }

    @Override
    public Map getFieldValues(String key) throws ObjectConfigurationException {
        if (this.configProperties.containsKey(key)) {
            ObjectConfigurationProperty objectConfigurationProperty = this.configProperties.get(key);
            objectConfigurationProperty.init(this.params);
            return objectConfigurationProperty;
        }
        throw new ObjectConfigurationException("Field with key: " + key + " does not exist.");
    }

    @Override
    public String[] getFieldKeys() {
        String[] returnValue = new String[this.configProperties.size()];
        int counter = 0;
        Iterator<String> iterator = this.configProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            returnValue[counter] = key = iterator.next();
            ++counter;
        }
        return returnValue;
    }

    @Override
    public String[] getEnabledFieldKeys() {
        ArrayList<String> returnValue = new ArrayList<String>();
        for (Map.Entry<String, ObjectConfigurationProperty> entry : this.configProperties.entrySet()) {
            if (!entry.getValue().isEnabled()) continue;
            returnValue.add(entry.getKey());
        }
        return returnValue.toArray(new String[returnValue.size()]);
    }

    @Override
    public boolean isEnabled(String key) {
        ObjectConfigurationProperty property = this.configProperties.get(key);
        return property != null && property.isEnabled();
    }

    @Override
    public String getDescription(Map params) {
        return this.od.getDescription(this.configProperties, params);
    }

    @Override
    public boolean allFieldsHidden() {
        if (this.configProperties != null) {
            for (ObjectConfigurationProperty ocp : this.configProperties.values()) {
                if (ocp.getType() == 3) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isI18NValues(String key) {
        return this.configProperties.containsKey(key) && this.configProperties.get(key).isI18nValues();
    }
}

