/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core;

import com.atlassian.jgitflow.core.AbstractGitFlowCommand;
import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.exception.BranchOutOfDateException;
import com.atlassian.jgitflow.core.exception.DirtyWorkingTreeException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchExistsException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.exception.NotInitializedException;
import com.atlassian.jgitflow.core.exception.ReleaseBranchExistsException;
import com.atlassian.jgitflow.core.exception.RemoteBranchExistsException;
import com.atlassian.jgitflow.core.exception.TagExistsException;
import com.atlassian.jgitflow.core.util.GitHelper;
import com.atlassian.jgitflow.core.util.Preconditions;
import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseStartCommand
extends AbstractGitFlowCommand<Ref> {
    private static final String SHORT_NAME = "release-start";
    private final String releaseName;
    private boolean fetch;
    private boolean push;
    private RevCommit startCommit;
    private String startCommitString;

    public ReleaseStartCommand(String releaseName, Git git, GitFlowConfiguration gfConfig, JGitFlowReporter reporter) {
        super(git, gfConfig, reporter);
        Preconditions.checkState(!StringUtils.isEmptyOrNull((String)releaseName));
        this.releaseName = releaseName;
        this.fetch = false;
        this.push = false;
        this.startCommit = null;
        this.startCommitString = null;
    }

    @Override
    public ReleaseStartCommand setAllowUntracked(boolean allow) {
        super.setAllowUntracked(allow);
        return this;
    }

    @Override
    public ReleaseStartCommand setScmMessagePrefix(String scmMessagePrefix) {
        super.setScmMessagePrefix(scmMessagePrefix);
        return this;
    }

    @Override
    public Ref call() throws NotInitializedException, JGitFlowGitAPIException, ReleaseBranchExistsException, DirtyWorkingTreeException, JGitFlowIOException, LocalBranchExistsException, TagExistsException, BranchOutOfDateException, LocalBranchMissingException, RemoteBranchExistsException {
        String prefixedReleaseName = this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.RELEASE.configKey()) + this.releaseName;
        this.requireGitFlowInitialized();
        this.requireNoExistingReleaseBranches();
        this.requireCleanWorkingTree();
        this.requireLocalBranchAbsent(prefixedReleaseName);
        try {
            if (this.fetch) {
                RefSpec spec = new RefSpec("+refs/heads/" + this.gfConfig.getDevelop() + ":" + "refs/remotes/" + "origin/" + this.gfConfig.getDevelop());
                this.git.fetch().setRefSpecs(new RefSpec[]{spec}).call();
            }
            RevCommit startPoint = null;
            startPoint = null != this.startCommit ? this.startCommit : (!StringUtils.isEmptyOrNull((String)this.startCommitString) ? GitHelper.getCommitForString(this.git, this.startCommitString) : GitHelper.getLatestCommit(this.git, this.gfConfig.getDevelop()));
            RevCommit latest = GitHelper.getLatestCommit(this.git, this.gfConfig.getDevelop());
            this.reporter.debugText(this.getCommandName(), "startPoint is: " + startPoint);
            this.reporter.debugText(this.getCommandName(), "latestCommit is: " + latest.getName());
            this.requireCommitOnBranch(startPoint, this.gfConfig.getDevelop());
            this.requireTagAbsent(this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.VERSIONTAG.configKey()) + this.releaseName);
            if (GitHelper.remoteBranchExists(this.git, this.gfConfig.getDevelop(), this.reporter)) {
                this.requireLocalBranchNotBehindRemote(this.gfConfig.getDevelop());
            }
            Ref newBranch = this.git.checkout().setName(prefixedReleaseName).setCreateBranch(true).setStartPoint(startPoint).call();
            this.reporter.debugText(this.getCommandName(), "created branch: " + prefixedReleaseName);
            if (this.push) {
                this.requireRemoteBranchAbsent(prefixedReleaseName);
                this.reporter.debugText(this.getCommandName(), "pushing branch to origin using refspec: " + prefixedReleaseName);
                RefSpec branchSpec = new RefSpec(prefixedReleaseName);
                this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{branchSpec}).call();
                this.reporter.debugText(this.getCommandName(), "push complete");
                this.git.fetch().setRemote("origin").call();
                StoredConfig config = this.git.getRepository().getConfig();
                config.setString("branch", prefixedReleaseName, "remote", "origin");
                config.setString("branch", prefixedReleaseName, "merge", "refs/heads/" + prefixedReleaseName);
                config.save();
            }
            Ref ref = newBranch;
            return ref;
        }
        catch (GitAPIException e) {
            throw new JGitFlowGitAPIException(e);
        }
        catch (IOException e) {
            throw new JGitFlowIOException(e);
        }
        finally {
            this.reporter.flush();
        }
    }

    public ReleaseStartCommand setFetch(boolean fetch) {
        this.fetch = fetch;
        return this;
    }

    public ReleaseStartCommand setPush(boolean push) {
        this.push = push;
        return this;
    }

    public ReleaseStartCommand setStartCommit(String commitId) {
        this.startCommitString = commitId;
        return this;
    }

    public ReleaseStartCommand setStartCommit(RevCommit commit) {
        this.startCommit = commit;
        return this;
    }

    @Override
    protected String getCommandName() {
        return SHORT_NAME;
    }
}

