/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core;

import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.util.Preconditions;
import org.eclipse.jgit.util.StringUtils;

public class InitContext {
    private String master = "master";
    private String develop = "develop";
    private String feature = "feature/";
    private String release = "release/";
    private String hotfix = "hotfix/";
    private String support = "support/";
    private String versiontag = "";

    public InitContext setMaster(String master) {
        Preconditions.checkState(!StringUtils.isEmptyOrNull((String)master));
        this.master = master;
        return this;
    }

    public InitContext setDevelop(String develop) {
        Preconditions.checkState(!StringUtils.isEmptyOrNull((String)develop));
        this.develop = develop;
        return this;
    }

    public InitContext setFeature(String feature) {
        Preconditions.checkState(!StringUtils.isEmptyOrNull((String)feature));
        this.feature = feature;
        return this;
    }

    public InitContext setRelease(String release) {
        Preconditions.checkState(!StringUtils.isEmptyOrNull((String)release));
        this.release = release;
        return this;
    }

    public InitContext setHotfix(String hotfix) {
        Preconditions.checkState(!StringUtils.isEmptyOrNull((String)hotfix));
        this.hotfix = hotfix;
        return this;
    }

    public InitContext setSupport(String support) {
        Preconditions.checkState(!StringUtils.isEmptyOrNull((String)support));
        this.support = support;
        return this;
    }

    public InitContext setVersiontag(String versiontag) {
        Preconditions.checkNotNull(versiontag);
        this.versiontag = versiontag;
        return this;
    }

    public String getMaster() {
        return this.master;
    }

    public String getDevelop() {
        return this.develop;
    }

    public String getFeature() {
        return this.feature;
    }

    public String getRelease() {
        return this.release;
    }

    public String getHotfix() {
        return this.hotfix;
    }

    public String getSupport() {
        return this.support;
    }

    public String getVersiontag() {
        return this.versiontag;
    }

    public void setPrefix(String prefixName, String prefixValue) {
        JGitFlowConstants.PREFIXES prefix = JGitFlowConstants.PREFIXES.valueOf(prefixName.toUpperCase());
        switch (prefix) {
            case FEATURE: {
                this.setFeature(prefixValue);
                break;
            }
            case RELEASE: {
                this.setRelease(prefixValue);
                break;
            }
            case HOTFIX: {
                this.setHotfix(prefixValue);
                break;
            }
            case SUPPORT: {
                this.setSupport(prefixValue);
                break;
            }
            case VERSIONTAG: {
                this.setVersiontag(prefixValue);
            }
        }
    }

    public String getPrefix(String prefixName) {
        JGitFlowConstants.PREFIXES prefix = JGitFlowConstants.PREFIXES.valueOf(prefixName.toUpperCase());
        String value = null;
        switch (prefix) {
            case FEATURE: {
                value = this.getFeature();
                break;
            }
            case RELEASE: {
                value = this.getRelease();
                break;
            }
            case HOTFIX: {
                value = this.getHotfix();
                break;
            }
            case SUPPORT: {
                value = this.getSupport();
                break;
            }
            case VERSIONTAG: {
                value = this.getVersiontag();
            }
        }
        return value;
    }
}

