/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core;

import com.atlassian.jgitflow.core.AbstractGitFlowCommand;
import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.ReleaseMergeResult;
import com.atlassian.jgitflow.core.exception.BranchOutOfDateException;
import com.atlassian.jgitflow.core.exception.DirtyWorkingTreeException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.util.GitHelper;
import com.atlassian.jgitflow.core.util.Preconditions;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HotfixFinishCommand
extends AbstractGitFlowCommand<ReleaseMergeResult> {
    private static final String SHORT_NAME = "hotfix-finish";
    private final String hotfixName;
    private boolean fetch;
    private String message;
    private boolean push;
    private boolean keepBranch;
    private boolean noTag;

    public HotfixFinishCommand(String hotfixName, Git git, GitFlowConfiguration gfConfig, JGitFlowReporter reporter) {
        super(git, gfConfig, reporter);
        Preconditions.checkState(!StringUtils.isEmptyOrNull((String)hotfixName));
        this.hotfixName = hotfixName;
        this.fetch = false;
        this.message = "tagging hotfix " + hotfixName;
        this.push = false;
        this.keepBranch = false;
        this.noTag = false;
    }

    @Override
    public HotfixFinishCommand setAllowUntracked(boolean allow) {
        super.setAllowUntracked(allow);
        return this;
    }

    @Override
    public HotfixFinishCommand setScmMessagePrefix(String scmMessagePrefix) {
        super.setScmMessagePrefix(scmMessagePrefix);
        return this;
    }

    @Override
    public ReleaseMergeResult call() throws JGitFlowGitAPIException, LocalBranchMissingException, DirtyWorkingTreeException, JGitFlowIOException, BranchOutOfDateException {
        String prefixedHotfixName = this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.HOTFIX.configKey()) + this.hotfixName;
        this.requireLocalBranchExists(prefixedHotfixName);
        this.requireCleanWorkingTree();
        MergeResult developResult = new MergeResult(null, null, new ObjectId[]{null, null}, MergeResult.MergeStatus.ALREADY_UP_TO_DATE, (MergeStrategy)MergeStrategy.RESOLVE, null);
        MergeResult masterResult = new MergeResult(null, null, new ObjectId[]{null, null}, MergeResult.MergeStatus.ALREADY_UP_TO_DATE, (MergeStrategy)MergeStrategy.RESOLVE, null);
        try {
            String tagName;
            if (this.fetch) {
                RefSpec developSpec = new RefSpec("+refs/heads/" + this.gfConfig.getDevelop() + ":" + "refs/remotes/" + "origin/" + this.gfConfig.getDevelop());
                RefSpec masterSpec = new RefSpec("+refs/heads/" + this.gfConfig.getMaster() + ":" + "refs/remotes/" + "origin/" + this.gfConfig.getMaster());
                this.git.fetch().setRemote("origin").setRefSpecs(new RefSpec[]{masterSpec}).call();
                this.git.fetch().setRemote("origin").setRefSpecs(new RefSpec[]{developSpec}).call();
                this.git.fetch().setRemote("origin").call();
            }
            if (GitHelper.remoteBranchExists(this.git, prefixedHotfixName, this.reporter)) {
                this.requireLocalBranchNotBehindRemote(prefixedHotfixName);
            }
            if (GitHelper.remoteBranchExists(this.git, this.gfConfig.getMaster(), this.reporter)) {
                this.requireLocalBranchNotBehindRemote(this.gfConfig.getMaster());
            }
            if (GitHelper.remoteBranchExists(this.git, this.gfConfig.getDevelop(), this.reporter)) {
                this.requireLocalBranchNotBehindRemote(this.gfConfig.getDevelop());
            }
            Ref hotfixBranch = GitHelper.getLocalBranch(this.git, prefixedHotfixName);
            RevCommit hotfixCommit = GitHelper.getLatestCommit(this.git, prefixedHotfixName);
            if (!GitHelper.isMergedInto(this.git, prefixedHotfixName, this.gfConfig.getMaster())) {
                this.git.checkout().setName(this.gfConfig.getMaster()).call();
                masterResult = this.git.merge().setFastForward(MergeCommand.FastForwardMode.NO_FF).include(hotfixBranch).call();
            }
            if (!this.noTag && masterResult.getMergeStatus().isSuccessful() && !GitHelper.tagExists(this.git, tagName = this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.VERSIONTAG.configKey()) + this.hotfixName)) {
                this.reporter.infoText(this.getCommandName(), "tagging hotfix with name:" + tagName);
                this.git.tag().setName(tagName).setMessage(this.getScmMessagePrefix() + this.message).setObjectId((RevObject)hotfixCommit).call();
            }
            if (!GitHelper.isMergedInto(this.git, prefixedHotfixName, this.gfConfig.getDevelop())) {
                this.git.checkout().setName(this.gfConfig.getDevelop()).call();
                developResult = this.git.merge().setFastForward(MergeCommand.FastForwardMode.NO_FF).include(hotfixBranch).call();
            }
            if (this.push && masterResult.getMergeStatus().isSuccessful() && developResult.getMergeStatus().isSuccessful()) {
                RefSpec developSpec = new RefSpec(this.gfConfig.getDevelop());
                this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{developSpec}).call();
                RefSpec masterSpec = new RefSpec(this.gfConfig.getMaster());
                this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{masterSpec}).call();
                if (!this.noTag) {
                    this.git.push().setRemote("origin").setPushTags().call();
                }
                if (GitHelper.remoteBranchExists(this.git, prefixedHotfixName, this.reporter)) {
                    RefSpec branchSpec = new RefSpec(prefixedHotfixName);
                    this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{branchSpec}).call();
                }
            }
            if (!this.keepBranch && masterResult.getMergeStatus().isSuccessful() && developResult.getMergeStatus().isSuccessful()) {
                this.git.checkout().setName(this.gfConfig.getDevelop()).call();
                this.git.branchDelete().setForce(true).setBranchNames(new String[]{prefixedHotfixName}).call();
                if (this.push && GitHelper.remoteBranchExists(this.git, prefixedHotfixName, this.reporter)) {
                    RefSpec deleteSpec = new RefSpec(":refs/heads/" + prefixedHotfixName);
                    this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{deleteSpec}).call();
                }
            }
            this.git.checkout().setName(this.gfConfig.getDevelop()).call();
        }
        catch (GitAPIException e) {
            throw new JGitFlowGitAPIException(e);
        }
        return new ReleaseMergeResult(masterResult, developResult);
    }

    public HotfixFinishCommand setFetch(boolean fetch) {
        this.fetch = fetch;
        return this;
    }

    public HotfixFinishCommand setMessage(String message) {
        this.message = message;
        return this;
    }

    public HotfixFinishCommand setPush(boolean push) {
        this.push = push;
        return this;
    }

    public HotfixFinishCommand setKeepBranch(boolean keepBranch) {
        this.keepBranch = keepBranch;
        return this;
    }

    public HotfixFinishCommand setNoTag(boolean noTag) {
        this.noTag = noTag;
        return this;
    }

    @Override
    protected String getCommandName() {
        return SHORT_NAME;
    }
}

