/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core;

import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.util.GitHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.StoredConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitFlowConfiguration {
    public static final List<String> PREFIX_NAMES = Arrays.asList(JGitFlowConstants.PREFIXES.FEATURE.configKey(), JGitFlowConstants.PREFIXES.RELEASE.configKey(), JGitFlowConstants.PREFIXES.HOTFIX.configKey(), JGitFlowConstants.PREFIXES.SUPPORT.configKey(), JGitFlowConstants.PREFIXES.VERSIONTAG.configKey());
    private final Git git;

    public GitFlowConfiguration(Git git) {
        this.git = git;
    }

    public String getDevelop() {
        return this.git.getRepository().getConfig().getString("gitflow", "branch", "develop");
    }

    public String getMaster() {
        return this.git.getRepository().getConfig().getString("gitflow", "branch", "master");
    }

    public void setMaster(String branchName) throws JGitFlowIOException {
        StoredConfig config = this.git.getRepository().getConfig();
        config.setString("gitflow", "branch", "master", branchName);
        try {
            config.save();
        }
        catch (IOException e) {
            throw new JGitFlowIOException(e);
        }
    }

    public void setDevelop(String branchName) throws JGitFlowIOException {
        StoredConfig config = this.git.getRepository().getConfig();
        config.setString("gitflow", "branch", "develop", branchName);
        try {
            config.save();
        }
        catch (IOException e) {
            throw new JGitFlowIOException(e);
        }
    }

    public boolean gitFlowIsInitialized() throws JGitFlowGitAPIException {
        return this.hasMasterConfigured() && this.hasDevelopConfigured() && !this.getMaster().equals(this.getDevelop()) && this.hasPrefixesConfigured();
    }

    public boolean hasDevelopConfigured() throws JGitFlowGitAPIException {
        return GitHelper.localBranchExists(this.git, this.git.getRepository().getConfig().getString("gitflow", "branch", "develop"));
    }

    public boolean hasMasterConfigured() throws JGitFlowGitAPIException {
        return GitHelper.localBranchExists(this.git, this.git.getRepository().getConfig().getString("gitflow", "branch", "master"));
    }

    public boolean hasPrefixesConfigured() {
        Set entries = this.git.getRepository().getConfig().getNames("gitflow", "prefix");
        return entries.containsAll(this.getPrefixNames());
    }

    public List<String> getPrefixNames() {
        return PREFIX_NAMES;
    }

    public boolean hasPrefixConfigured(String prefixName) {
        Set entries = this.git.getRepository().getConfig().getNames("gitflow", "prefix");
        return entries.contains(prefixName);
    }

    public String getPrefixValue(String prefixName) {
        String val = this.git.getRepository().getConfig().getString("gitflow", "prefix", prefixName);
        return null != val ? val : "";
    }

    public void setPrefix(String prefixName, String prefixValue) throws JGitFlowIOException {
        StoredConfig config = this.git.getRepository().getConfig();
        if (this.getPrefixNames().contains(prefixName)) {
            config.setString("gitflow", "prefix", prefixName, prefixValue);
            try {
                config.save();
            }
            catch (IOException e) {
                throw new JGitFlowIOException(e);
            }
        }
    }
}

