/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core;

import com.atlassian.jgitflow.core.AbstractGitFlowCommand;
import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.exception.BranchOutOfDateException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchExistsException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.exception.NotInitializedException;
import com.atlassian.jgitflow.core.exception.RemoteBranchExistsException;
import com.atlassian.jgitflow.core.util.GitHelper;
import com.atlassian.jgitflow.core.util.Preconditions;
import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureStartCommand
extends AbstractGitFlowCommand<Ref> {
    private static final String SHORT_NAME = "feature-start";
    private final String branchName;
    private boolean fetchDevelop;
    private boolean push;
    private RevCommit startCommit;
    private String startCommitString;

    FeatureStartCommand(String branchName, Git git, GitFlowConfiguration gfConfig, JGitFlowReporter reporter) {
        super(git, gfConfig, reporter);
        Preconditions.checkState(!StringUtils.isEmptyOrNull((String)branchName));
        this.branchName = branchName;
        this.fetchDevelop = false;
        this.push = false;
    }

    @Override
    public FeatureStartCommand setAllowUntracked(boolean allow) {
        super.setAllowUntracked(allow);
        return this;
    }

    @Override
    public FeatureStartCommand setScmMessagePrefix(String scmMessagePrefix) {
        super.setScmMessagePrefix(scmMessagePrefix);
        return this;
    }

    @Override
    public Ref call() throws NotInitializedException, JGitFlowGitAPIException, LocalBranchExistsException, BranchOutOfDateException, JGitFlowIOException, LocalBranchMissingException, RemoteBranchExistsException {
        this.reporter.commandCall(SHORT_NAME);
        String prefixedBranchName = this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.FEATURE.configKey()) + this.branchName;
        this.requireGitFlowInitialized();
        this.requireLocalBranchAbsent(prefixedBranchName);
        if (this.fetchDevelop) {
            RefSpec spec = new RefSpec("+refs/heads/" + this.gfConfig.getDevelop() + ":" + "refs/remotes/" + "origin/" + this.gfConfig.getDevelop());
            try {
                this.git.fetch().setRefSpecs(new RefSpec[]{spec}).call();
            }
            catch (GitAPIException e) {
                throw new JGitFlowGitAPIException(e);
            }
        }
        try {
            if (GitHelper.remoteBranchExists(this.git, this.gfConfig.getDevelop(), this.reporter)) {
                this.requireLocalBranchNotBehindRemote(this.gfConfig.getDevelop());
            }
            RevCommit startPoint = null;
            startPoint = null != this.startCommit ? this.startCommit : (!StringUtils.isEmptyOrNull((String)this.startCommitString) ? GitHelper.getCommitForString(this.git, this.startCommitString) : GitHelper.getLatestCommit(this.git, this.gfConfig.getDevelop()));
            this.requireCommitOnBranch(startPoint, this.gfConfig.getDevelop());
            Ref newBranch = this.git.checkout().setName(prefixedBranchName).setCreateBranch(true).setStartPoint(startPoint).call();
            if (this.push) {
                this.requireRemoteBranchAbsent(prefixedBranchName);
                RefSpec branchSpec = new RefSpec(prefixedBranchName + ":" + "refs/heads/" + prefixedBranchName);
                this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{branchSpec}).call();
                this.git.fetch().setRemote("origin").call();
                StoredConfig config = this.git.getRepository().getConfig();
                config.setString("branch", prefixedBranchName, "remote", "origin");
                config.setString("branch", prefixedBranchName, "merge", "refs/heads/" + prefixedBranchName);
                config.save();
            }
            return newBranch;
        }
        catch (GitAPIException e) {
            throw new JGitFlowGitAPIException(e);
        }
        catch (IOException e) {
            throw new JGitFlowIOException(e);
        }
    }

    public FeatureStartCommand setFetchDevelop(boolean fetch) {
        this.fetchDevelop = fetch;
        return this;
    }

    public FeatureStartCommand setPush(boolean push) {
        this.push = push;
        return this;
    }

    public FeatureStartCommand setStartCommit(String commitId) {
        this.startCommitString = commitId;
        return this;
    }

    public FeatureStartCommand setStartCommit(RevCommit commit) {
        this.startCommit = commit;
        return this;
    }

    @Override
    protected String getCommandName() {
        return SHORT_NAME;
    }
}

