var JCONNECT = window.JCONNECT || {};

JCONNECT.GeoItemDescriptor = AJS.ItemDescriptor.extend({

            REQUIRED_PROPERTIES: {
                label: true,
                lat: true,
                lng: true
            },

            lat: function() {
                return this.properties.lat;
            },

            lng: function() {
                return this.properties.lng;
            }
        });

JCONNECT.LocationDropdown = AJS.QueryableDropdownSelect.extend({

            issueRequest: function() {

                var instance = this,
                        ajaxOptions = this.getAjaxOptions();

                var geocoder = new google.maps.Geocoder();
                geocoder.geocode({address: ajaxOptions.data.address}, function(results, googleStatus) {
                    if (googleStatus == google.maps.GeocoderStatus.ZERO_RESULTS) {
                        return [];
                    }
                    if (googleStatus == google.maps.GeocoderStatus.OK) {
                        instance._handleServerSuccess(new JIRA.SmartAjax.SmartAjaxResult(
                                {status: 200, googleStatus: googleStatus}, // fake XHR
                                1, // req ID
                                "200 OK",
                                results,
                                true,
                                null));
                    } else {
                        instance.hideSuggestions();
                        instance._handleServerError(new JIRA.SmartAjax.SmartAjaxResult(
                                {status: 500, googleStatus: googleStatus}, // fake XHR
                                1, // req ID
                                "500 not cool",
                                results,
                                false,
                                null));
                    }
                });

            },

            getAjaxOptions: function () {
                var original = this._super();
                original.data.address = original.data.query;
                original.data.sensor = "false";
                // TODO bounds
                return original;
            }
        });

jQuery(function () {

    function getAutoCompleteOptions(element) {

        return {
            element: element, // suggestions container
            id: element.attr("data-field-id"),
            ajaxOptions: {
                dataType: "json",
                url: "irrelevant",
                formatResponse: function (geodata) {
                    var ret = [];

                    if (geodata.status == google.maps.GeocoderStatus.OK) {
                        jQuery.each(geodata, function(i, location) {
                            ret.push(new JCONNECT.GeoItemDescriptor({
                                        label: location.formatted_address,
                                        lat: location.geometry.location.lat,
                                        lng: location.geometry.location.lng
                                    }));
                        });
                    } else {
                        console.log("Error, Google Maps returned status: " + geodata.status)
                    }
                    return ret;
                }
            },
            showDropdownButton: true,
            width: 300,
            overlabel: "Type to look up location"
        };
    }

    /**
     * Find each geo-picker and initialize.
     *
     */
    jQuery(".geo-picker").each(function() {
        var $element = jQuery(this);
        var options = getAutoCompleteOptions($element);
        options.width = 300;
        options.overlabel = "Type to look up location";
        new JCONNECT.LocationDropdown(options);
    });

});