/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.usercompatibility;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.usercompatibility.ApplicationUserUtilAccessException;
import com.atlassian.jira.usercompatibility.DelegatingUserWithKey;
import com.atlassian.jira.usercompatibility.UserWithKey;
import com.atlassian.jira.util.BuildUtilsInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserCompatibilityHelper {
    public static UserWithKey convertUserObject(Object userObject) {
        if (userObject == null) {
            return null;
        }
        if (userObject instanceof User) {
            User user = (User)userObject;
            return new DelegatingUserWithKey(user, UserCompatibilityHelper.getKeyForUser(user));
        }
        if (!UserCompatibilityHelper.isRenameUserImplemented()) {
            throw new IllegalArgumentException("Unknown class representing user: " + userObject.getClass().getName());
        }
        try {
            Class<?> appUsersClass = UserCompatibilityHelper.getApplicationUserClass();
            if (!appUsersClass.isAssignableFrom(userObject.getClass())) {
                throw new IllegalArgumentException("Unknown class representing user: " + userObject.getClass().getName());
            }
            Method getKeyMethod = appUsersClass.getMethod("getKey", new Class[0]);
            String userKey = (String)getKeyMethod.invoke(userObject, new Object[0]);
            Method getUserMethod = appUsersClass.getMethod("getDirectoryUser", new Class[0]);
            User user = (User)getUserMethod.invoke(userObject, new Object[0]);
            return new DelegatingUserWithKey(user, userKey);
        }
        catch (ClassNotFoundException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
        catch (InvocationTargetException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
        catch (IllegalAccessException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
    }

    public static String getKeyForUser(User user) {
        if (user == null) {
            return null;
        }
        if (UserCompatibilityHelper.isRenameUserImplemented()) {
            try {
                Class<?> appUsersClass = Class.forName("com.atlassian.jira.user.ApplicationUsers");
                Method getAppUserKeyMethod = appUsersClass.getMethod("getKeyFor", User.class);
                return (String)getAppUserKeyMethod.invoke(null, user);
            }
            catch (ClassNotFoundException e) {
                throw new ApplicationUserUtilAccessException(e);
            }
            catch (NoSuchMethodException e) {
                throw new ApplicationUserUtilAccessException(e);
            }
            catch (InvocationTargetException e) {
                throw new ApplicationUserUtilAccessException(e);
            }
            catch (IllegalAccessException e) {
                throw new ApplicationUserUtilAccessException(e);
            }
        }
        return IdentifierUtils.toLowerCase((String)user.getName());
    }

    public static User getUserForKey(String key) {
        if (key == null) {
            return null;
        }
        if (UserCompatibilityHelper.isRenameUserImplemented()) {
            UserManager userManager = ComponentAccessor.getUserManager();
            try {
                Method getUserByKeyMethod = userManager.getClass().getMethod("getUserByKey", String.class);
                Object applicationUser = getUserByKeyMethod.invoke((Object)userManager, key);
                if (applicationUser == null) {
                    return null;
                }
                Method getDirectoryUser = applicationUser.getClass().getMethod("getDirectoryUser", new Class[0]);
                return (User)getDirectoryUser.invoke(applicationUser, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new ApplicationUserUtilAccessException(e);
            }
            catch (NoSuchMethodException e) {
                throw new ApplicationUserUtilAccessException(e);
            }
            catch (IllegalAccessException e) {
                throw new ApplicationUserUtilAccessException(e);
            }
        }
        return ComponentAccessor.getUserManager().getUser(key);
    }

    public static boolean isUserObject(Object object) {
        try {
            return object instanceof User || UserCompatibilityHelper.isRenameUserImplemented() && UserCompatibilityHelper.getApplicationUserClass().isInstance(object);
        }
        catch (ClassNotFoundException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
    }

    private static boolean isRenameUserImplemented() {
        int[] versionNumbers = ((BuildUtilsInfo)ComponentAccessor.getComponent(BuildUtilsInfo.class)).getVersionNumbers();
        return versionNumbers[0] >= 6;
    }

    private static Class<?> getApplicationUserClass() throws ClassNotFoundException {
        return Class.forName("com.atlassian.jira.user.ApplicationUser");
    }
}

