/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.rest.resources;

import com.atlassian.jconnect.jira.IssueActivityService;
import com.atlassian.jconnect.jira.IssueHelper;
import com.atlassian.jconnect.jira.JMCProjectService;
import com.atlassian.jconnect.jira.UserHelper;
import com.atlassian.jconnect.rest.entities.CommentEntity;
import com.atlassian.jconnect.rest.entities.IssueEntity;
import com.atlassian.jconnect.rest.entities.IssueWithCommentsEntity;
import com.atlassian.jconnect.rest.entities.IssuesWithCommentsEntity;
import com.atlassian.jconnect.rest.entities.UploadData;
import com.atlassian.jconnect.util.Either;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.util.AttachmentException;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Preconditions;
import com.opensymphony.workflow.InvalidInputException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/issue")
public class IssueResource {
    private static final Logger log = LoggerFactory.getLogger(IssueResource.class);
    private final IssueHelper issueHelper;
    private final UserHelper userHelper;
    private final IssueActivityService issueUpdateService;
    private final CustomFieldManager customFieldManager;
    private final JMCProjectService connectProjectService;
    private static final String CF_NAME_UUID = "uuid";

    public IssueResource(IssueHelper issueHandler, UserHelper userHelper, IssueActivityService issueUpdateService, CustomFieldManager customFieldManager, JMCProjectService connectProjectService) {
        this.issueHelper = issueHandler;
        this.userHelper = userHelper;
        this.issueUpdateService = issueUpdateService;
        this.customFieldManager = customFieldManager;
        this.connectProjectService = connectProjectService;
    }

    @POST
    @AnonymousAllowed
    @Consumes(value={"multipart/form-data"})
    @Path(value="create")
    @Produces(value={"application/json"})
    public Response createIssue(@QueryParam(value="project") String project, @QueryParam(value="apikey") String apikey, @Context HttpServletRequest request) {
        try {
            Either<Project, Response.ResponseBuilder> result = this.lookupProjectByNameOrKey(project, apikey);
            if (result.getRight() != null) {
                return result.getRight().build();
            }
            Map<String, UploadData> data = this.parseUploadData(request);
            UploadData issueData = data.get("issue");
            IssueEntity issueEntity = this.parseIssueEntity(issueData);
            if (issueEntity.isCrash() && !this.connectProjectService.isCrashesEnabledFor(result.getLeft())) {
                IssueWithCommentsEntity issueWithCommentsEntity = new IssueWithCommentsEntity("CRASHES-DISABLED", "crash-reporting-disabled", issueEntity.getSummary(), issueEntity.getDescription(), new Date(), new Date(), Collections.<CommentEntity>emptyList(), false);
                return Response.ok((Object)issueWithCommentsEntity).build();
            }
            ApplicationUser user = this.userHelper.getOrCreateJMCSystemUser();
            CustomField uuid = this.customFieldManager.getCustomFieldObjectByName(CF_NAME_UUID);
            UploadData customfields = data.get("customfields");
            ArrayList<CustomField> customFields = new ArrayList<CustomField>();
            ArrayList<Object> values = new ArrayList<Object>();
            if (customfields != null) {
                this.extractCustomFields(customfields, customFields, values);
            }
            Issue issue = this.issueHelper.createIssue(issueEntity, uuid, result.getLeft(), user, customFields, values);
            this.addAnyAttachments(data, user, issue);
            IssueWithCommentsEntity issueWithCommentsEntity = new IssueWithCommentsEntity(issue.getKey(), issue.getStatusObject().getName(), issue.getSummary(), issue.getDescription(), issue.getCreated(), issue.getUpdated(), Collections.<CommentEntity>emptyList(), false);
            return Response.ok((Object)issueWithCommentsEntity).build();
        }
        catch (IOException e) {
            return this.handleException(e);
        }
        catch (AttachmentException e) {
            return this.handleException((Exception)((Object)e));
        }
        catch (GenericEntityException e) {
            return this.handleException((Exception)((Object)e));
        }
        catch (JSONException e) {
            return this.handleException((Exception)((Object)e));
        }
        catch (CreateException e) {
            if (e.getCause() instanceof InvalidInputException) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
            }
            return this.handleException((Exception)((Object)e));
        }
        catch (FileUploadException e) {
            return this.handleException(e);
        }
    }

    private Response handleException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
    }

    @POST
    @AnonymousAllowed
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Path(value="/comment/{issueKey}")
    public Response addComment(@PathParam(value="issueKey") String issueKey, @QueryParam(value="apikey") String apikey, @Context HttpServletRequest request) {
        try {
            ApplicationUser user = this.userHelper.getOrCreateJMCSystemUser();
            MutableIssue issue = this.issueHelper.getIssue((String)Preconditions.checkNotNull((Object)issueKey, (Object)"issueKey"));
            if (issue == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("The specified issue %s does not exist", issueKey)).build();
            }
            Either<Project, Response.ResponseBuilder> result = this.lookupProjectByNameOrKey(issue.getProjectObject().getKey(), apikey);
            if (result.getRight() != null) {
                return result.getRight().build();
            }
            Map<String, UploadData> data = this.parseUploadData(request);
            UploadData issueData = data.get("issue");
            IssueEntity issueEntity = this.parseIssueEntity(issueData);
            Response.ResponseBuilder errorResponse = this.checkUUIDIsGood(issueEntity, (Issue)issue);
            if (errorResponse != null) {
                return errorResponse.entity((Object)"You are unauthorized to comment on this issue.").build();
            }
            String description = issueEntity.getDescription();
            ErrorCollection errors = this.issueHelper.addComment((Issue)issue, description, user);
            Response.ResponseBuilder commentError = this.checkForCommentErrors(errors, user, (Issue)issue);
            if (commentError != null) {
                return commentError.build();
            }
            this.addAnyAttachments(data, user, (Issue)issue);
            try {
                this.issueHelper.updateIssue(issue, issueEntity, user);
            }
            catch (Throwable e) {
                log.warn("Could not update issue. Comment and attachments still added though.", e);
            }
            ApplicationUser commentUser = user;
            CommentEntity commentEntity = new CommentEntity(user.getKey(), commentUser.getName(), commentUser.getDisplayName(), true, description, new Date(), issue.getKey());
            return Response.ok((Object)commentEntity).build();
        }
        catch (GenericEntityException e) {
            return this.handleException((Exception)((Object)e));
        }
        catch (AttachmentException e) {
            return this.handleException((Exception)((Object)e));
        }
        catch (FileUploadException e) {
            return this.handleException(e);
        }
        catch (IOException e) {
            return this.handleException(e);
        }
        catch (JSONException e) {
            return this.handleException((Exception)((Object)e));
        }
    }

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json"})
    @Path(value="/updates")
    public Response getIssuesAndCommentsFor(@QueryParam(value="project") String project, @QueryParam(value="uuid") String uuid, @QueryParam(value="sinceMillis") long sinceMillis, @QueryParam(value="apikey") String apikey, @Context HttpServletRequest request) {
        Either<Project, Response.ResponseBuilder> result = this.lookupProjectByNameOrKey(project, apikey);
        if (result.getRight() != null) {
            return result.getRight().build();
        }
        request.setAttribute("gzipMimeTypes", (Object)"application/json");
        IssuesWithCommentsEntity issuesWithComments = this.issueUpdateService.getIssuesWithCommentsIfUpdatesExists(result.getLeft(), uuid, sinceMillis);
        return Response.ok((Object)issuesWithComments).lastModified(new Date()).build();
    }

    private Either<Project, Response.ResponseBuilder> lookupProjectByNameOrKey(String projectNameOrKey, String apiKey) {
        if (projectNameOrKey == null) {
            return Either.right(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"project request parameter must be specified."));
        }
        Project project = this.issueHelper.lookupProjectByKey(projectNameOrKey);
        Project project2 = project = project == null ? this.issueHelper.lookupProjectByName(projectNameOrKey) : project;
        if (project == null) {
            return Either.right(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Project: " + projectNameOrKey + " does not exist in this JIRA instance.\n" + "Please add a project called " + projectNameOrKey + " before continuing.\n" + "Alternatively, configure the name of an existing project in your <JCOCustomDataSource> protocol.")));
        }
        if (!this.connectProjectService.isJiraConnectProject(project)) {
            return Either.right(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("JIRA Mobile Connect is not enabled for project: " + project.getKey() + ". Please enable JIRA Mobile Connect in the Project Settings in JIRA for this project.")));
        }
        boolean apiKeyEnabled = this.connectProjectService.isApiKeyEnabledFor(project);
        if (apiKeyEnabled) {
            String projectsApiKey = this.connectProjectService.lookupApiKeyFor(project);
            if (projectsApiKey == null) {
                return Either.right(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Project is missing API Key."));
            }
            if (apiKey == null) {
                return Either.right(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"This request is missing the apikey parameter. Please upgrade the JIRA Mobile Connect SDK."));
            }
            if (!projectsApiKey.equalsIgnoreCase(apiKey)) {
                return Either.right(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Invalid API Key. '" + apiKey + "' Please ensure it is correctly configured.")));
            }
        }
        return Either.left(project);
    }

    private Response.ResponseBuilder checkForCommentErrors(ErrorCollection errors, ApplicationUser user, Issue issue) {
        if (errors.hasAnyErrors()) {
            log.warn(String.format("Errors encountered when %s commented on %s:", user.getKey(), issue.getKey()));
            StringBuilder respsonseStr = new StringBuilder();
            for (String msg : errors.getErrorMessages()) {
                respsonseStr.append(msg).append('\n');
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)respsonseStr.toString());
        }
        log.debug(String.format("User %s commented on %s", user.getKey(), issue.getKey()));
        return null;
    }

    private Response.ResponseBuilder checkUUIDIsGood(IssueEntity issueEntity, Issue issue) {
        CustomField uuid = this.customFieldManager.getCustomFieldObjectByName(CF_NAME_UUID);
        if (uuid == null) {
            return this.handleMissingUUID();
        }
        Object fieldValue = issue.getCustomFieldValue(uuid);
        if (fieldValue == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED);
        }
        String uuidFiedlValue = (String)fieldValue;
        if (!uuidFiedlValue.equals(issueEntity.getUuid())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED);
        }
        return null;
    }

    private Response.ResponseBuilder handleMissingUUID() {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Missing uuid.");
    }

    private void extractCustomFields(UploadData customfields, List<CustomField> fields, List<Object> values) throws JSONException, IOException {
        JSONObject json = new JSONObject(IOUtils.toString(customfields.getInputStream(), "UTF-8"));
        List allCustomFields = this.customFieldManager.getCustomFieldObjects();
        for (CustomField field : allCustomFields) {
            String fieldNameLower = field.getName().toLowerCase();
            if (!json.has(fieldNameLower) && !json.has(field.getName())) continue;
            String fieldValue = json.has(fieldNameLower) ? json.getString(fieldNameLower) : json.getString(field.getName());
            this.addFieldAndValue(fields, values, field, fieldValue);
        }
    }

    private void addFieldAndValue(List<CustomField> fields, List<Object> values, CustomField field, String fieldValue) {
        if (fieldValue != null) {
            try {
                CustomFieldParamsImpl params = new CustomFieldParamsImpl(field, (Object)fieldValue);
                Object valueFromCustomFieldParams = field.getCustomFieldType().getValueFromCustomFieldParams((CustomFieldParams)params);
                if (valueFromCustomFieldParams != null) {
                    values.add(valueFromCustomFieldParams);
                    fields.add(field);
                } else {
                    log.debug("Value for custom field: " + field.getName() + " is null. This field will not be set.");
                }
            }
            catch (Exception e) {
                log.info("Could not validate custom field value for field: " + field.getName() + " with value: " + fieldValue + ". Error: " + e.getMessage());
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void addAnyAttachments(Map<String, UploadData> data, ApplicationUser user, Issue issue) throws IOException, AttachmentException, GenericEntityException {
        Iterator<Map.Entry<String, UploadData>> iterator = data.entrySet().iterator();
        while (iterator.hasNext()) {
            this.addAttachment(user, issue, iterator.next().getValue());
        }
    }

    private void addAttachment(ApplicationUser user, Issue issue, UploadData payload) throws IOException, AttachmentException, GenericEntityException {
        if (this.isValidAttachment(payload)) {
            this.issueHelper.addAttachment(issue, payload, user);
        }
    }

    private Map<String, UploadData> parseUploadData(HttpServletRequest request) throws FileUploadException, IOException {
        ServletFileUpload upload = new ServletFileUpload();
        FileItemIterator iterator = upload.getItemIterator(request);
        HashMap<String, UploadData> data = new HashMap<String, UploadData>();
        while (iterator.hasNext()) {
            try {
                FileItemStream item = iterator.next();
                byte[] bytes = IOUtils.toByteArray(item.openStream());
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                UploadData uploadData = new UploadData(stream, item.getFieldName(), item.getName(), item.getContentType());
                data.put(item.getFieldName(), uploadData);
            }
            catch (FileItemStream.ItemSkippedException e) {
                log.warn("skipped upload content", (Throwable)e);
            }
        }
        return data;
    }

    private IssueEntity parseIssueEntity(UploadData issueData) throws JSONException, IOException {
        InputStream inputStream = issueData.getInputStream();
        JSONObject obj = new JSONObject(IOUtils.toString(inputStream, "UTF-8"));
        return IssueEntity.fromJSONObj(obj);
    }

    private boolean isValidAttachment(UploadData data) {
        return data != null && data.getName() != null && !this.isSystemAttachment(data);
    }

    private boolean isSystemAttachment(UploadData data) {
        return data.getName().equals("issue") || data.getName().equals("customfields");
    }
}

