/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira.tabpanel;

import com.atlassian.jconnect.jira.JMCProjectService;
import com.atlassian.jconnect.jira.tabpanel.AbstractFragment;
import com.atlassian.jconnect.jira.tabpanel.ApplicationVersionChartFragment;
import com.atlassian.jconnect.jira.tabpanel.DeviceModelChartFragment;
import com.atlassian.jconnect.jira.tabpanel.GoogleMapsFragment;
import com.atlassian.jconnect.jira.tabpanel.SystemVersionChartFragment;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanel;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanelModuleDescriptor;
import com.atlassian.jira.project.browse.BrowseContext;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JiraConnectProjectTabPanel
implements ProjectTabPanel {
    static final String I18N_PREFIX = "projecttabpanel";
    private final JMCProjectService projectService;
    private final List<AbstractFragment> fragments;
    private ProjectTabPanelModuleDescriptor descriptor;

    public JiraConnectProjectTabPanel(JMCProjectService projectService, GoogleMapsFragment googleMapsFragment, DeviceModelChartFragment deviceModelChartFragment, SystemVersionChartFragment systemVersionChartFragment, ApplicationVersionChartFragment applicationVersionChartFragment) {
        this.projectService = projectService;
        this.fragments = ImmutableList.of((Object)googleMapsFragment, (Object)deviceModelChartFragment, (Object)systemVersionChartFragment, (Object)applicationVersionChartFragment);
    }

    public void init(ProjectTabPanelModuleDescriptor projectTabPanelModuleDescriptor) {
        this.descriptor = projectTabPanelModuleDescriptor;
    }

    public String getHtml(BrowseContext browseContext) {
        HashMap context = new HashMap();
        ArrayList<AbstractFragment> renderableFragments = new ArrayList<AbstractFragment>(this.fragments.size());
        for (AbstractFragment fragment : this.fragments) {
            if (!fragment.showFragment(browseContext)) continue;
            fragment.init(browseContext, this.descriptor);
            renderableFragments.add(fragment);
        }
        context.put("fragments", renderableFragments);
        return this.descriptor.getHtml("view", context);
    }

    public boolean showPanel(BrowseContext context) {
        return this.projectService.isJiraConnectProject(context.getProject());
    }
}

